/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CustomAnchorManager {
    private static CustomAnchorManager instance;
    private final Plugin plugin;
    private final File anchorFile;
    private final Map<UUID, Location> anchorSpawns = new HashMap<UUID, Location>();

    public CustomAnchorManager(Plugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.anchorFile = new File(plugin.getDataFolder(), "custom_anchors.yml");
        if (!this.anchorFile.exists()) {
            this.anchorFile.getParentFile().mkdirs();
            try {
                this.anchorFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadAnchors();
    }

    public static CustomAnchorManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAnchors() {
        Map<UUID, Location> map = this.anchorSpawns;
        synchronized (map) {
            this.anchorSpawns.clear();
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.anchorFile);
        for (String key : config.getKeys(false)) {
            UUID uuid;
            try {
                uuid = UUID.fromString(key);
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            String worldName = config.getString(key + ".world");
            World world = Bukkit.getWorld((String)worldName);
            int x = config.getInt(key + ".x");
            int y = config.getInt(key + ".y");
            int z = config.getInt(key + ".z");
            Location loc = new Location(world, (double)x, (double)y, (double)z);
            Map<UUID, Location> map2 = this.anchorSpawns;
            synchronized (map2) {
                this.anchorSpawns.put(uuid, loc);
            }
        }
    }

    private void saveSnapshot() {
        HashMap<UUID, Location> snapshot = new HashMap<UUID, Location>(this.anchorSpawns);
        YamlConfiguration config = new YamlConfiguration();
        for (Map.Entry entry : snapshot.entrySet()) {
            UUID uuid = (UUID)entry.getKey();
            Location loc = (Location)entry.getValue();
            World world = loc.getWorld();
            if (!world.getName().startsWith("skygridx_")) continue;
            String key = uuid.toString();
            config.set(key + ".world", (Object)world.getName());
            config.set(key + ".x", (Object)loc.getBlockX());
            config.set(key + ".y", (Object)loc.getBlockY());
            config.set(key + ".z", (Object)loc.getBlockZ());
        }
        try {
            config.save(this.anchorFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save custom_anchors.yml");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomAnchor(Player player, Location loc) {
        World world = loc.getWorld();
        if (world.getName().startsWith("skygridx_")) {
            Map<UUID, Location> map = this.anchorSpawns;
            synchronized (map) {
                this.anchorSpawns.put(player.getUniqueId(), loc);
            }
            this.saveSnapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomAnchor(UUID uuid) {
        Map<UUID, Location> map = this.anchorSpawns;
        synchronized (map) {
            this.anchorSpawns.remove(uuid);
        }
        this.saveSnapshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCustomAnchor(UUID uuid) {
        Map<UUID, Location> map = this.anchorSpawns;
        synchronized (map) {
            return this.anchorSpawns.containsKey(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getCustomAnchor(UUID uuid) {
        Map<UUID, Location> map = this.anchorSpawns;
        synchronized (map) {
            return this.anchorSpawns.get(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<UUID, Location> getAllAnchors() {
        Map<UUID, Location> map = this.anchorSpawns;
        synchronized (map) {
            return new HashMap<UUID, Location>(this.anchorSpawns);
        }
    }
}

