/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CustomBedManager {
    private static CustomBedManager instance;
    private final Plugin plugin;
    private final File bedFile;
    private final Map<UUID, Location> bedSpawns = new HashMap<UUID, Location>();

    public CustomBedManager(Plugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.bedFile = new File(plugin.getDataFolder(), "custom_beds.yml");
        if (!this.bedFile.exists()) {
            this.bedFile.getParentFile().mkdirs();
            try {
                this.bedFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void reloadBeds() {
        CustomBedManager inst = CustomBedManager.getInstance();
        if (inst != null) {
            inst.loadBeds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBeds() {
        Map<UUID, Location> map = this.bedSpawns;
        synchronized (map) {
            this.bedSpawns.clear();
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.bedFile);
        for (String key : config.getKeys(false)) {
            UUID uuid;
            try {
                uuid = UUID.fromString(key);
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            String worldName = config.getString(key + ".world");
            World world = Bukkit.getWorld((String)worldName);
            int x = config.getInt(key + ".x");
            int y = config.getInt(key + ".y");
            int z = config.getInt(key + ".z");
            Location loc = new Location(world, (double)x, (double)y, (double)z);
            Map<UUID, Location> map2 = this.bedSpawns;
            synchronized (map2) {
                this.bedSpawns.put(uuid, loc);
            }
        }
    }

    private synchronized void saveSnapshot() {
        HashMap<UUID, Location> snapshot = new HashMap<UUID, Location>(this.bedSpawns);
        YamlConfiguration config = new YamlConfiguration();
        for (Map.Entry entry : snapshot.entrySet()) {
            UUID uuid = (UUID)entry.getKey();
            Location loc = (Location)entry.getValue();
            World world = loc.getWorld();
            if (!world.getName().startsWith("skygridx_") || world.getEnvironment() == World.Environment.NETHER || world.getEnvironment() == World.Environment.THE_END) continue;
            String key = uuid.toString();
            config.set(key + ".world", (Object)world.getName());
            config.set(key + ".x", (Object)loc.getBlockX());
            config.set(key + ".y", (Object)loc.getBlockY());
            config.set(key + ".z", (Object)loc.getBlockZ());
        }
        try {
            config.save(this.bedFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save custom_beds.yml");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomBed(Player player, Location loc) {
        World world = loc.getWorld();
        if (world.getName().startsWith("skygridx_") && world.getEnvironment() != World.Environment.NETHER && world.getEnvironment() != World.Environment.THE_END) {
            Map<UUID, Location> map = this.bedSpawns;
            synchronized (map) {
                this.bedSpawns.put(player.getUniqueId(), loc);
            }
            this.saveSnapshot();
        }
    }

    public void removeCustomBed(Player player) {
        this.removeCustomBed(player.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomBed(UUID uuid) {
        Map<UUID, Location> map = this.bedSpawns;
        synchronized (map) {
            this.bedSpawns.remove(uuid);
        }
        this.saveSnapshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getCustomBed(UUID uuid) {
        Map<UUID, Location> map = this.bedSpawns;
        synchronized (map) {
            return this.bedSpawns.get(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCustomBed(UUID uuid) {
        Map<UUID, Location> map = this.bedSpawns;
        synchronized (map) {
            return this.bedSpawns.containsKey(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<UUID, Location> getAllBeds() {
        Map<UUID, Location> map = this.bedSpawns;
        synchronized (map) {
            return new HashMap<UUID, Location>(this.bedSpawns);
        }
    }

    public static CustomBedManager getInstance() {
        return instance;
    }
}

