/*
 * Decompiled with CFR 0.152.
 */
package main;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import main.ChestRegionData;
import main.EnchantmentNameSupport;
import main.TippedArrowRandomizer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.LootTables;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CustomChest {
    private static CustomChest instance;
    private static JavaPlugin plugin;
    private static int maxItemsPerSlot;
    private static final Material[] MATERIALS;
    public static NamespacedKey UNPOPULATED_KEY;
    private static NamespacedKey CUSTOM_REF_KEY;
    private final Int2ObjectMap<ChestConfig> chestConfigsByHash = new Int2ObjectOpenHashMap();
    private final Map<String, ChestConfig> chestConfigsByName = new HashMap<String, ChestConfig>();
    private final Map<String, IntSet> biomeToChestHashes = new HashMap<String, IntSet>();

    private CustomChest(JavaPlugin plugin) {
        CustomChest.plugin = plugin;
        UNPOPULATED_KEY = new NamespacedKey((Plugin)plugin, "custom_loot_unpopulated");
        CUSTOM_REF_KEY = new NamespacedKey((Plugin)plugin, "custom_loot_pointer");
        this.loadChestSettingsAsync();
    }

    public static CustomChest getInstance(JavaPlugin plugin) {
        if (instance == null) {
            instance = new CustomChest(plugin);
        }
        return instance;
    }

    public void loadChest(Block block) {
        ArrayList<ChestRegionData.ChestRecord> records = new ArrayList<ChestRegionData.ChestRecord>(1);
        this.loadChest(block, records);
        if (!records.isEmpty()) {
            ChestRegionData.getInstance(plugin).registerChests(records);
        }
    }

    public void loadChest(Block block, List<ChestRegionData.ChestRecord> records) {
        BlockState blockState = block.getState();
        if (!(blockState instanceof Chest)) {
            return;
        }
        Chest chest = (Chest)blockState;
        String biomeRaw = block.getBiome().getKey().getKey().toUpperCase();
        IntSet possible = this.biomeToChestHashes.getOrDefault(biomeRaw, (IntSet)((Object)new IntOpenHashSet()));
        if (possible.isEmpty()) {
            plugin.getLogger().warning("No chest config for biome: " + biomeRaw + " at " + String.valueOf(chest.getLocation()));
            return;
        }
        ChestConfig cfg = (ChestConfig)this.chestConfigsByHash.get(possible.iterator().nextInt());
        if (cfg == null) {
            plugin.getLogger().warning("Chest config is null for biome: " + biomeRaw);
            return;
        }
        if (cfg.hasLootPool()) {
            ChestConfig ref;
            PoolEntry pick = cfg.selectRandomLootPool();
            if (pick == null) {
                return;
            }
            if (pick.vanillaTable != null) {
                records.add(new ChestRegionData.ChestRecord(chest.getLocation(), ChestRegionData.ChestType.VANILLA, pick.vanillaTable.getKey().toString()));
                return;
            }
            if (pick.customRefName != null && (ref = this.chestConfigsByName.get(pick.customRefName)) != null && ref.itemsData != null) {
                records.add(new ChestRegionData.ChestRecord(chest.getLocation(), ChestRegionData.ChestType.CUSTOM, pick.customRefName));
            }
            return;
        }
        if (cfg.itemsData != null) {
            records.add(new ChestRegionData.ChestRecord(chest.getLocation(), ChestRegionData.ChestType.CUSTOM, null));
        }
    }

    public void populateChestOnOpen(final Chest chest, ChestRegionData.ChestInfo info) {
        ChestConfig cfg = null;
        if (info != null && info.lootTableKey != null) {
            cfg = this.chestConfigsByName.get(info.lootTableKey);
        }
        if (cfg == null) {
            String biomeKey = chest.getBlock().getBiome().getKey().getKey().toUpperCase();
            IntSet set = this.biomeToChestHashes.getOrDefault(biomeKey, (IntSet)((Object)new IntOpenHashSet()));
            if (set.isEmpty()) {
                plugin.getLogger().warning("No chest config for biome: " + biomeKey + " when populating chest");
                return;
            }
            cfg = (ChestConfig)this.chestConfigsByHash.get(set.iterator().nextInt());
        }
        if (cfg == null || cfg.itemsData == null) {
            return;
        }
        this.calculateItemsToPlace(cfg.itemsData, chest.getInventory()).thenAccept(stacks -> new BukkitRunnable((ItemStack[])stacks){
            final /* synthetic */ ItemStack[] val$stacks;
            {
                this.val$stacks = itemStackArray;
            }

            public void run() {
                CustomChest.this.placeItemsInChest(chest.getInventory(), this.val$stacks);
            }
        }.runTask((Plugin)plugin));
    }

    public void populateLegacyChestOnOpen(final Chest chest) {
        ChestConfig cfg;
        String refName = (String)chest.getPersistentDataContainer().get(CUSTOM_REF_KEY, PersistentDataType.STRING);
        if (refName != null) {
            cfg = this.chestConfigsByName.get(refName);
        } else {
            String biomeKey = chest.getBlock().getBiome().getKey().getKey().toUpperCase();
            IntSet set = this.biomeToChestHashes.getOrDefault(biomeKey, (IntSet)((Object)new IntOpenHashSet()));
            if (set.isEmpty()) {
                return;
            }
            cfg = (ChestConfig)this.chestConfigsByHash.get(set.iterator().nextInt());
        }
        if (cfg == null || cfg.itemsData == null) {
            return;
        }
        this.calculateItemsToPlace(cfg.itemsData, chest.getInventory()).thenAccept(stacks -> new BukkitRunnable((ItemStack[])stacks){
            final /* synthetic */ ItemStack[] val$stacks;
            {
                this.val$stacks = itemStackArray;
            }

            public void run() {
                CustomChest.this.placeItemsInChest(chest.getInventory(), this.val$stacks);
            }
        }.runTask((Plugin)plugin));
    }

    private CompletableFuture<ItemStack[]> calculateItemsToPlace(ItemsData data, Inventory inv) {
        return CompletableFuture.supplyAsync(() -> {
            int[] slots;
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            ItemStack[] out = new ItemStack[inv.getSize()];
            int[] counts = this.getCurrentItemCounts(inv);
            List<Integer> free = this.getEmptySlotList(inv);
            for (ItemSettings chance : data.chanceItems) {
                int amt;
                if (rng.nextDouble(100.0) >= chance.chancePerChestPercent) continue;
                if (free.isEmpty()) break;
                int slot = free.remove(rng.nextInt(free.size()));
                int left = chance.maxAmount - counts[chance.materialOrdinal];
                if (left <= 0 || (amt = rng.nextInt(chance.minAmount, Math.min(left, maxItemsPerSlot) + 1)) <= 0) continue;
                out[slot] = this.buildStack(chance, amt, rng);
                int n = chance.materialOrdinal;
                counts[n] = counts[n] + amt;
            }
            for (int s : slots = free.stream().mapToInt(i -> i).toArray()) {
                int amt;
                int cap;
                int left;
                ItemSettings picked = data.getRandomWeightedItem();
                if (picked == null || (left = picked.maxAmount - counts[picked.materialOrdinal]) <= 0 || (cap = Math.min(left, maxItemsPerSlot)) < picked.minAmount || (amt = rng.nextInt(picked.minAmount, cap + 1)) <= 0) continue;
                out[s] = this.buildStack(picked, amt, rng);
                int n = picked.materialOrdinal;
                counts[n] = counts[n] + amt;
            }
            return out;
        });
    }

    private ItemStack buildStack(ItemSettings settings, int amount, ThreadLocalRandom rng) {
        Material mat = MATERIALS[settings.materialOrdinal];
        ItemStack stack = new ItemStack(mat, amount);
        if (settings.customName != null && !settings.customName.isEmpty()) {
            ItemMeta nm = stack.getItemMeta();
            nm.setDisplayName(settings.customName);
            stack.setItemMeta(nm);
        }
        if (!settings.enchantments.isEmpty()) {
            if (mat == Material.ENCHANTED_BOOK) {
                EnchantmentStorageMeta storage = (EnchantmentStorageMeta)stack.getItemMeta();
                for (EnchantmentSetting es : settings.enchantments) {
                    Enchantment ench;
                    int lvl;
                    if (!(rng.nextDouble(100.0) < es.weight) || (lvl = rng.nextInt(es.minLevel, es.maxLevel + 1)) <= 0 || (ench = Enchantment.getByName((String)es.enchantmentName.toUpperCase())) == null) continue;
                    storage.addStoredEnchant(ench, lvl, true);
                }
                stack.setItemMeta((ItemMeta)storage);
            } else {
                ItemMeta meta = stack.getItemMeta();
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                ArrayList<CallSite> lore = meta.hasLore() ? new ArrayList<CallSite>(meta.getLore()) : new ArrayList();
                String lt = "standard".equalsIgnoreCase(settings.levelType) ? "Standard" : "Roman";
                for (EnchantmentSetting es : settings.enchantments) {
                    Enchantment ench;
                    int lvl;
                    if (!(rng.nextDouble(100.0) < es.weight) || (lvl = rng.nextInt(es.minLevel, es.maxLevel + 1)) <= 0 || (ench = Enchantment.getByName((String)es.enchantmentName.toUpperCase())) == null) continue;
                    meta.addEnchant(ench, lvl, true);
                    Object lvlText = lt.equals("Standard") ? "lvl_" + lvl : EnchantmentNameSupport.toRoman(lvl);
                    String color = EnchantmentNameSupport.getColor(es.loreColor);
                    String name = EnchantmentNameSupport.getFriendlyName(ench);
                    lore.add((CallSite)((Object)(color + name + " " + (String)lvlText)));
                }
                meta.setLore(lore);
                stack.setItemMeta(meta);
            }
        }
        if (mat == Material.TIPPED_ARROW) {
            TippedArrowRandomizer randomizer = new TippedArrowRandomizer();
            randomizer.randomizeTippedArrow(stack);
        }
        return stack;
    }

    private List<Integer> getEmptySlotList(Inventory inv) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        ItemStack[] cont = inv.getContents();
        for (int i = 0; i < cont.length; ++i) {
            if (cont[i] != null) continue;
            list.add(i);
        }
        return list;
    }

    private int[] getCurrentItemCounts(Inventory inv) {
        int[] arr = new int[MATERIALS.length];
        for (ItemStack it : inv.getContents()) {
            if (it == null) continue;
            int n = it.getType().ordinal();
            arr[n] = arr[n] + it.getAmount();
        }
        return arr;
    }

    private void placeItemsInChest(Inventory inv, ItemStack[] items) {
        ItemStack[] base = inv.getContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            base[i] = items[i];
        }
        inv.setContents(base);
    }

    private void loadChestSettingsAsync() {
        CompletableFuture.runAsync(() -> {
            File f = new File(plugin.getDataFolder(), "SkygridBlocks/ChestSettings.yml");
            if (!f.exists()) {
                plugin.getLogger().severe("ChestSettings.yml not found.");
                return;
            }
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)f);
            maxItemsPerSlot = cfg.getInt("MaxItemsPerSlot", 2);
            this.chestConfigsByHash.clear();
            this.chestConfigsByName.clear();
            this.biomeToChestHashes.clear();
            if (!cfg.isConfigurationSection("ChestSettings")) {
                plugin.getLogger().severe("Missing ChestSettings section");
                return;
            }
            ConfigurationSection root = cfg.getConfigurationSection("ChestSettings");
            for (String key : root.getKeys(false)) {
                ChestConfig c = this.parseSingleChest(key, root.getConfigurationSection(key));
                this.chestConfigsByHash.put(key.hashCode(), c);
                this.chestConfigsByName.put(key, c);
                for (String b : root.getStringList(key + ".Biomes")) {
                    this.biomeToChestHashes.computeIfAbsent(b.toUpperCase(), __ -> new IntOpenHashSet()).add(key.hashCode());
                }
            }
        });
    }

    private ChestConfig parseSingleChest(String key, ConfigurationSection sec) {
        ChestConfig cfg = new ChestConfig();
        if (sec.contains("LootTables")) {
            for (Object o : sec.getList("LootTables")) {
                Map map;
                if (!(o instanceof Map) || (map = (Map)o).size() != 1) continue;
                Map.Entry e = map.entrySet().iterator().next();
                String name = e.getKey().toString();
                double w = 1.0;
                Object object = e.getValue();
                if (object instanceof List) {
                    List props = (List)object;
                    for (Object p : props) {
                        Map pm;
                        if (!(p instanceof Map) || !(pm = (Map)p).containsKey("Weight")) continue;
                        w = this.tryParseDouble(pm.get("Weight"), 1.0);
                    }
                }
                PoolEntry pe = new PoolEntry();
                pe.weight = w;
                try {
                    pe.vanillaTable = LootTables.valueOf((String)name.toUpperCase()).getLootTable();
                }
                catch (IllegalArgumentException ex) {
                    pe.customRefName = name;
                }
                cfg.lootPool.add(pe);
            }
        }
        if (sec.contains("Items")) {
            Object raw = sec.get("Items");
            Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
            if (raw instanceof List) {
                List list = (List)raw;
                for (Object o : list) {
                    if (o instanceof String) {
                        String s = (String)o;
                        this.parseCompactItemString(s, (Object2ReferenceMap<Integer, ItemSettings>)((Object)map));
                        continue;
                    }
                    if (!(o instanceof Map)) continue;
                    Map m = (Map)o;
                    this.parseExpandedItemNode(m, (Object2ReferenceMap<Integer, ItemSettings>)((Object)map));
                }
            }
            cfg.itemsData = new ItemsData((Object2ReferenceMap<Integer, ItemSettings>)((Object)map));
        }
        return cfg;
    }

    private void parseCompactItemString(String s, Object2ReferenceMap<Integer, ItemSettings> map) {
        int max;
        String[] p = s.split(":");
        if (p.length < 3) {
            return;
        }
        Material mat = Material.matchMaterial((String)p[0]);
        if (mat == null) {
            plugin.getLogger().warning("Bad material: " + s);
            return;
        }
        boolean pct = p[1].endsWith("p") || p[1].endsWith("P");
        double num = this.tryParseDouble(p[1].replace("p", "").replace("P", ""), 1.0);
        int min = 1;
        if (p[2].contains("-")) {
            String[] r = p[2].split("-");
            min = (int)this.tryParseDouble(r[0], 1.0);
            max = (int)this.tryParseDouble(r[1], 1.0);
        } else {
            max = (int)this.tryParseDouble(p[2], 1.0);
        }
        ItemSettings it = new ItemSettings(mat.ordinal(), pct ? 1.0 : num, min, max);
        if (pct) {
            it.chancePerChestPercent = num;
        }
        map.put(mat.ordinal(), it);
    }

    private void parseExpandedItemNode(Map<?, ?> node, Object2ReferenceMap<Integer, ItemSettings> map) {
        if (node.size() != 1) {
            return;
        }
        Map.Entry<?, ?> e = node.entrySet().iterator().next();
        Material mat = Material.matchMaterial((String)e.getKey().toString());
        if (mat == null) {
            return;
        }
        double weight = 1.0;
        double chance = -1.0;
        int min = 1;
        int max = 1;
        String cname = null;
        String ltype = null;
        ArrayList<EnchantmentSetting> ench = new ArrayList<EnchantmentSetting>();
        Object object = e.getValue();
        if (object instanceof List) {
            List list = (List)object;
            for (Object o : list) {
                if (!(o instanceof Map)) continue;
                Map m = (Map)o;
                for (Map.Entry sub : m.entrySet()) {
                    String k;
                    switch (k = sub.getKey().toString()) {
                        case "Weight": {
                            weight = this.tryParseDouble(sub.getValue(), weight);
                            break;
                        }
                        case "ChancePerChest": {
                            chance = this.tryParseDouble(sub.getValue(), chance);
                            break;
                        }
                        case "MinAmount": {
                            min = (int)this.tryParseDouble(sub.getValue(), min);
                            break;
                        }
                        case "MaxAmount": {
                            max = (int)this.tryParseDouble(sub.getValue(), max);
                            break;
                        }
                        case "CustomName": {
                            cname = sub.getValue().toString();
                            break;
                        }
                        case "LevelType": {
                            ltype = sub.getValue().toString();
                            break;
                        }
                        case "Enchantments": {
                            this.buildEnchantList(sub.getValue(), ench);
                        }
                    }
                }
            }
        }
        ItemSettings it = new ItemSettings(mat.ordinal(), weight, min, max, cname, ench, ltype);
        if (chance >= 0.0) {
            it.chancePerChestPercent = chance;
        }
        map.put(mat.ordinal(), it);
    }

    private void buildEnchantList(Object raw, List<EnchantmentSetting> out) {
        if (!(raw instanceof List)) {
            return;
        }
        List list = (List)raw;
        for (Object o : list) {
            Map m;
            if (!(o instanceof Map) || (m = (Map)o).size() != 1) continue;
            Map.Entry e = m.entrySet().iterator().next();
            String name = e.getKey().toString();
            double w = 0.0;
            int min = 0;
            int max = 0;
            String col = null;
            Object object = e.getValue();
            if (object instanceof List) {
                List props = (List)object;
                for (Object p : props) {
                    if (!(p instanceof Map)) continue;
                    Map pm = (Map)p;
                    for (Map.Entry en : pm.entrySet()) {
                        String kk;
                        switch (kk = en.getKey().toString()) {
                            case "Weight": {
                                w = this.tryParseDouble(en.getValue(), w);
                                break;
                            }
                            case "MinLevel": {
                                min = (int)this.tryParseDouble(en.getValue(), min);
                                break;
                            }
                            case "MaxLevel": {
                                max = (int)this.tryParseDouble(en.getValue(), max);
                                break;
                            }
                            case "LoreColor": {
                                col = en.getValue().toString();
                            }
                        }
                    }
                }
            }
            out.add(new EnchantmentSetting(name, w, min, max, col));
        }
    }

    private double tryParseDouble(Object v, double def) {
        try {
            return Double.parseDouble(v.toString());
        }
        catch (Exception ex) {
            return def;
        }
    }

    static {
        MATERIALS = Material.values();
    }

    static class ChestConfig {
        final List<PoolEntry> lootPool = new ArrayList<PoolEntry>();
        ItemsData itemsData;

        ChestConfig() {
        }

        boolean hasLootPool() {
            return !this.lootPool.isEmpty();
        }

        PoolEntry selectRandomLootPool() {
            double total = 0.0;
            for (PoolEntry e : this.lootPool) {
                total += e.weight;
            }
            if (total <= 0.0) {
                return null;
            }
            double r = ThreadLocalRandom.current().nextDouble(total);
            double acc = 0.0;
            for (PoolEntry e : this.lootPool) {
                if (!(r < (acc += e.weight))) continue;
                return e;
            }
            return this.lootPool.get(0);
        }
    }

    static class PoolEntry {
        LootTable vanillaTable;
        String customRefName;
        double weight;

        PoolEntry() {
        }
    }

    static class ItemsData {
        final List<ItemSettings> chanceItems = new ArrayList<ItemSettings>();
        final ItemSettings[] weightArr;
        final double[] cum;
        final double total;

        ItemsData(Object2ReferenceMap<Integer, ItemSettings> src) {
            ArrayList<ItemSettings> wl = new ArrayList<ItemSettings>();
            for (ItemSettings s : src.values()) {
                if (s.usesChanceMode()) {
                    this.chanceItems.add(s);
                    continue;
                }
                wl.add(s);
            }
            this.weightArr = wl.toArray(new ItemSettings[0]);
            this.cum = new double[this.weightArr.length];
            double a = 0.0;
            for (int i = 0; i < this.weightArr.length; ++i) {
                this.cum[i] = a += this.weightArr[i].weight;
            }
            this.total = a;
        }

        ItemSettings getRandomWeightedItem() {
            if (this.total <= 0.0) {
                return null;
            }
            double r = ThreadLocalRandom.current().nextDouble(this.total);
            int idx = Arrays.binarySearch(this.cum, r);
            if (idx < 0) {
                idx = -idx - 1;
            }
            return this.weightArr[idx];
        }
    }

    static class ItemSettings {
        int materialOrdinal;
        double weight;
        int minAmount;
        int maxAmount;
        String customName;
        List<EnchantmentSetting> enchantments;
        String levelType;
        double chancePerChestPercent = -1.0;

        ItemSettings(int ord, double w, int min, int max) {
            this(ord, w, min, max, null, new ArrayList<EnchantmentSetting>(), null);
        }

        ItemSettings(int ord, double w, int min, int max, String cn, List<EnchantmentSetting> el, String lt) {
            this.materialOrdinal = ord;
            this.weight = w;
            this.minAmount = min;
            this.maxAmount = max;
            this.customName = cn;
            this.enchantments = el;
            this.levelType = lt;
        }

        boolean usesChanceMode() {
            return this.chancePerChestPercent >= 0.0;
        }
    }

    static class EnchantmentSetting {
        String enchantmentName;
        double weight;
        int minLevel;
        int maxLevel;
        String loreColor;

        EnchantmentSetting(String n, double w, int min, int max, String c) {
            this.enchantmentName = n;
            this.weight = w;
            this.minLevel = min;
            this.maxLevel = max;
            this.loreColor = c;
        }
    }
}

