/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomConfig {
    private final JavaPlugin plugin;
    private final Path configFilePath;

    public CustomConfig(JavaPlugin plugin, String fileName) {
        this.plugin = plugin;
        this.configFilePath = Paths.get(plugin.getDataFolder().getPath(), fileName);
    }

    public void saveConfig(String content) {
        try (BufferedWriter writer = Files.newBufferedWriter(this.configFilePath, new OpenOption[0]);){
            writer.write(content);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save config", e);
        }
    }

    public String loadConfig() {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = Files.newBufferedReader(this.configFilePath);){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line).append("\n");
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not load config", e);
        }
        return content.toString();
    }
}

