/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Random;
import main.VoidWorldGenerator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.boss.DragonBattle;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DragonSpawnListener
implements Listener {
    private final JavaPlugin plugin;

    public DragonSpawnListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onDragonSpawn(CreatureSpawnEvent event) {
        if (event.getEntityType() != EntityType.ENDER_DRAGON) {
            return;
        }
        final World world = event.getLocation().getWorld();
        if (world == null || !world.getName().equals("skygridx_world_the_end")) {
            return;
        }
        DragonBattle battle = world.getEnderDragonBattle();
        if (battle == null) {
            return;
        }
        if (!battle.hasBeenPreviouslyKilled()) {
            new BukkitRunnable(){

                public void run() {
                    DragonSpawnListener.this.clearObstructions(world);
                    DragonSpawnListener.this.generatePillars(world);
                }
            }.runTaskLater((Plugin)this.plugin, 100L);
        }
    }

    private void clearObstructions(World world) {
        int clearRadius = 52;
        int r2 = clearRadius * clearRadius;
        for (EnderCrystal crystal : world.getEntitiesByClass(EnderCrystal.class)) {
            int z;
            Location loc = crystal.getLocation();
            int x = loc.getBlockX();
            if (x * x + (z = loc.getBlockZ()) * z > r2 || !(loc.getY() >= 65.0) || !(loc.getY() <= 110.0)) continue;
            crystal.remove();
        }
        for (int x = -clearRadius; x <= clearRadius; ++x) {
            for (int z = -clearRadius; z <= clearRadius; ++z) {
                if (x * x + z * z > r2) continue;
                for (int y = 65; y <= 110; ++y) {
                    world.getBlockAt(x, y, z).setType(Material.AIR);
                }
            }
        }
    }

    private void generatePillars(World world) {
        Random random = new Random();
        int pillarCount = 10;
        int mainRadius = 42;
        for (int i = 0; i < pillarCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)pillarCount;
            int centerX = (int)Math.round((double)mainRadius * Math.cos(angle));
            int centerZ = (int)Math.round((double)mainRadius * Math.sin(angle));
            int radius = 2 + random.nextInt(4);
            int height = 73 + random.nextInt(18);
            for (int[] off : switch (radius) {
                case 2 -> VoidWorldGenerator.OFFSETS_RADIUS_2;
                case 3 -> VoidWorldGenerator.OFFSETS_RADIUS_3;
                case 4 -> VoidWorldGenerator.OFFSETS_RADIUS_4;
                case 5 -> VoidWorldGenerator.OFFSETS_RADIUS_5;
                default -> new int[][]{{0, 0}};
            }) {
                int x = centerX + off[0];
                int z = centerZ + off[1];
                for (int y = 0; y <= height; ++y) {
                    world.getBlockAt(x, y, z).setType(Material.OBSIDIAN);
                }
            }
            world.getBlockAt(centerX, height + 1, centerZ).setType(Material.BEDROCK);
            world.spawn(new Location(world, (double)centerX + 0.5, (double)(height + 2), (double)centerZ + 0.5), EnderCrystal.class);
        }
    }
}

