/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import main.Cc;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantmentNameSupport {
    public static void applyCustomEnchantDisplay(ItemStack item, List<ChosenEnchantment> chosenEnchants) {
        ArrayList<CallSite> newLore;
        if (item == null || chosenEnchants == null || chosenEnchants.isEmpty()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        ArrayList<CallSite> arrayList = newLore = meta.hasLore() ? new ArrayList<CallSite>(meta.getLore()) : new ArrayList();
        if (item.getType() == Material.ENCHANTED_BOOK && meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta storage = (EnchantmentStorageMeta)meta;
            for (ChosenEnchantment c : chosenEnchants) {
                storage.addStoredEnchant(c.enchantment(), c.level(), true);
            }
            item.setItemMeta((ItemMeta)storage);
            return;
        }
        for (ChosenEnchantment c : chosenEnchants) {
            meta.addEnchant(c.enchantment(), c.level(), true);
            Object displayLevel = c.levelType().equalsIgnoreCase("Standard") ? "lvl_" + c.level() : EnchantmentNameSupport.toRoman(c.level());
            String color = EnchantmentNameSupport.getColor(c.loreColor);
            String name = EnchantmentNameSupport.getFriendlyName(c.enchantment());
            newLore.add((CallSite)((Object)(color + name + " " + (String)displayLevel)));
        }
        meta.setLore(newLore);
        item.setItemMeta(meta);
    }

    public static String getFriendlyName(Enchantment enchantment) {
        String key = enchantment.getKey().getKey();
        String[] parts = key.split("_");
        StringBuilder out = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            out.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1).toLowerCase()).append(' ');
        }
        return out.toString().trim();
    }

    static String toRoman(int number) {
        if (number <= 0) {
            return String.valueOf(number);
        }
        int[] vals = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] romans = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < vals.length; ++i) {
            while (number >= vals[i]) {
                number -= vals[i];
                r.append(romans[i]);
            }
        }
        return r.toString();
    }

    public static String getColor(String colorName) {
        if (colorName == null) {
            return Cc.GRAY.getMinecraft();
        }
        switch (colorName.trim().toUpperCase()) {
            case "BLACK": {
                return Cc.BLACK.getMinecraft();
            }
            case "DARK_BLUE": {
                return Cc.DARK_BLUE.getMinecraft();
            }
            case "DARK_GREEN": {
                return Cc.DARK_GREEN.getMinecraft();
            }
            case "DARK_AQUA": {
                return Cc.DARK_AQUA.getMinecraft();
            }
            case "DARK_RED": {
                return Cc.DARK_RED.getMinecraft();
            }
            case "DARK_PURPLE": {
                return Cc.DARK_PURPLE.getMinecraft();
            }
            case "GOLD": {
                return Cc.GOLD.getMinecraft();
            }
            case "GRAY": {
                return Cc.GRAY.getMinecraft();
            }
            case "DARK_GRAY": {
                return Cc.DARK_GRAY.getMinecraft();
            }
            case "BLUE": {
                return Cc.BLUE.getMinecraft();
            }
            case "GREEN": {
                return Cc.GREEN.getMinecraft();
            }
            case "AQUA": {
                return Cc.AQUA.getMinecraft();
            }
            case "RED": {
                return Cc.RED.getMinecraft();
            }
            case "LIGHT_PURPLE": {
                return Cc.LIGHT_PURPLE.getMinecraft();
            }
            case "YELLOW": {
                return Cc.YELLOW.getMinecraft();
            }
            case "WHITE": {
                return Cc.WHITE.getMinecraft();
            }
        }
        return Cc.GRAY.getMinecraft();
    }

    public record ChosenEnchantment(Enchantment enchantment, int level, String levelType, String loreColor) {
    }
}

