/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.EnumSet;
import main.Cc;
import main.CustomBedManager;
import main.PluginSettings;
import main.TPRCommand;
import main.WorldManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EventControl
implements Listener {
    private final Plugin plugin;
    private final TPRCommand tpr;
    private static final String INITIALIZE_MESSAGE = "EventControl Enabled.";
    private static final String ON_MESSAGE = Cc.logO(Cc.GREEN, "Event control logging enabled.");
    private static final String OFF_MESSAGE = Cc.logO(Cc.GREEN, "Event control logging disabled.");
    private boolean loggingEnabled = false;
    private static boolean BlockGrowEventToggle = PluginSettings.isBlockGrowEvent();
    private static boolean BlockFadeEventToggle = PluginSettings.isBlockFadeEvent();
    private static boolean BlockFromToEventToggle = PluginSettings.isBlockFromToEvent();
    private static boolean StructureGrowEventToggle = PluginSettings.isStructureGrowEvent();
    private static boolean BlockSpreadEventToggle = PluginSettings.isBlockSpreadEvent();
    private static boolean BlockIgniteEventToggle = PluginSettings.isBlockIgniteEvent();
    private static boolean BlockFormEventToggle = PluginSettings.isBlockFormEvent();
    private static boolean EntityChangeBlockEventToggle = PluginSettings.isEntityChangeBlockEvent();
    private static final EnumSet<Material> GRAVITY_AFFECTED_BLOCKS = PluginSettings.getGravityAffectedBlocks();
    private static final EnumSet<Material> IS_FLOATING = EnumSet.of(Material.AIR, Material.VOID_AIR);
    private static final EnumSet<Material> FARMLAND_CROPS = EnumSet.of(Material.WHEAT, new Material[]{Material.CARROTS, Material.POTATOES, Material.BEETROOTS, Material.MELON_STEM, Material.PUMPKIN_STEM});
    private static final EnumSet<Material> VINES = EnumSet.of(Material.CAVE_VINES, Material.CAVE_VINES_PLANT);

    public EventControl(Plugin plugin, TPRCommand tpr) {
        this.plugin = plugin;
        this.tpr = tpr;
    }

    public void initialize() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        Cc.logSB(INITIALIZE_MESSAGE);
    }

    public void enableLogging() {
        this.loggingEnabled = true;
        Cc.logSB(ON_MESSAGE);
    }

    public void disableLogging() {
        this.loggingEnabled = false;
        Cc.logSB(OFF_MESSAGE);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockGrow(BlockGrowEvent event) {
        if (!WorldManager.isCustomWorld(event.getBlock())) {
            return;
        }
        if (BlockGrowEventToggle) {
            Block block = event.getBlock();
            Material cropType = event.getNewState().getType();
            if (FARMLAND_CROPS.contains(cropType)) {
                Block blockBelow = block.getRelative(0, -1, 0);
                if (blockBelow.getType() != Material.FARMLAND) {
                    event.setCancelled(true);
                }
            } else {
                Block blockBelow = block.getRelative(0, -2, 0);
                if (IS_FLOATING.contains(blockBelow.getType())) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onStructureGrow(StructureGrowEvent event) {
        Block block;
        Block blockBelow;
        if (!WorldManager.isCustomWorld(event.getLocation().getBlock())) {
            return;
        }
        if (StructureGrowEventToggle && IS_FLOATING.contains((blockBelow = (block = event.getLocation().getBlock()).getRelative(0, -1, 0)).getType())) {
            event.setCancelled(true);
            if (this.loggingEnabled) {
                Cc.logSB("Cancelled sapling growth event at: " + String.valueOf(block.getLocation()));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockSpread(BlockSpreadEvent event) {
        if (!WorldManager.isCustomWorld(event.getBlock())) {
            return;
        }
        if (BlockSpreadEventToggle) {
            Block attachmentBlock;
            Block sourceBlock = event.getSource();
            Block targetBlock = event.getBlock();
            Material sourceType = sourceBlock.getType();
            if (sourceType == Material.BAMBOO_SAPLING) {
                Block blockBelow = targetBlock.getRelative(0, -2, 0);
                if (IS_FLOATING.contains(blockBelow.getType())) {
                    event.setCancelled(true);
                    if (this.loggingEnabled) {
                        Cc.logSB("Cancelled Bamboo sapling growth event at: " + String.valueOf(targetBlock.getLocation()));
                    }
                }
            } else if (VINES.contains(sourceType) && IS_FLOATING.contains((attachmentBlock = targetBlock.getRelative(0, 2, 0)).getType())) {
                event.setCancelled(true);
                if (this.loggingEnabled) {
                    Cc.logSB("Cancelled Cave Vines growth event: No solid attachment block at " + String.valueOf(targetBlock.getLocation()));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockForm(BlockFormEvent event) {
        if (!WorldManager.isCustomWorld(event.getBlock())) {
            return;
        }
        if (BlockFormEventToggle) {
            Block block = event.getBlock();
            Material newStateType = event.getNewState().getType();
            Block belowBlock = block.getRelative(BlockFace.DOWN);
            Material belowMaterial = belowBlock.getType();
            if (newStateType == Material.SNOW && GRAVITY_AFFECTED_BLOCKS.contains(belowMaterial)) {
                event.setCancelled(true);
                if (this.loggingEnabled) {
                    Cc.logSB("Cancelled snow form event at: " + String.valueOf(block.getLocation()));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockFade(BlockFadeEvent event) {
        if (!WorldManager.isCustomWorld(event.getBlock())) {
            return;
        }
        if (BlockFadeEventToggle) {
            Block block = event.getBlock();
            Material originalType = event.getBlock().getType();
            Material newType = event.getNewState().getType();
            if (originalType == Material.ICE && newType == Material.WATER) {
                for (BlockFace blockFace : EnumSet.of(BlockFace.DOWN, new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP})) {
                    if (IS_FLOATING.contains(block.getRelative(blockFace).getType())) continue;
                    return;
                }
                event.setCancelled(true);
                if (this.loggingEnabled) {
                    Cc.logSB("Cancelled melt event at: " + String.valueOf(block.getLocation()));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (!WorldManager.isCustomWorld(event.getBlock())) {
            return;
        }
        if (BlockIgniteEventToggle) {
            Block block = event.getBlock();
            for (BlockFace blockFace : EnumSet.of(BlockFace.DOWN, new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP})) {
                if (IS_FLOATING.contains(block.getRelative(blockFace).getType())) continue;
                return;
            }
            event.setCancelled(true);
            if (this.loggingEnabled) {
                Cc.logSB("Cancelled ignition event at: " + String.valueOf(block.getLocation()));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (!WorldManager.isCustomWorld(event.getBlock())) {
            return;
        }
        if (EntityChangeBlockEventToggle && event.getEntity() instanceof FallingBlock) {
            Block block = event.getBlock();
            for (BlockFace blockFace : EnumSet.of(BlockFace.DOWN, new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP})) {
                if (IS_FLOATING.contains(block.getRelative(blockFace).getType())) continue;
                return;
            }
            event.setCancelled(true);
            if (this.loggingEnabled) {
                Cc.logSB("Cancelled falling block event at: " + String.valueOf(block.getLocation()));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockFromTo(BlockFromToEvent event) {
        Block sourceBlock;
        Material sourceType;
        if (!WorldManager.isCustomWorld(event.getBlock())) {
            return;
        }
        if (BlockFromToEventToggle && ((sourceType = (sourceBlock = event.getBlock()).getType()) == Material.WATER || sourceType == Material.LAVA)) {
            boolean allFloating = true;
            for (BlockFace blockFace : EnumSet.of(BlockFace.DOWN, new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP})) {
                Block adjacentBlock = sourceBlock.getRelative(blockFace);
                if (IS_FLOATING.contains(adjacentBlock.getType())) continue;
                allFloating = false;
                break;
            }
            if (allFloating) {
                event.setCancelled(true);
                if (this.loggingEnabled) {
                    Cc.logSB("Cancelled BlockFromToEvent for " + sourceType.name() + " at: " + String.valueOf(sourceBlock.getLocation()));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        String locateType;
        String[] args;
        Player player = event.getPlayer();
        String command = event.getMessage().toLowerCase().trim();
        if (command.startsWith("/locate") && WorldManager.isCustomWorld(player) && (args = command.split(" ")).length > 1 && ((locateType = args[1]).equals("structure") || locateType.equals("poi"))) {
            event.setCancelled(true);
            Cc.sendS((CommandSender)player, Cc.RED, "Locating structures and POIs is disabled in this world");
            if (this.loggingEnabled) {
                Cc.logSB(Cc.logO(Cc.YELLOW, "Blocked locate " + locateType + " in custom world by ") + Cc.logO(Cc.AQUA, player.getName()));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerPortal(PlayerPortalEvent event) {
        World end;
        String base;
        Player player = event.getPlayer();
        Location from = event.getFrom();
        World fromWorld = from.getWorld();
        if (fromWorld == null || !WorldManager.isCustomWorld(player)) {
            return;
        }
        String overworldName = base = "skygridx_world";
        String netherName = base + "_nether";
        String endName = base + "_the_end";
        PlayerTeleportEvent.TeleportCause cause = event.getCause();
        Location dest = null;
        if (fromWorld.getName().equals(overworldName) && cause == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) {
            dest = this.scaleLocation(from, 0.125, netherName);
            event.setCanCreatePortal(true);
            event.setSearchRadius(128);
            event.setCreationRadius(16);
        } else if (fromWorld.getName().equals(netherName) && cause == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) {
            dest = this.scaleLocation(from, 8.0, overworldName);
            event.setCanCreatePortal(true);
            event.setSearchRadius(128);
            event.setCreationRadius(16);
        } else if (fromWorld.getName().equals(overworldName) && cause == PlayerTeleportEvent.TeleportCause.END_PORTAL && (end = Bukkit.getWorld((String)endName)) != null) {
            this.createEndPlatform(end);
            Location spawn = new Location(end, 100.5, 65.0, 0.5);
            event.setTo(spawn);
            event.setCanCreatePortal(false);
            event.setSearchRadius(0);
            event.setCreationRadius(0);
        }
        if (dest != null) {
            event.setTo(dest);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityPortal(EntityPortalEvent event) {
        String base;
        Location from = event.getFrom();
        World fromWorld = from.getWorld();
        if (fromWorld == null || !WorldManager.isCustomWorld(from.getBlock())) {
            return;
        }
        String overworldName = base = "skygridx_world";
        String netherName = base + "_nether";
        World.Environment env = fromWorld.getEnvironment();
        Location dest = null;
        if (env == World.Environment.NORMAL) {
            dest = this.scaleLocation(from, 0.125, netherName);
        } else if (env == World.Environment.NETHER) {
            dest = this.scaleLocation(from, 8.0, overworldName);
        }
        if (dest != null) {
            event.setCanCreatePortal(true);
            event.setCreationRadius(16);
            event.setTo(dest);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        final Player player = event.getPlayer();
        World from = event.getFrom();
        World to = player.getWorld();
        String base = "skygridx_world";
        String customEnd = base + "_the_end";
        final String customOver = base;
        if (!from.getName().equals(customEnd)) {
            return;
        }
        if (this.tpr.isRecentCommandTeleport(player)) {
            return;
        }
        if (!to.getName().equals(customOver)) {
            new BukkitRunnable(){

                public void run() {
                    World over = Bukkit.getWorld((String)customOver);
                    if (over == null) {
                        return;
                    }
                    CustomBedManager bedManager = CustomBedManager.getInstance();
                    Location bed = bedManager.getCustomBed(player.getUniqueId());
                    if (bed != null && bed.getWorld().getName().equals(customOver)) {
                        EventControl.this.tpr.findNonAirBlock(player, over, bed.getBlockX(), bed.getBlockY(), bed.getBlockZ(), true);
                    } else {
                        Location spawn = over.getSpawnLocation();
                        EventControl.this.tpr.findNonAirBlock(player, over, spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ(), true);
                    }
                }
            }.runTask(this.plugin);
        }
    }

    private Location scaleLocation(Location from, double scale, String targetName) {
        World w = Bukkit.getWorld((String)targetName);
        if (w == null) {
            return from;
        }
        return new Location(w, from.getX() * scale, from.getY(), from.getZ() * scale);
    }

    private void createEndPlatform(World world) {
        int centerX = 100;
        int centerZ = 0;
        int platformY = 64;
        int r = 2;
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                world.getBlockAt(centerX + dx, platformY, centerZ + dz).setType(Material.OBSIDIAN);
            }
        }
    }
}

