/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import main.SkyGridPlugin;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class EyeThrowListener
implements Listener {
    private final SkyGridPlugin plugin;
    private final Set<UUID> locked = new HashSet<UUID>();

    public EyeThrowListener(SkyGridPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        ItemStack stack;
        EquipmentSlot hand = e.getHand();
        if (hand != EquipmentSlot.HAND && hand != EquipmentSlot.OFF_HAND) {
            return;
        }
        Action act = e.getAction();
        if (act != Action.RIGHT_CLICK_AIR && act != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        final Player player = e.getPlayer();
        if (!player.getWorld().getName().startsWith("skygridx_")) {
            return;
        }
        final UUID uid = player.getUniqueId();
        if (this.locked.contains(uid)) {
            return;
        }
        ItemStack itemStack = stack = hand == EquipmentSlot.HAND ? player.getInventory().getItemInMainHand() : player.getInventory().getItemInOffHand();
        if (stack.getType() != Material.ENDER_EYE) {
            return;
        }
        e.setCancelled(true);
        stack.setAmount(stack.getAmount() - 1);
        if (hand == EquipmentSlot.HAND) {
            player.getInventory().setItemInMainHand(stack);
        } else {
            player.getInventory().setItemInOffHand(stack);
        }
        this.locked.add(uid);
        Location eyeLoc = player.getEyeLocation();
        Vector dir = eyeLoc.getDirection().normalize();
        Location launchPos = eyeLoc.clone().add(dir.clone().multiply(0.5)).subtract(0.0, 0.5, 0.0);
        final Vector startVec = launchPos.toVector();
        player.getWorld().playSound(launchPos, Sound.ENTITY_ENDER_EYE_LAUNCH, 1.0f, 1.0f);
        final Item thrown = player.getWorld().dropItem(launchPos, new ItemStack(Material.ENDER_EYE));
        thrown.setGravity(false);
        thrown.setPickupDelay(Integer.MAX_VALUE);
        thrown.setInvulnerable(true);
        thrown.setFireTicks(0);
        final Particle.DustOptions trailL = new Particle.DustOptions(Color.fromRGB((int)180, (int)255, (int)200), 1.0f);
        final Particle.DustOptions trailD = new Particle.DustOptions(Color.fromRGB((int)80, (int)150, (int)90), 0.8f);
        final Particle.DustOptions spinD = new Particle.DustOptions(Color.fromRGB((int)100, (int)255, (int)150), 1.2f);
        final Particle.DustOptions popL = new Particle.DustOptions(Color.fromRGB((int)200, (int)160, (int)255), 1.5f);
        final Particle.DustOptions popD = new Particle.DustOptions(Color.fromRGB((int)100, (int)40, (int)200), 1.2f);
        Location nearest = this.plugin.getPortalManager().getNearest(player.getLocation());
        if (nearest == null) {
            player.getWorld().playSound(launchPos, Sound.ENTITY_ENDER_EYE_DEATH, 1.0f, 1.0f);
            player.getWorld().spawnParticle(Particle.EXPLOSION, launchPos, 1);
            player.getWorld().spawnParticle(Particle.DUST, launchPos, 8, 0.0, 0.0, 0.0, (Object)popL);
            player.getWorld().spawnParticle(Particle.DUST, launchPos, 8, 0.0, 0.0, 0.0, (Object)popD);
            player.getWorld().dropItem(launchPos, new ItemStack(Material.ENDER_EYE));
            thrown.remove();
            this.locked.remove(uid);
            return;
        }
        Location target = nearest.clone().add(0.5, 1.5, 0.5);
        Vector toTarget = target.toVector().subtract(startVec);
        if (toTarget.length() > 16.0) {
            toTarget = toTarget.normalize().multiply(16);
        }
        final Location landing = launchPos.clone().add(toTarget);
        final Vector endVec = landing.toVector();
        Vector mid = startVec.clone().add(endVec).multiply(0.5);
        final Vector ctrl = mid.clone().add(new Vector(0, 8, 0));
        new BukkitRunnable(){
            final int TOTAL = 130;
            int tick = 0;
            Vector prev = startVec.clone();

            public void run() {
                if (++this.tick > 130) {
                    this.cancel();
                    EyeThrowListener.this.startHover(thrown, landing, player, spinD, popL, popD, uid);
                    return;
                }
                double t = (double)this.tick / 130.0;
                double s = t * t * (3.0 - 2.0 * t);
                Vector a = startVec.clone().multiply((1.0 - s) * (1.0 - s));
                Vector b = ctrl.clone().multiply(2.0 * (1.0 - s) * s);
                Vector c = endVec.clone().multiply(s * s);
                Vector pos = a.add(b).add(c);
                Location loc = pos.toLocation(player.getWorld());
                thrown.setFireTicks(0);
                thrown.setVelocity(pos.clone().subtract(this.prev));
                this.prev = pos;
                if (this.tick % 5 == 0) {
                    player.getWorld().spawnParticle(Particle.DUST, loc, 1, 0.0, 0.0, 0.0, (Object)trailL);
                    player.getWorld().spawnParticle(Particle.DUST, loc, 1, 0.0, 0.0, 0.0, (Object)trailD);
                    double ang = (double)this.tick * 0.3;
                    for (int i = 0; i < 2; ++i) {
                        double phi = ang + (double)i * Math.PI;
                        double dx = 0.2 * Math.cos(phi);
                        double dz = 0.2 * Math.sin(phi);
                        player.getWorld().spawnParticle(Particle.SMALL_FLAME, loc.clone().add(dx, 0.0, dz), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    private void startHover(final Item eyeEntity, final Location base, final Player player, final Particle.DustOptions spinDust, final Particle.DustOptions popLight, final Particle.DustOptions popDark, final UUID uid) {
        new BukkitRunnable(){
            final int DURATION = 100;
            final double BOB_FREQ = 0.3141592653589793;
            final double BOB_AMP = 0.25;
            final double SP0 = 0.15;
            final double SP1 = 0.9;
            int ht = 0;
            double angle = 0.0;

            public void run() {
                if (++this.ht > 100) {
                    player.getWorld().playSound(base, Sound.ENTITY_ENDER_EYE_DEATH, 1.0f, 1.0f);
                    player.getWorld().spawnParticle(Particle.EXPLOSION, base, 1);
                    player.getWorld().spawnParticle(Particle.DUST, base, 8, 0.0, 0.0, 0.0, (Object)popLight);
                    player.getWorld().spawnParticle(Particle.DUST, base, 8, 0.0, 0.0, 0.0, (Object)popDark);
                    player.getWorld().dropItem(base, new ItemStack(Material.ENDER_EYE));
                    eyeEntity.remove();
                    EyeThrowListener.this.locked.remove(uid);
                    this.cancel();
                    return;
                }
                double dy = Math.sin((double)this.ht * 0.3141592653589793) * 0.25;
                Location loc = base.clone().add(0.0, dy, 0.0);
                eyeEntity.teleport(loc);
                if (this.ht % 10 == 0) {
                    double progress = (double)this.ht / 100.0;
                    this.angle += 0.15 + 0.75 * progress;
                    double dx = 0.4 * Math.cos(this.angle);
                    double dz = 0.4 * Math.sin(this.angle);
                    player.getWorld().spawnParticle(Particle.DUST, loc.clone().add(dx, 0.0, dz), 1, 0.0, 0.0, 0.0, (Object)spinDust);
                    player.getWorld().spawnParticle(Particle.SMALL_FLAME, loc.clone().add(dx, 0.0, dz), 1, 0.0, 0.0, 0.0, 0.0);
                    player.getWorld().spawnParticle(Particle.DUST, loc.clone().add(-dx, 0.0, -dz), 1, 0.0, 0.0, 0.0, (Object)spinDust);
                    player.getWorld().spawnParticle(Particle.SMALL_FLAME, loc.clone().add(-dx, 0.0, -dz), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }
}

