/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import main.SkyGridPlugin;

public class FirstBootChecker {
    private SkyGridPlugin plugin;

    public FirstBootChecker(SkyGridPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean checkForFirstBoot() {
        boolean isFirstBoot = false;
        isFirstBoot |= this.copyFileIfNotPresent("world.yml", "SkygridBlocks");
        isFirstBoot |= this.copyFileIfNotPresent("world_nether.yml", "SkygridBlocks");
        isFirstBoot |= this.copyFileIfNotPresent("world_the_end.yml", "SkygridBlocks");
        isFirstBoot |= this.copyFileIfNotPresent("ores.yml", "OreGenBlock");
        isFirstBoot |= this.copyFileIfNotPresent("ChestSettings.yml", "SkygridBlocks");
        isFirstBoot |= this.copyFileIfNotPresent("SpawnerSettings.yml", "SkygridBlocks");
        return isFirstBoot |= this.copyFileIfNotPresent("settings.yml", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyFileIfNotPresent(String fileName, String destinationFolder) {
        Path destinationPath = Paths.get(this.plugin.getDataFolder().getPath(), destinationFolder, fileName);
        if (Files.exists(destinationPath, new LinkOption[0])) return false;
        try (InputStream inputStream = this.plugin.getResource(fileName);){
            if (inputStream != null) {
                Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
                Files.copy(inputStream, destinationPath, new CopyOption[0]);
                boolean bl = true;
                return bl;
            }
            this.plugin.getLogger().warning("Could not find " + fileName + " in the plugin resources.");
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void createFoldersIfNotExist(String folderName) {
        File folder = new File(this.plugin.getDataFolder(), folderName);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }
}

