/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.HashSet;
import java.util.Set;
import main.Cc;
import main.PluginSettings;
import main.ResourcePackManager;
import main.SkyGridPlugin;
import main.WorldManager;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Fog
implements CommandExecutor {
    private static final BossBar fogBossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.WHITE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[]{BarFlag.CREATE_FOG});
    private static final Set<Player> fogPlayers = new HashSet<Player>();
    private final ResourcePackManager manager;
    private BukkitRunnable fogTask;
    private static final String ON_MESSAGE = Cc.logO(Cc.GREEN, "Fog Enabled");
    private static final String ON_WARNING_MESSAGE = Cc.logO(Cc.YELLOW, "Fog is already enabled!");
    private static final String OFF_MESSAGE = Cc.logO(Cc.RED, "Fog Disabled");
    private static final String OFF_WARNING_MESSAGE = Cc.logO(Cc.YELLOW, "Fog is already disabled!");
    private static boolean FogToggle = PluginSettings.isFogAutoEnabled();

    public Fog(ResourcePackManager manager, PluginSettings settings) {
        this.manager = manager;
        fogBossBar.setVisible(true);
        this.settingCheck();
    }

    private void settingCheck() {
        if (FogToggle) {
            this.manager.setEnabled(true);
            this.startFogTask();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = sender instanceof Player ? (Player)sender : null;
        switch (label.toLowerCase()) {
            case "fogon": {
                if (this.fogTask == null) {
                    this.applyFog(player);
                    this.startFogTask();
                    this.manager.setEnabled(true);
                    break;
                }
                Cc.logSB(ON_WARNING_MESSAGE);
                break;
            }
            case "fogoff": {
                if (this.fogTask != null) {
                    this.clearFog(player);
                    this.stopFogTask();
                    this.manager.setEnabled(false);
                    break;
                }
                Cc.logSB(OFF_WARNING_MESSAGE);
            }
        }
        return true;
    }

    private void applyFog(Player admin) {
        fogBossBar.removeAll();
        fogPlayers.clear();
        if (admin != null && WorldManager.isCustomWorld(admin)) {
            fogBossBar.addPlayer(admin);
            fogPlayers.add(admin);
        }
    }

    private void startFogTask() {
        Cc.logSB(ON_MESSAGE);
        this.fogTask = new BukkitRunnable(this){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (WorldManager.isCustomWorld(player)) {
                        if (fogPlayers.contains(player)) continue;
                        fogBossBar.addPlayer(player);
                        fogPlayers.add(player);
                        continue;
                    }
                    if (!fogPlayers.contains(player)) continue;
                    fogBossBar.removePlayer(player);
                    fogPlayers.remove(player);
                }
            }
        };
        this.fogTask.runTaskTimer((Plugin)JavaPlugin.getPlugin(SkyGridPlugin.class), 0L, 20L);
    }

    private void stopFogTask() {
        Cc.logSB(OFF_MESSAGE);
        if (this.fogTask != null) {
            this.fogTask.cancel();
            this.fogTask = null;
        }
        fogBossBar.removeAll();
        fogPlayers.clear();
    }

    private void clearFog(Player admin) {
        fogBossBar.removeAll();
        fogPlayers.clear();
        if (admin != null && WorldManager.isCustomWorld(admin)) {
            fogBossBar.addPlayer(admin);
            fogPlayers.add(admin);
        }
    }
}

