/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import main.ChestRegionData;
import main.CustomChest;
import main.MaterialManager;
import main.OreGen;
import main.PluginSettings;
import main.SkyGridPlugin;
import main.Spawner;
import main.WorldManager;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Beehive;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bamboo;
import org.bukkit.block.data.type.CaveVines;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.block.data.type.TrialSpawner;
import org.bukkit.block.data.type.Vault;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;

public class Generator
implements Listener {
    private static final String PREFIX = "skygridx_";
    private final SkyGridPlugin plugin;
    private final ThreadLocalRandom random;
    private final MaterialManager materialManager;
    private final Spawner spawner;
    private final CustomChest chest;
    private final Map<World.Environment, MinMaxSettings> environmentSettings;
    private static final EnumSet<World.Environment> DIMENSIONS_TO_PROCESS = EnumSet.of(World.Environment.NORMAL, World.Environment.NETHER, World.Environment.THE_END);
    private static final Set<Material> CROP_MATERIALS = EnumSet.of(Material.WHEAT, new Material[]{Material.BEETROOTS, Material.CARROTS, Material.POTATOES, Material.TORCHFLOWER_CROP, Material.PITCHER_CROP, Material.NETHER_WART, Material.CAVE_VINES, Material.CAVE_VINES_PLANT, Material.SWEET_BERRY_BUSH, Material.TWISTING_VINES, Material.TWISTING_VINES_PLANT});
    private static final Set<Material> LEAVES = EnumSet.of(Material.ACACIA_LEAVES, new Material[]{Material.AZALEA_LEAVES, Material.BIRCH_LEAVES, Material.CHERRY_LEAVES, Material.DARK_OAK_LEAVES, Material.FLOWERING_AZALEA_LEAVES, Material.JUNGLE_LEAVES, Material.MANGROVE_LEAVES, Material.OAK_LEAVES, Material.SPRUCE_LEAVES, Material.PALE_OAK_LEAVES});

    public Generator(SkyGridPlugin plugin) {
        this.plugin = plugin;
        this.random = ThreadLocalRandom.current();
        this.materialManager = new MaterialManager(plugin);
        this.spawner = Spawner.getInstance(plugin);
        this.chest = CustomChest.getInstance(plugin);
        this.environmentSettings = new EnumMap<World.Environment, MinMaxSettings>(World.Environment.class);
        this.initEnvSettings();
    }

    private void initEnvSettings() {
        this.environmentSettings.put(World.Environment.NORMAL, new MinMaxSettings(PluginSettings.normalMinY(), PluginSettings.normalMaxY()));
        this.environmentSettings.put(World.Environment.NETHER, new MinMaxSettings(PluginSettings.netherMinY(), PluginSettings.netherMaxY()));
        this.environmentSettings.put(World.Environment.THE_END, new MinMaxSettings(PluginSettings.endMinY(), PluginSettings.endMaxY()));
        this.environmentSettings.put(World.Environment.CUSTOM, new MinMaxSettings(PluginSettings.defaultMinY(), PluginSettings.defaultMaxY()));
    }

    public void initialize() {
        WorldManager.setupWorlds(this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.loadWorldMaterialsAsync();
        this.registerOreGen();
    }

    private void loadWorldMaterialsAsync() {
        CompletableFuture.runAsync(() -> {
            this.plugin.getLogger().info("Enabling Advanced material loader.");
            this.materialManager.loadMaterialsForWorld("world.yml");
            this.materialManager.loadMaterialsForWorld("world_nether.yml");
            this.materialManager.loadMaterialsForWorld("world_the_end.yml");
        }).exceptionally(th -> {
            this.plugin.getLogger().severe("Failed to load materials: " + th.getMessage());
            return null;
        });
    }

    private void registerOreGen() {
        OreGen oreGen = new OreGen(this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)oreGen, (Plugin)this.plugin);
    }

    private boolean isSkygridWorld(String name) {
        return name.startsWith(PREFIX);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChunkLoad(ChunkLoadEvent event) {
        World world = event.getWorld();
        String worldName = world.getName();
        if (!this.isSkygridWorld(worldName)) {
            return;
        }
        Chunk chunk = event.getChunk();
        if (event.isNewChunk()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.processChunk(chunk, world, worldName), (long)PluginSettings.getProcessDelay());
        }
    }

    public void processLoadedChunks() {
        for (World.Environment dim : DIMENSIONS_TO_PROCESS) {
            HashSet<Chunk> toProcess = new HashSet<Chunk>();
            for (World world : Bukkit.getWorlds()) {
                if (world.getEnvironment() != dim || !this.isSkygridWorld(world.getName())) continue;
                for (Chunk chunk : world.getLoadedChunks()) {
                    toProcess.add(chunk);
                }
            }
            for (Chunk chunk : toProcess) {
                this.processChunk(chunk, chunk.getWorld(), chunk.getWorld().getName());
            }
        }
    }

    public void regenerateAllLoadedChunks() {
        for (World world : Bukkit.getWorlds()) {
            if (!this.isSkygridWorld(world.getName())) continue;
            for (Chunk chunk : world.getLoadedChunks()) {
                this.processChunk(chunk, world, world.getName());
            }
        }
    }

    public void regenerateMiniChunk(Chunk chunk, MaterialManager.MaterialDistribution dist) {
        World world = chunk.getWorld();
        MinMaxSettings mm = this.environmentSettings.get(world.getEnvironment());
        int minY = mm.minY;
        int maxY = mm.maxY;
        ArrayList<ChestRegionData.ChestRecord> chestRecords = new ArrayList<ChestRegionData.ChestRecord>();
        for (int x = 1; x <= 15; x += 4) {
            for (int z = 1; z <= 15; z += 4) {
                for (int y = minY; y <= maxY; y += 4) {
                    Block block = chunk.getBlock(x, y, z);
                    this.setBlockTypeAndHandle(block, dist.next(), chestRecords);
                }
            }
        }
        if (!chestRecords.isEmpty()) {
            ChestRegionData.getInstance(this.plugin).registerChests(chestRecords);
        }
    }

    private void processChunk(Chunk chunk, World world, String worldName) {
        World.Environment env = world.getEnvironment();
        MinMaxSettings mm = this.environmentSettings.get(env);
        int minY = mm.minY;
        int maxY = mm.maxY;
        ArrayList<ChestRegionData.ChestRecord> chestRecords = new ArrayList<ChestRegionData.ChestRecord>();
        for (int x = 1; x <= 15; x += 4) {
            for (int z = 1; z <= 15; z += 4) {
                for (int y = minY; y <= maxY; y += 4) {
                    Block block = chunk.getBlock(x, y, z);
                    String biome = block.getBiome().toString();
                    Material mat = this.materialManager.getRandomMaterialForWorld(worldName, biome);
                    if (mat == null) continue;
                    this.setBlockTypeAndHandle(block, mat, chestRecords);
                }
            }
        }
        if (!chestRecords.isEmpty()) {
            ChestRegionData.getInstance(this.plugin).registerChests(chestRecords);
        }
    }

    private void setBlockTypeAndHandle(Block block, Material mat, List<ChestRegionData.ChestRecord> chestRecords) {
        block.setType(mat, false);
        if (LEAVES.contains(mat)) {
            this.handleLeaves(block);
        } else if (CROP_MATERIALS.contains(mat)) {
            this.handleCrop(block);
        } else if (mat == Material.CHORUS_FLOWER) {
            this.handleChorusFlower(block);
        } else if (mat == Material.BAMBOO) {
            this.handleBamboo(block);
        } else if (mat == Material.SPAWNER) {
            this.spawner.BlockInfo(block);
        } else if (mat == Material.CHEST || mat == Material.COPPER_CHEST) {
            this.chest.loadChest(block, chestRecords);
        } else if (mat == Material.BEE_NEST || mat == Material.BEEHIVE) {
            this.handleBeehive(block);
        } else if (mat == Material.TRIAL_SPAWNER || mat == Material.VAULT) {
            this.handleTrial(block);
        }
        if (mat == Material.END_PORTAL_FRAME || mat == Material.END_PORTAL) {
            this.plugin.getPortalManager().addPortal(block.getLocation());
        }
    }

    private void handleLeaves(Block block) {
        BlockData data = block.getBlockData();
        if (data instanceof Leaves) {
            Leaves leaves = (Leaves)data;
            leaves.setPersistent(true);
            block.setBlockData((BlockData)leaves, false);
        }
    }

    private void handleCrop(Block block) {
        BlockData data = block.getBlockData();
        if (data instanceof CaveVines) {
            CaveVines vines = (CaveVines)data;
            vines.setBerries(true);
            block.setBlockData((BlockData)vines, true);
        } else if (data instanceof Ageable) {
            Ageable age = (Ageable)data;
            age.setAge(age.getMaximumAge());
            block.setBlockData((BlockData)age, false);
        }
    }

    private void handleChorusFlower(Block block) {
        BlockData data = block.getBlockData();
        if (data instanceof Ageable) {
            Ageable age = (Ageable)data;
            age.setAge(Math.min(5, age.getMaximumAge()));
            block.setBlockData((BlockData)age, false);
        }
    }

    private void handleBamboo(Block block) {
        BlockData data = block.getBlockData();
        if (data instanceof Bamboo) {
            Bamboo bamboo = (Bamboo)data;
            bamboo.setStage(1);
            bamboo.setLeaves(this.getRandomLeafSize());
            block.setBlockData((BlockData)bamboo, false);
        }
    }

    private Bamboo.Leaves getRandomLeafSize() {
        Bamboo.Leaves[] vals = Bamboo.Leaves.values();
        return vals[this.random.nextInt(vals.length)];
    }

    private void handleBeehive(Block block) {
        Beehive hive = (Beehive)block.getState();
        if (!hive.isFull()) {
            for (int i = 0; i < 3; ++i) {
                Bee bee = (Bee)hive.getWorld().createEntity(block.getLocation(), Bee.class);
                hive.addEntity((Entity)bee);
            }
        }
        hive.update();
    }

    private void handleTrial(Block block) {
        BlockData data = block.getBlockData();
        boolean ominous = this.random.nextBoolean();
        if (data instanceof TrialSpawner) {
            TrialSpawner ts = (TrialSpawner)data;
            ts.setOminous(ominous);
            block.setBlockData((BlockData)ts, false);
        } else if (data instanceof Vault) {
            Vault v = (Vault)data;
            v.setOminous(ominous);
            block.setBlockData((BlockData)v, false);
        }
    }

    private record MinMaxSettings(int minY, int maxY) {
    }
}

