/*
 * Decompiled with CFR 0.152.
 */
package main;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import main.SkyGridPlugin;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class MaterialManager {
    private final SkyGridPlugin plugin;
    private final Object2ObjectMap<String, MaterialDistribution> materialDistributions;
    private final Object2ObjectMap<String, ObjectSet<String>> worldBiomeMappings;

    public MaterialManager(SkyGridPlugin plugin) {
        this.plugin = plugin;
        this.materialDistributions = new Object2ObjectOpenHashMap();
        this.worldBiomeMappings = new Object2ObjectOpenHashMap();
        this.precomputeBiomeMappings();
        this.precomputeAllMaterialDistributions();
    }

    private void precomputeBiomeMappings() {
        this.worldBiomeMappings.put("world.yml", (ObjectSet<String>)((Object)new ObjectOpenHashSet<String>(Arrays.asList((String[])Arrays.stream(WorldBiomes.values()).map(Enum::name).toArray(String[]::new)))));
        this.worldBiomeMappings.put("world_nether.yml", (ObjectSet<String>)((Object)new ObjectOpenHashSet<String>(Arrays.asList((String[])Arrays.stream(NetherBiomes.values()).map(Enum::name).toArray(String[]::new)))));
        this.worldBiomeMappings.put("world_the_end.yml", (ObjectSet<String>)((Object)new ObjectOpenHashSet<String>(Arrays.asList((String[])Arrays.stream(EndBiomes.values()).map(Enum::name).toArray(String[]::new)))));
    }

    private void precomputeAllMaterialDistributions() {
        for (String fileName : this.worldBiomeMappings.keySet()) {
            this.loadMaterialsForWorld(fileName);
        }
    }

    public void loadMaterialsForWorld(String fileName) {
        ConfigurationSection defaultDistSection;
        ConfigurationSection biomesSection;
        File file = new File(this.plugin.getDataFolder(), "SkygridBlocks/" + fileName);
        if (!file.exists()) {
            this.plugin.getLogger().warning("File not found: " + file.getPath());
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        String worldName = this.getWorldNameFromFileName(fileName);
        boolean hasDefaultDistribution = config.contains("default_distribution");
        ConfigurationSection distributionsSection = config.getConfigurationSection("distributions");
        Object2ObjectOpenHashMap<Object, MaterialDistribution> distributionCache = new Object2ObjectOpenHashMap<Object, MaterialDistribution>();
        if (distributionsSection == null) {
            if (!hasDefaultDistribution) {
                this.plugin.getLogger().warning("'distributions' section not found in " + fileName);
            }
        } else {
            for (Object key : distributionsSection.getKeys(false)) {
                ConfigurationSection distSection = distributionsSection.getConfigurationSection((String)key);
                if (distSection == null) {
                    this.plugin.getLogger().warning("No section found for distribution key: " + (String)key + " in file " + fileName);
                    continue;
                }
                Object2DoubleOpenHashMap distributionMap = new Object2DoubleOpenHashMap();
                for (String materialKey : distSection.getKeys(false)) {
                    double percentage = distSection.getDouble(materialKey);
                    Material material = Material.getMaterial((String)materialKey.trim().toUpperCase());
                    if (material != null) {
                        distributionMap.put(material, percentage);
                        continue;
                    }
                    this.plugin.getLogger().warning("Invalid material '" + materialKey + "' in distribution '" + (String)key + "' of file " + fileName);
                }
                if (distributionMap.isEmpty()) {
                    this.plugin.getLogger().warning("Empty distribution '" + (String)key + "' in file " + fileName);
                    continue;
                }
                distributionCache.put(key, new MaterialDistribution((Object2DoubleMap<Material>)((Object)distributionMap)));
            }
        }
        if ((biomesSection = config.getConfigurationSection("biomes")) == null) {
            if (!hasDefaultDistribution) {
                this.plugin.getLogger().warning("'biomes' section not found in " + fileName);
            }
        } else {
            for (String biomeKey : biomesSection.getKeys(false)) {
                String[] biomes;
                String distributionKey = biomesSection.getString(biomeKey + ".distribution");
                if (distributionKey == null) {
                    this.plugin.getLogger().warning("No distribution defined for biome '" + biomeKey + "' in file " + fileName);
                    continue;
                }
                MaterialDistribution distribution = (MaterialDistribution)distributionCache.get(distributionKey);
                if (distribution == null) {
                    this.plugin.getLogger().warning("Distribution '" + (String)distributionKey + "' not found for biome '" + biomeKey + "' in file " + fileName);
                    continue;
                }
                for (String biome : biomes = biomeKey.split(",")) {
                    String trimmedBiome = biome.trim();
                    if (trimmedBiome.isEmpty()) {
                        this.plugin.getLogger().warning("Empty biome name in key: " + biomeKey + " in file " + fileName);
                        continue;
                    }
                    String alias = worldName + "-" + trimmedBiome;
                    this.setMaterialDistribution(alias, distribution);
                }
            }
        }
        if (config.contains("default_distribution") && (defaultDistSection = config.getConfigurationSection("default_distribution")) != null) {
            Object2DoubleOpenHashMap defaultMap = new Object2DoubleOpenHashMap();
            for (String materialKey : defaultDistSection.getKeys(false)) {
                double percentage = defaultDistSection.getDouble(materialKey);
                Material material = Material.getMaterial((String)materialKey.trim().toUpperCase());
                if (material != null) {
                    defaultMap.put(material, percentage);
                    continue;
                }
                this.plugin.getLogger().warning("Invalid material '" + materialKey + "' in default_distribution of file " + fileName);
            }
            if (!defaultMap.isEmpty()) {
                MaterialDistribution defaultDistribution = new MaterialDistribution((Object2DoubleMap<Material>)((Object)defaultMap));
                this.setMaterialDistribution(worldName + "-DEFAULT", defaultDistribution);
            } else {
                this.plugin.getLogger().warning("Default distribution is empty in file " + fileName);
            }
        }
    }

    private String getWorldNameFromFileName(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    private void setMaterialDistribution(String alias, MaterialDistribution materialDistribution) {
        this.materialDistributions.put(alias, materialDistribution);
    }

    public Material getRandomMaterialForWorld(String worldName, String biomeName) {
        String key = worldName + "-" + biomeName;
        MaterialDistribution dist = (MaterialDistribution)this.materialDistributions.get(key);
        if (dist != null) {
            return dist.next();
        }
        String base = worldName.startsWith("skygridx_") ? worldName.substring("skygridx_".length()) : worldName;
        String baseKey = base + "-" + biomeName;
        dist = (MaterialDistribution)this.materialDistributions.get(baseKey);
        if (dist != null) {
            return dist.next();
        }
        String defaultKey = worldName + "-DEFAULT";
        dist = (MaterialDistribution)this.materialDistributions.get(defaultKey);
        if (dist != null) {
            return dist.next();
        }
        String baseDefaultKey = base + "-DEFAULT";
        dist = (MaterialDistribution)this.materialDistributions.get(baseDefaultKey);
        if (dist != null) {
            return dist.next();
        }
        this.plugin.getLogger().warning("No material distribution found for alias: " + key + " and no default distribution available.");
        return null;
    }

    private static enum WorldBiomes {
        FROZEN_RIVER,
        FROZEN_OCEAN,
        DEEP_FROZEN_OCEAN,
        DEEP_LUKEWARM_OCEAN,
        LUKEWARM_OCEAN,
        COLD_OCEAN,
        DEEP_COLD_OCEAN,
        OCEAN,
        DEEP_OCEAN,
        RIVER,
        WARM_OCEAN,
        SWAMP,
        MANGROVE_SWAMP,
        DESERT,
        DARK_FOREST,
        OLD_GROWTH_PINE_TAIGA,
        OLD_GROWTH_SPRUCE_TAIGA,
        BEACH,
        SNOWY_BEACH,
        STONY_SHORE,
        JUNGLE,
        SPARSE_JUNGLE,
        BAMBOO_JUNGLE,
        JAGGED_PEAKS,
        FROZEN_PEAKS,
        ICE_SPIKES,
        STONY_PEAKS,
        FOREST,
        FLOWER_FOREST,
        BIRCH_FOREST,
        OLD_GROWTH_BIRCH_FOREST,
        TAIGA,
        SNOWY_TAIGA,
        SNOWY_PLAINS,
        GROVE,
        SNOWY_SLOPES,
        PLAINS,
        SUNFLOWER_PLAINS,
        MEADOW,
        MUSHROOM_FIELDS,
        CHERRY_GROVE,
        SAVANNA,
        SAVANNA_PLATEAU,
        WINDSWEPT_SAVANNA,
        WINDSWEPT_FOREST,
        WINDSWEPT_HILLS,
        WINDSWEPT_GRAVELLY_HILLS,
        DEEP_DARK,
        LUSH_CAVES,
        DRIPSTONE_CAVES,
        BADLANDS,
        ERODED_BADLANDS,
        WOODED_BADLANDS,
        PALE_GARDEN;

    }

    private static enum NetherBiomes {
        BASALT_DELTAS,
        CRIMSON_FOREST,
        NETHER_WASTES,
        SOUL_SAND_VALLEY,
        WARPED_FOREST;

    }

    private static enum EndBiomes {
        THE_END,
        END_BARRENS,
        END_HIGHLANDS,
        END_MIDLANDS,
        SMALL_END_ISLANDS;

    }

    static class MaterialDistribution {
        private final Material[] materials;
        private final double[] probabilities;
        private final int[] alias;
        private final int size;

        public MaterialDistribution(Object2DoubleMap<Material> distribution) {
            this.size = distribution.size();
            this.materials = new Material[this.size];
            this.probabilities = new double[this.size];
            this.alias = new int[this.size];
            double total = 0.0;
            int index = 0;
            Material[] tempMaterials = new Material[this.size];
            double[] normalized = new double[this.size];
            for (Object2DoubleMap.Entry entry : (Object2DoubleMap.FastEntrySet)distribution.object2DoubleEntrySet()) {
                total += entry.getDoubleValue();
            }
            for (Object2DoubleMap.Entry entry : (Object2DoubleMap.FastEntrySet)distribution.object2DoubleEntrySet()) {
                tempMaterials[index] = (Material)entry.getKey();
                normalized[index] = entry.getDoubleValue() / total * (double)this.size;
                ++index;
            }
            IntArrayList small = new IntArrayList();
            IntArrayList large = new IntArrayList();
            for (int i = 0; i < this.size; ++i) {
                if (normalized[i] < 1.0) {
                    small.add(i);
                    continue;
                }
                large.add(i);
            }
            while (!small.isEmpty() && !large.isEmpty()) {
                int smallIndex = small.removeInt(small.size() - 1);
                int largeIndex = large.removeInt(large.size() - 1);
                this.probabilities[smallIndex] = normalized[smallIndex];
                this.alias[smallIndex] = largeIndex;
                normalized[largeIndex] = normalized[largeIndex] + normalized[smallIndex] - 1.0;
                if (normalized[largeIndex] < 1.0) {
                    small.add(largeIndex);
                    continue;
                }
                large.add(largeIndex);
            }
            while (!small.isEmpty()) {
                this.probabilities[small.removeInt((int)(small.size() - 1))] = 1.0;
            }
            while (!large.isEmpty()) {
                this.probabilities[large.removeInt((int)(large.size() - 1))] = 1.0;
            }
            System.arraycopy(tempMaterials, 0, this.materials, 0, this.size);
        }

        public Material next() {
            int column = ThreadLocalRandom.current().nextInt(this.size);
            return ThreadLocalRandom.current().nextDouble() < this.probabilities[column] ? this.materials[column] : this.materials[this.alias[column]];
        }
    }
}

