/*
 * Decompiled with CFR 0.152.
 */
package main;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import main.AsyncDelayedScheduler;
import main.Cc;
import main.Generator;
import main.MaterialManager;
import main.SkyGridPlugin;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class MiniRegenManager {
    private final SkyGridPlugin plugin;
    private final Generator generator;
    private final Map<String, MiniRegenSettings> miniRegenSettings;
    private final Map<String, MaterialManager.MaterialDistribution> miniRegenDistributions;
    private final AsyncDelayedScheduler scheduler = new AsyncDelayedScheduler();
    private final File folder;
    private final File settingsFile;
    private final File materialsFile;

    public MiniRegenManager(SkyGridPlugin plugin, Generator generator) {
        this.plugin = plugin;
        this.generator = generator;
        this.miniRegenSettings = new HashMap<String, MiniRegenSettings>();
        this.miniRegenDistributions = new HashMap<String, MaterialManager.MaterialDistribution>();
        this.folder = new File(plugin.getDataFolder(), "MiniRegen");
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        this.settingsFile = new File(this.folder, "mini_regen_settings.yml");
        this.materialsFile = new File(this.folder, "mini_regen_materials.yml");
    }

    public void initialize() {
        this.loadDefaultSettings();
        this.loadDefaultMaterials();
        this.loadMiniRegenSettings();
        this.loadMiniRegenDistributions();
        this.scheduleRegenerationTasks();
    }

    private void loadDefaultSettings() {
        if (!this.settingsFile.exists()) {
            try (InputStream in = this.plugin.getResource("mini_regen_settings.yml");
                 FileOutputStream out = new FileOutputStream(this.settingsFile);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = in.read(buffer)) > 0) {
                    out.write(buffer, 0, length);
                }
            }
            catch (Exception e) {
                Cc.logS(Cc.RED, "Failed to copy default mini_regen_settings.yml: " + e.getMessage());
            }
        }
    }

    private void loadDefaultMaterials() {
        if (!this.materialsFile.exists()) {
            try (InputStream in = this.plugin.getResource("mini_regen_materials.yml");
                 FileOutputStream out = new FileOutputStream(this.materialsFile);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = in.read(buffer)) > 0) {
                    out.write(buffer, 0, length);
                }
            }
            catch (Exception e) {
                Cc.logS(Cc.RED, "Failed to copy default mini_regen_materials.yml: " + e.getMessage());
            }
        }
    }

    private void loadMiniRegenSettings() {
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.settingsFile);
            ConfigurationSection section = config.getConfigurationSection("miniRegen");
            if (section != null) {
                for (String key : section.getKeys(false)) {
                    String[] coords;
                    String worldName = config.getString("miniRegen." + key + ".world");
                    String chunkStr = config.getString("miniRegen." + key + ".chunk");
                    int interval = config.getInt("miniRegen." + key + ".interval");
                    String distribution = config.getString("miniRegen." + key + ".distribution");
                    String group = config.getString("miniRegen." + key + ".group", "");
                    if (worldName == null || chunkStr == null || (coords = chunkStr.split(",")).length != 2) continue;
                    int chunkX = Integer.parseInt(coords[0].trim());
                    int chunkZ = Integer.parseInt(coords[1].trim());
                    MiniRegenSettings settings = new MiniRegenSettings(key, worldName, chunkX, chunkZ, distribution, interval, group);
                    this.miniRegenSettings.put(key, settings);
                }
            }
        }
        catch (Exception e) {
            Cc.logS(Cc.RED, "Failed to load mini regen settings: " + e.getMessage());
        }
    }

    private void loadMiniRegenDistributions() {
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.materialsFile);
            ConfigurationSection section = config.getConfigurationSection("distributions");
            if (section != null) {
                for (String key : section.getKeys(false)) {
                    ConfigurationSection distSection = section.getConfigurationSection(key);
                    if (distSection == null) continue;
                    Object2DoubleOpenHashMap<Material> distributionMap = new Object2DoubleOpenHashMap<Material>();
                    for (String matKey : distSection.getKeys(false)) {
                        double percentage = distSection.getDouble(matKey);
                        Material material = Material.getMaterial((String)matKey.trim().toUpperCase());
                        if (material != null) {
                            distributionMap.put(material, percentage);
                            continue;
                        }
                        this.plugin.getLogger().warning(Cc.YELLOW.getAnsi() + "Invalid material '" + matKey + "' in mini regen distribution '" + key + "'" + Cc.RESET.getAnsi());
                    }
                    if (distributionMap.isEmpty()) continue;
                    MaterialManager.MaterialDistribution distribution = new MaterialManager.MaterialDistribution((Object2DoubleMap<Material>)((Object)distributionMap));
                    this.miniRegenDistributions.put(key, distribution);
                }
            }
        }
        catch (Exception e) {
            Cc.logS(Cc.RED, "Failed to load mini regen distributions: " + e.getMessage());
        }
    }

    private void scheduleRegenerationTasks() {
        for (MiniRegenSettings settings : this.miniRegenSettings.values()) {
            this.scheduleTaskForChunk(settings);
        }
    }

    private void scheduleTaskForChunk(MiniRegenSettings settings) {
        String key = settings.alias;
        this.scheduler.scheduleAtFixedRate(() -> {
            if (!this.plugin.isEnabled()) {
                return;
            }
            if (!this.miniRegenSettings.containsKey(key)) {
                return;
            }
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                if (!this.plugin.isEnabled()) {
                    return;
                }
                World world = this.plugin.getServer().getWorld(settings.worldName);
                if (world != null) {
                    Chunk chunk = world.getChunkAt(settings.chunkX, settings.chunkZ);
                    chunk.setForceLoaded(true);
                    MaterialManager.MaterialDistribution distribution = this.miniRegenDistributions.get(settings.distribution);
                    if (distribution != null && chunk != null) {
                        this.generator.regenerateMiniChunk(chunk, distribution);
                    }
                }
            });
        }, settings.interval, settings.interval, TimeUnit.SECONDS, () -> this.plugin.isEnabled());
    }

    public void addMiniRegen(String worldName, int chunkX, int chunkZ, String alias, String distribution, int interval, String group) {
        String key = alias;
        MiniRegenSettings settings = new MiniRegenSettings(alias, worldName, chunkX, chunkZ, distribution, interval, group);
        this.miniRegenSettings.put(key, settings);
        this.scheduleTaskForChunk(settings);
        this.updateSettingsFile();
    }

    public void removeMiniRegen(String alias) {
        this.miniRegenSettings.remove(alias);
        this.updateSettingsFile();
    }

    public void removeMiniRegenGroup(String group) {
        for (String alias : this.miniRegenSettings.keySet().stream().collect(Collectors.toList())) {
            MiniRegenSettings settings = this.miniRegenSettings.get(alias);
            if (settings.group == null || !settings.group.equalsIgnoreCase(group)) continue;
            this.miniRegenSettings.remove(alias);
        }
        this.updateSettingsFile();
    }

    private void updateSettingsFile() {
        try {
            YamlConfiguration config = new YamlConfiguration();
            for (MiniRegenSettings s : this.miniRegenSettings.values()) {
                String key = s.alias;
                config.set("miniRegen." + key + ".world", (Object)s.worldName);
                config.set("miniRegen." + key + ".chunk", (Object)(s.chunkX + "," + s.chunkZ));
                config.set("miniRegen." + key + ".distribution", (Object)s.distribution);
                config.set("miniRegen." + key + ".interval", (Object)s.interval);
                config.set("miniRegen." + key + ".group", (Object)s.group);
            }
            config.save(this.settingsFile);
        }
        catch (Exception e) {
            Cc.logS(Cc.RED, "Failed to update mini regen settings file: " + e.getMessage());
        }
    }

    public void shutdown() {
        this.scheduler.setEnabled(false);
    }

    public Map<String, MiniRegenSettings> getMiniRegenSettings() {
        return this.miniRegenSettings;
    }

    public Map<String, MaterialManager.MaterialDistribution> getMiniRegenDistributions() {
        return this.miniRegenDistributions;
    }

    public List<String> getExistingGroups() {
        return this.miniRegenSettings.values().stream().map(s -> s.group).filter(g -> g != null && !g.isEmpty()).distinct().collect(Collectors.toList());
    }

    public static class MiniRegenSettings {
        public final String alias;
        public final String worldName;
        public final int chunkX;
        public final int chunkZ;
        public final String distribution;
        public final int interval;
        public final String group;

        public MiniRegenSettings(String alias, String worldName, int chunkX, int chunkZ, String distribution, int interval, String group) {
            this.alias = alias;
            this.worldName = worldName;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.distribution = distribution;
            this.interval = interval;
            this.group = group;
        }
    }
}

