/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;

public class PortalLocationManager {
    private final JavaPlugin plugin;
    private final File dataFile;
    private final List<Location> portalLocations = new ArrayList<Location>();

    public PortalLocationManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "portals.dat");
    }

    public void initialize() {
        this.plugin.getDataFolder().mkdirs();
        try {
            if (!this.dataFile.exists()) {
                this.dataFile.createNewFile();
            }
            this.loadFromFile();
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe("Failed to init portals.dat: " + ex.getMessage());
        }
    }

    private void loadFromFile() {
        this.portalLocations.clear();
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.dataFile)));
            try {
                while (true) {
                    int nameLen = in.readInt();
                    byte[] buf = new byte[nameLen];
                    in.readFully(buf);
                    String worldName = new String(buf, StandardCharsets.UTF_8);
                    double x = in.readDouble();
                    double y = in.readDouble();
                    double z = in.readDouble();
                    World w = Bukkit.getWorld((String)worldName);
                    if (w == null) continue;
                    this.portalLocations.add(new Location(w, x, y, z));
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException in) {
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe("Error reading portals.dat: " + ex.getMessage());
        }
    }

    public synchronized void addPortal(Location loc) {
        this.portalLocations.add(loc);
        byte[] nameBytes = loc.getWorld().getName().getBytes(StandardCharsets.UTF_8);
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.dataFile, true)));){
            out.writeInt(nameBytes.length);
            out.write(nameBytes);
            out.writeDouble(loc.getX());
            out.writeDouble(loc.getY());
            out.writeDouble(loc.getZ());
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe("Could not write portal to portals.dat: " + ex.getMessage());
        }
    }

    public synchronized Location getNearest(Location from) {
        Location best = null;
        double bestDist2 = Double.MAX_VALUE;
        for (Location portal : this.portalLocations) {
            double d2;
            if (!portal.getWorld().equals((Object)from.getWorld()) || !((d2 = portal.distanceSquared(from)) < bestDist2)) continue;
            bestDist2 = d2;
            best = portal;
        }
        return best;
    }

    public synchronized void clearAllPortals() {
        this.portalLocations.clear();
        try {
            FileOutputStream out = new FileOutputStream(this.dataFile, false);
            out.close();
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe("Failed to clear portals.dat: " + ex.getMessage());
        }
    }
}

