/*
 * Decompiled with CFR 0.152.
 */
package main;

import main.AnchorIsolation;
import main.BedIsolation;
import main.BukkitYMLPatcher;
import main.ChestOpenListener;
import main.ChestRegionData;
import main.ChunkLoader;
import main.CustomAnchorManager;
import main.CustomBedManager;
import main.DragonSpawnListener;
import main.EventControl;
import main.EventControlCommands;
import main.EyeThrowListener;
import main.FirstBootChecker;
import main.Fog;
import main.Generator;
import main.LogFilter;
import main.MiniRegenCommand;
import main.MiniRegenManager;
import main.MiniRegenTabCompleter;
import main.PatchCommand;
import main.PlayerJoin;
import main.PluginSettings;
import main.PortalLocationManager;
import main.RegenerateCommand;
import main.ResourcePackManager;
import main.TPRAutoCompleter;
import main.TPRCommand;
import main.VoidWorldGenerator;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SkyGridPlugin
extends JavaPlugin
implements Listener {
    private boolean firstBoot = false;
    private boolean firstPlayerConnected = false;
    private boolean chunksLoading = false;
    private FirstBootChecker bootChecker;
    private PluginSettings settings;
    private Generator generator;
    private MiniRegenManager miniRegenManager;
    private PortalLocationManager portalManager;
    private ChestRegionData chestRegionData;

    public void onEnable() {
        BukkitYMLPatcher.applyGeneratorSettings(this);
        this.chestRegionData = ChestRegionData.getInstance(this);
        Bukkit.getPluginManager().registerEvents((Listener)new ChestOpenListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DragonSpawnListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        ResourcePackManager manager = new ResourcePackManager();
        this.getServer().getPluginManager().registerEvents((Listener)manager, (Plugin)this);
        this.bootChecker = new FirstBootChecker(this);
        this.bootChecker.createFoldersIfNotExist("SkygridBlocks");
        this.bootChecker.createFoldersIfNotExist("OreGenBlock");
        this.firstBoot = this.bootChecker.checkForFirstBoot();
        this.settings = new PluginSettings(this);
        Fog fogCommandExecutor = new Fog(manager, this.settings);
        LogFilter logFilter = new LogFilter();
        this.getLogger().setFilter(logFilter);
        this.getCommand("fogon").setExecutor((CommandExecutor)fogCommandExecutor);
        this.getCommand("fogoff").setExecutor((CommandExecutor)fogCommandExecutor);
        TPRCommand tprCommand = new TPRCommand(this);
        this.getCommand("tpr").setTabCompleter((TabCompleter)new TPRAutoCompleter());
        this.getCommand("tpr").setExecutor((CommandExecutor)tprCommand);
        this.getCommand("tpro").setExecutor((CommandExecutor)tprCommand);
        this.getCommand("tprn").setExecutor((CommandExecutor)tprCommand);
        this.getCommand("tpre").setExecutor((CommandExecutor)tprCommand);
        EventControl eventControl = new EventControl((Plugin)this, tprCommand);
        eventControl.initialize();
        CustomBedManager bedManager = new CustomBedManager((Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BedIsolation(bedManager, tprCommand, this), (Plugin)this);
        CustomAnchorManager anchorManager = new CustomAnchorManager((Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AnchorIsolation(anchorManager, tprCommand, this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoin(this.settings, tprCommand), (Plugin)this);
        EventControlCommands commands = new EventControlCommands((Plugin)this, eventControl);
        this.getCommand("eclogson").setExecutor((CommandExecutor)commands);
        this.getCommand("eclogsoff").setExecutor((CommandExecutor)commands);
        this.getCommand("patch").setExecutor((CommandExecutor)new PatchCommand(this));
        this.handleGeneration();
        this.miniRegenManager = new MiniRegenManager(this, this.generator);
        this.miniRegenManager.initialize();
        this.getCommand("miniregen").setExecutor((CommandExecutor)new MiniRegenCommand(this.miniRegenManager));
        this.getCommand("miniregen").setTabCompleter((TabCompleter)new MiniRegenTabCompleter(this.miniRegenManager));
        this.portalManager = new PortalLocationManager(this);
        this.portalManager.initialize();
        Bukkit.getPluginManager().registerEvents((Listener)new EyeThrowListener(this), (Plugin)this);
    }

    public void onDisable() {
        if (this.miniRegenManager != null) {
            this.miniRegenManager.shutdown();
        }
        if (this.chestRegionData != null) {
            this.chestRegionData.shutdown();
        }
    }

    public PortalLocationManager getPortalManager() {
        return this.portalManager;
    }

    public boolean isFirstBoot() {
        return this.firstBoot;
    }

    public void setChunksLoading(boolean chunksLoading) {
        this.chunksLoading = chunksLoading;
    }

    public boolean areChunksLoading() {
        return this.chunksLoading;
    }

    private void handleGeneration() {
        if (this.generator == null) {
            this.generator = new Generator(this);
            this.generator.initialize();
            this.getCommand("regen").setExecutor((CommandExecutor)new RegenerateCommand(this, this.generator));
            if (this.firstBoot) {
                new ChunkLoader(this).loadChunksAndRun(() -> {});
            }
        }
    }

    public Generator getGenerator() {
        return this.generator;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAsyncPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        if (this.chunksLoading) {
            event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
            event.kickMessage((Component)Component.text((String)"Chunks are still loading, please wait a moment and try again."));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.firstPlayerConnected && this.firstBoot) {
            this.firstPlayerConnected = true;
            new BukkitRunnable(){

                public void run() {
                    SkyGridPlugin.this.generator.regenerateAllLoadedChunks();
                    SkyGridPlugin.this.portalManager.clearAllPortals();
                }
            }.runTaskLater((Plugin)this, 40L);
        }
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        if (worldName.startsWith("skygridx_")) {
            return new VoidWorldGenerator();
        }
        return null;
    }
}

