/*
 * Decompiled with CFR 0.152.
 */
package main;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.java.JavaPlugin;

public class Spawner {
    private static Spawner instance;
    private static JavaPlugin plugin;
    private FileConfiguration spawnerSettings;
    private static final int DEFAULT_DELAY = -1;
    private static final int DEFAULT_MAX_NEARBY_ENTITIES = 16;
    private static final int DEFAULT_MAX_SPAWN_DELAY = 800;
    private static final int DEFAULT_MIN_SPAWN_DELAY = 200;
    private static final int DEFAULT_PLAYER_RANGE = 16;
    private static final int DEFAULT_SPAWN_COUNT = 4;
    private static final int DEFAULT_SPAWN_RANGE = 4;
    private static final Set<EntityType> DEFAULT_WORLD_ENTITIES;
    private static final Set<EntityType> DEFAULT_NETHER_ENTITIES;
    private static final Set<EntityType> DEFAULT_END_ENTITIES;
    private final Object2ObjectOpenHashMap<String, SpawnerData> biomeToSpawnerData = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<String, ObjectArrayList<EntityType>> defaultEntitiesCache = new Object2ObjectOpenHashMap();

    private Spawner(JavaPlugin plugin) {
        Spawner.plugin = plugin;
        this.loadSpawnerSettings();
        this.cacheDefaultEntities();
        this.preprocessSpawnerData();
    }

    public static Spawner getInstance(JavaPlugin plugin) {
        if (instance == null) {
            instance = new Spawner(plugin);
        }
        return instance;
    }

    public void BlockInfo(Block block) {
        if (block == null || block.getType() != Material.SPAWNER) {
            return;
        }
        String biomeName = block.getBiome().toString();
        SpawnerData data = this.biomeToSpawnerData.get(biomeName);
        CreatureSpawner spawner = (CreatureSpawner)block.getState();
        if (data != null) {
            EntityType entity = data.getRandomEntity();
            spawner.setDelay(data.delay);
            spawner.setMaxNearbyEntities(data.maxNearbyEntities);
            spawner.setMaxSpawnDelay(data.maxSpawnDelay);
            spawner.setMinSpawnDelay(data.minSpawnDelay);
            spawner.setRequiredPlayerRange(data.playerRange);
            spawner.setSpawnCount(data.spawnCount);
            spawner.setSpawnRange(data.spawnRange);
            spawner.setSpawnedType(entity);
            spawner.update();
        } else {
            this.setDefaultSpawnerSettings(spawner, block.getWorld());
        }
    }

    private void setDefaultSpawnerSettings(CreatureSpawner spawner, World world) {
        spawner.setDelay(-1);
        spawner.setMaxNearbyEntities(16);
        spawner.setMaxSpawnDelay(800);
        spawner.setMinSpawnDelay(200);
        spawner.setRequiredPlayerRange(16);
        spawner.setSpawnCount(4);
        spawner.setSpawnRange(4);
        spawner.setSpawnedType(this.getDefaultEntityTypeForWorld(world));
        spawner.update();
    }

    private EntityType getDefaultEntityTypeForWorld(World world) {
        ObjectArrayList<EntityType> entities = this.defaultEntitiesCache.get(world.getName());
        if (entities == null || entities.isEmpty()) {
            return EntityType.SKELETON;
        }
        return entities.get(ThreadLocalRandom.current().nextInt(entities.size()));
    }

    private void loadSpawnerSettings() {
        File spawnerSettingsFile = new File(plugin.getDataFolder(), "SkygridBlocks/SpawnerSettings.yml");
        this.spawnerSettings = YamlConfiguration.loadConfiguration((File)spawnerSettingsFile);
        plugin.getLogger().info("Custom Skygrid generation started.");
        plugin.getLogger().info("SpawnerSettings Loaded");
    }

    private void cacheDefaultEntities() {
        this.defaultEntitiesCache.put("world", new ObjectArrayList<EntityType>(DEFAULT_WORLD_ENTITIES));
        this.defaultEntitiesCache.put("world_nether", new ObjectArrayList<EntityType>(DEFAULT_NETHER_ENTITIES));
        this.defaultEntitiesCache.put("world_the_end", new ObjectArrayList<EntityType>(DEFAULT_END_ENTITIES));
    }

    private void preprocessSpawnerData() {
        if (!this.spawnerSettings.isConfigurationSection("SpawnerSettings")) {
            return;
        }
        ConfigurationSection spawnerSettingsSection = this.spawnerSettings.getConfigurationSection("SpawnerSettings");
        if (spawnerSettingsSection == null) {
            return;
        }
        for (String spawnerKey : spawnerSettingsSection.getKeys(false)) {
            ConfigurationSection spawnerSection = spawnerSettingsSection.getConfigurationSection(spawnerKey);
            if (spawnerSection == null) continue;
            int delay = spawnerSection.getInt("Delay", -1);
            int maxNearby = spawnerSection.getInt("MaxNearbyEntities", 16);
            int maxSpawnDelay = spawnerSection.getInt("MaxSpawnDelay", 800);
            int minSpawnDelay = spawnerSection.getInt("MinSpawnDelay", 200);
            int playerRange = spawnerSection.getInt("PlayerRange", 16);
            int spawnCount = spawnerSection.getInt("SpawnCount", 4);
            int spawnRange = spawnerSection.getInt("SpawnRange", 4);
            List entityList = spawnerSection.getStringList("Entities");
            SpawnerData data = this.parseSpawnerData(entityList, delay, maxNearby, maxSpawnDelay, minSpawnDelay, playerRange, spawnCount, spawnRange);
            List biomes = spawnerSection.getStringList("Biomes");
            for (String biome : biomes) {
                this.biomeToSpawnerData.put(biome, data);
            }
        }
    }

    private SpawnerData parseSpawnerData(List<String> entityList, int delay, int maxNearby, int maxSpawnDelay, int minSpawnDelay, int playerRange, int spawnCount, int spawnRange) {
        if (entityList == null || entityList.isEmpty()) {
            return new SpawnerData(delay, maxNearby, maxSpawnDelay, minSpawnDelay, playerRange, spawnCount, spawnRange, new EntityType[0], new double[0]);
        }
        EntityType[] entityTypes = new EntityType[entityList.size()];
        double[] cumulativeWeights = new double[entityList.size()];
        double totalWeight = 0.0;
        int idx = 0;
        for (String entry : entityList) {
            String[] parts = entry.split(":");
            if (parts.length != 2) continue;
            try {
                EntityType type = EntityType.valueOf((String)parts[0]);
                double weight = Double.parseDouble(parts[1]);
                cumulativeWeights[idx] = totalWeight += weight;
                entityTypes[idx] = type;
                ++idx;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (idx < entityTypes.length) {
            EntityType[] truncatedTypes = new EntityType[idx];
            double[] truncatedWeights = new double[idx];
            System.arraycopy(entityTypes, 0, truncatedTypes, 0, idx);
            System.arraycopy(cumulativeWeights, 0, truncatedWeights, 0, idx);
            entityTypes = truncatedTypes;
            cumulativeWeights = truncatedWeights;
        }
        return new SpawnerData(delay, maxNearby, maxSpawnDelay, minSpawnDelay, playerRange, spawnCount, spawnRange, entityTypes, cumulativeWeights);
    }

    static {
        DEFAULT_WORLD_ENTITIES = EnumSet.of(EntityType.SKELETON, EntityType.ZOMBIE, EntityType.SPIDER, EntityType.CAVE_SPIDER);
        DEFAULT_NETHER_ENTITIES = EnumSet.of(EntityType.BLAZE, EntityType.WITHER_SKELETON);
        DEFAULT_END_ENTITIES = EnumSet.of(EntityType.ENDERMAN, EntityType.SHULKER);
    }

    private static class SpawnerData {
        final int delay;
        final int maxNearbyEntities;
        final int maxSpawnDelay;
        final int minSpawnDelay;
        final int playerRange;
        final int spawnCount;
        final int spawnRange;
        final EntityType[] entityTypes;
        final double[] cumulativeWeights;
        final double totalWeight;

        SpawnerData(int delay, int maxNearbyEntities, int maxSpawnDelay, int minSpawnDelay, int playerRange, int spawnCount, int spawnRange, EntityType[] entityTypes, double[] cumulativeWeights) {
            this.delay = delay;
            this.maxNearbyEntities = maxNearbyEntities;
            this.maxSpawnDelay = maxSpawnDelay;
            this.minSpawnDelay = minSpawnDelay;
            this.playerRange = playerRange;
            this.spawnCount = spawnCount;
            this.spawnRange = spawnRange;
            this.entityTypes = entityTypes;
            this.cumulativeWeights = cumulativeWeights;
            this.totalWeight = cumulativeWeights.length > 0 ? cumulativeWeights[cumulativeWeights.length - 1] : 0.0;
        }

        EntityType getRandomEntity() {
            if (this.entityTypes.length == 0) {
                return EntityType.SKELETON;
            }
            double randomValue = ThreadLocalRandom.current().nextDouble(this.totalWeight);
            int low = 0;
            int high = this.cumulativeWeights.length - 1;
            while (low < high) {
                int mid = low + high >>> 1;
                if (this.cumulativeWeights[mid] < randomValue) {
                    low = mid + 1;
                    continue;
                }
                high = mid;
            }
            return this.entityTypes[low];
        }
    }
}

