/*
 * Decompiled with CFR 0.152.
 */
package main;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import main.Cc;
import main.PluginSettings;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TPRCommand
implements CommandExecutor {
    private final JavaPlugin plugin;
    private final Object2ObjectOpenHashMap<UUID, Object2LongOpenHashMap<World.Environment>> lastTeleportTimes = new Object2ObjectOpenHashMap();
    private final Object2LongOpenHashMap<UUID> lastCommandTimes = new Object2LongOpenHashMap();
    private static final String ERROR_MESSAGE = "Only players can use this command.";
    private static final EnumSet<Material> DANGEROUSBLOCKS = PluginSettings.getDangerousBlocks();
    private static final int Lx = PluginSettings.getMaxX();
    private static final int Sx = PluginSettings.getMinX();
    private static final int Lz = PluginSettings.getMaxZ();
    private static final int Sz = PluginSettings.getMinZ();
    private static final int Y = PluginSettings.getDestinationY();
    private static final int b2b = PluginSettings.getb2bDelay();
    private static final int tprN = PluginSettings.getTprNetherDelay();
    private static final int tprE = PluginSettings.getTprEndDelay();
    private static final int tprO = PluginSettings.getTprDelay();

    public TPRCommand(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Cc.sendS(sender, Cc.RED, ERROR_MESSAGE);
            return true;
        }
        Player player = (Player)sender;
        World world = this.getWorldByLabel(label, args);
        if (world == null) {
            Cc.sendS((CommandSender)player, Cc.RED, "Target world not found!");
            return true;
        }
        if (this.canTeleport(player, world)) {
            this.teleportPlayer(player, world);
        } else {
            this.handleCooldownMessages(player, world);
        }
        return true;
    }

    private World getWorldByLabel(String label, String[] args) {
        if (args.length > 0) {
            return this.getWorldByName(args[0]);
        }
        return this.getWorldForEnvironment(this.getEnvironmentFromLabel(label));
    }

    private World.Environment getEnvironmentFromLabel(String label) {
        switch (label.toLowerCase()) {
            case "tprn": {
                return World.Environment.NETHER;
            }
            case "tpre": {
                return World.Environment.THE_END;
            }
        }
        return World.Environment.NORMAL;
    }

    private World getWorldForEnvironment(World.Environment env) {
        String worldName = "skygridx_" + (switch (env) {
            case World.Environment.NETHER -> "world_nether";
            case World.Environment.THE_END -> "world_the_end";
            default -> "world";
        });
        return Bukkit.getWorld((String)worldName);
    }

    private void handleCooldownMessages(Player player, World world) {
        long regularCooldown = this.getRemainingCooldown(player, world);
        long b2bCooldown = this.getRemainingB2BCooldown(player);
        if (regularCooldown > 0L && b2bCooldown > 0L) {
            Cc.sendS((CommandSender)player, Cc.RED, "Wait " + regularCooldown + "s before this command.");
            Cc.sendS((CommandSender)player, Cc.RED, "Or, " + b2bCooldown + "s before any other tpr commands.");
        } else if (regularCooldown > 0L) {
            Cc.sendS((CommandSender)player, Cc.RED, "Wait " + regularCooldown + "s before this command.");
        } else if (b2bCooldown > 0L) {
            Cc.sendS((CommandSender)player, Cc.RED, "Wait " + b2bCooldown + "s before any other tpr commands.");
        }
    }

    private World getWorldByName(String worldNameArg) {
        World.Environment env = switch (worldNameArg.toLowerCase()) {
            case "nether" -> World.Environment.NETHER;
            case "end" -> World.Environment.THE_END;
            default -> World.Environment.NORMAL;
        };
        return this.getWorldForEnvironment(env);
    }

    private boolean canTeleport(Player player, World world) {
        int delay;
        long b2bDelay;
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (!this.lastTeleportTimes.containsKey(playerId) && !this.lastCommandTimes.containsKey((Object)playerId)) {
            return true;
        }
        long lastCommandTime = this.lastCommandTimes.getOrDefault((Object)playerId, 0L);
        if (currentTime - lastCommandTime < (b2bDelay = (long)b2b * 1000L)) {
            return false;
        }
        Object2LongOpenHashMap<World.Environment> environmentTimes = this.lastTeleportTimes.getOrDefault(playerId, (Object2LongOpenHashMap<World.Environment>)new Object2LongOpenHashMap());
        long lastTeleportTime = environmentTimes.getOrDefault((Object)world.getEnvironment(), 0L);
        return currentTime - lastTeleportTime >= (long)(delay = this.getTeleportDelay(world)) * 1000L;
    }

    private int getTeleportDelay(World world) {
        return switch (world.getEnvironment()) {
            case World.Environment.NETHER -> tprN;
            case World.Environment.THE_END -> tprE;
            default -> tprO;
        };
    }

    private void teleportPlayer(Player player, World world) {
        int randomX = ThreadLocalRandom.current().nextInt(Lx - Sx) + Sx;
        int randomZ = ThreadLocalRandom.current().nextInt(Lz - Sz) + Sz;
        this.findNonAirBlock(player, world, randomX, Y, randomZ, true);
    }

    private long getRemainingCooldown(Player player, World world) {
        int delay;
        UUID playerId = player.getUniqueId();
        if (!this.lastTeleportTimes.containsKey(playerId)) {
            return 0L;
        }
        Object2LongOpenHashMap<World.Environment> environmentTimes = this.lastTeleportTimes.get(playerId);
        long lastTeleportTime = environmentTimes.getOrDefault((Object)world.getEnvironment(), 0L);
        long remaining = lastTeleportTime + (long)(delay = this.getTeleportDelay(world)) * 1000L - System.currentTimeMillis();
        if (remaining <= 0L) {
            return 0L;
        }
        return remaining / 1000L;
    }

    private long getRemainingB2BCooldown(Player player) {
        long b2bDelay;
        UUID playerId = player.getUniqueId();
        long lastCommandTime = this.lastCommandTimes.getOrDefault((Object)playerId, 0L);
        long remaining = lastCommandTime + (b2bDelay = (long)b2b * 1000L) - System.currentTimeMillis();
        if (remaining <= 0L) {
            return 0L;
        }
        return remaining / 1000L;
    }

    public boolean isRecentCommandTeleport(Player player) {
        UUID playerId = player.getUniqueId();
        long lastTime = this.lastCommandTimes.getOrDefault((Object)playerId, 0L);
        if (lastTime == 0L) {
            return false;
        }
        long diff = System.currentTimeMillis() - lastTime;
        return diff >= 0L && diff <= 2000L;
    }

    public void findNonAirBlock(final Player player, final World world, final int destinationX, final int destinationY, final int destinationZ, final boolean isRegularTeleport) {
        final int chunkX = destinationX >> 4;
        final int chunkZ = destinationZ >> 4;
        world.loadChunk(chunkX, chunkZ, true);
        new BukkitRunnable(){

            public void run() {
                if (!world.isChunkLoaded(chunkX, chunkZ)) {
                    return;
                }
                for (int dx = -2; dx <= 2; ++dx) {
                    for (int dz = -2; dz <= 2; ++dz) {
                        for (int dy = 0; dy <= 10; ++dy) {
                            int x = destinationX + dx;
                            int y = destinationY + dy;
                            int z = destinationZ + dz;
                            Block block = world.getBlockAt(x, y, z);
                            if (block.getType().isAir() || TPRCommand.this.isDangerousBlock(block.getType())) continue;
                            if (isRegularTeleport) {
                                UUID playerId = player.getUniqueId();
                                Object2LongOpenHashMap<World.Environment> environmentTimes = TPRCommand.this.lastTeleportTimes.getOrDefault(playerId, (Object2LongOpenHashMap<World.Environment>)new Object2LongOpenHashMap());
                                environmentTimes.put((Object)world.getEnvironment(), System.currentTimeMillis());
                                TPRCommand.this.lastTeleportTimes.put(playerId, environmentTimes);
                                TPRCommand.this.lastCommandTimes.put((Object)playerId, System.currentTimeMillis());
                            }
                            player.teleport(new Location(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5));
                            this.cancel();
                            return;
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void teleportPlayerForFirstJoin(Player player, World world) {
        int randomX = ThreadLocalRandom.current().nextInt(Lx - Sx) + Sx;
        int randomZ = ThreadLocalRandom.current().nextInt(Lz - Sz) + Sz;
        this.findNonAirBlock(player, world, randomX, Y, randomZ, false);
    }

    private boolean isDangerousBlock(Material blockType) {
        return DANGEROUSBLOCKS.contains(blockType);
    }
}

