/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.EnumMap;
import java.util.Map;
import main.CustomBedManager;
import main.VoidWorldGenerator;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WorldManager {
    public static final String PREFIX = "skygridx_";
    private static final Map<World.Environment, String> NAMES = new EnumMap<World.Environment, String>(World.Environment.class);

    public static boolean isCustomWorld(Block block) {
        return block.getWorld().getName().startsWith(PREFIX);
    }

    public static boolean isCustomWorld(Player player) {
        return player.getWorld().getName().startsWith(PREFIX);
    }

    public static boolean isCustomWorld(World world) {
        return world.getName().startsWith(PREFIX);
    }

    public static void setupWorlds(JavaPlugin plugin) {
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            WorldManager.createWorlds(plugin);
            CustomBedManager.reloadBeds();
        });
    }

    private static void createWorlds(JavaPlugin plugin) {
        for (Map.Entry<World.Environment, String> e : NAMES.entrySet()) {
            World.Environment env = e.getKey();
            String vanilla = e.getValue();
            String customName = PREFIX + vanilla;
            if (Bukkit.getWorld((String)customName) != null) continue;
            World world = new WorldCreator(customName).environment(env).generator((ChunkGenerator)new VoidWorldGenerator()).createWorld();
            world.setSpawnLocation(0, 64, 0);
            if (env != World.Environment.THE_END) continue;
            world.getBlockAt(0, 65, 0).setType(Material.BEDROCK);
        }
    }

    static {
        NAMES.put(World.Environment.NORMAL, "world");
        NAMES.put(World.Environment.NETHER, "world_nether");
        NAMES.put(World.Environment.THE_END, "world_the_end");
    }
}

