/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.Handlers;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AdvancementHandler {
    private final NamespacedKey key;
    private final String icon;
    private final String message;
    private final Style style;
    private AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();

    private AdvancementHandler(String icon, String message, Style style) {
        this.key = new NamespacedKey((Plugin)this.plugin, UUID.randomUUID().toString());
        this.icon = icon;
        this.message = message;
        this.style = style;
    }

    private void start(Player player) {
        this.createAdvancement();
        this.grantAdvancement(player);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.revokeAdvancement(player), 10L);
    }

    private void createAdvancement() {
        int version = this.plugin.getVersion();
        String itemKey = version <= 20 ? "item" : "id";
        String advancementJson = "{\n    \"criteria\": {\n        \"trigger\": {\n            \"trigger\": \"minecraft:impossible\"\n        }\n    },\n    \"display\": {\n        \"icon\": {\n            \"" + itemKey + "\": \"minecraft:" + this.icon + "\"\n        },\n        \"title\": {\n            \"text\": \"" + this.message.replace("|", "\n") + "\"\n        },\n        \"description\": {\n            \"text\": \"\"\n        },\n        \"background\": \"minecraft:textures/gui/advancements/backgrounds/adventure.png\",\n        \"frame\": \"" + this.style.toString().toLowerCase() + "\",\n        \"announce_to_chat\": false,\n        \"show_toast\": true,\n        \"hidden\": true\n    },\n    \"requirements\": [\n        [\n            \"trigger\"\n        ]\n    ]\n}";
        Bukkit.getUnsafe().loadAdvancement(this.key, advancementJson);
    }

    private void grantAdvancement(Player player) {
        player.getAdvancementProgress(Bukkit.getAdvancement((NamespacedKey)this.key)).awardCriteria("trigger");
    }

    private void revokeAdvancement(Player player) {
        player.getAdvancementProgress(Bukkit.getAdvancement((NamespacedKey)this.key)).revokeCriteria("trigger");
    }

    public static void displayTo(Player player, String icon, String message, Style style) {
        String coloredMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        if (AdvancementAnnouncer.getInstance().isPAPIEnabled()) {
            String parsedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)PlaceholderAPI.setPlaceholders((Player)player, (String)coloredMessage));
            new AdvancementHandler(icon, parsedMessage, style).start(player);
        } else {
            new AdvancementHandler(icon, coloredMessage, style).start(player);
        }
    }

    public static enum Style {
        GOAL,
        TASK,
        CHALLENGE;

    }
}

