/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.Handlers;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.Handlers.AdvancementHandler;
import io.github.altkat.advancementannouncer.PlayerData;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AutoAnnounce {
    static AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();
    static int taskID;
    static int order;
    static int lastMessageIndex;
    static int failedAttempts;

    public static void startAutoAnnounce() {
        if (plugin.getConfig().getConfigurationSection("auto-announce").getBoolean("enabled")) {
            ConfigurationSection mainSection = plugin.getConfig().getConfigurationSection("auto-announce");
            ConfigurationSection subSection = mainSection.getConfigurationSection("messages");
            if (subSection == null) {
                plugin.getLogger().warning("No messages section found in the configuration. AutoAnnounce will not start.");
                return;
            }
            String mode = mainSection.getString("mode");
            order = 0;
            failedAttempts = 0;
            Set keySet = subSection.getKeys(false);
            List keyList = keySet.stream().toList();
            int messageCount = keyList.size();
            if (messageCount == 0) {
                plugin.getLogger().warning("No messages found in the configuration. AutoAnnounce will not start.");
                return;
            }
            taskID = mode.equalsIgnoreCase("random") ? Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
                AdvancementHandler.Style style;
                if (failedAttempts == 10) {
                    plugin.getServer().getConsoleSender().sendMessage("\u00a73[AdvancementAnnouncer] \u00a7cFailed to find a valid message after 10 attempts. Stopping auto announcements... Please fix the issue in the config then reload the plugin.");
                    AutoAnnounce.stopAutoAnnounce();
                    return;
                }
                while ((order = ThreadLocalRandom.current().nextInt(messageCount)) == lastMessageIndex) {
                }
                String message = subSection.getConfigurationSection((String)keyList.get(order)).getString("message");
                String styleString = subSection.getConfigurationSection((String)keyList.get(order)).getString("style").toUpperCase();
                try {
                    style = AdvancementHandler.Style.valueOf(styleString);
                }
                catch (IllegalArgumentException e) {
                    plugin.getLogger().warning("Invalid style: " + styleString + ". Skipping announcement (" + (String)keyList.get(order) + "). Remaining attempts before disabling auto announcements: " + (10 - failedAttempts));
                    ++failedAttempts;
                    return;
                }
                String icon = subSection.getConfigurationSection((String)keyList.get(order)).getString("icon").toLowerCase();
                if (Material.matchMaterial((String)icon) == null) {
                    plugin.getLogger().warning("Invalid icon: " + icon + ". Skipping announcement (" + (String)keyList.get(order) + "). Remaining attempts before disabling auto announcements: " + (10 - failedAttempts));
                    ++failedAttempts;
                    return;
                }
                Collection playerList = Bukkit.getOnlinePlayers();
                if (playerList.isEmpty()) {
                    return;
                }
                for (Player player : playerList) {
                    if (failedAttempts > 0) {
                        plugin.getLogger().warning("Valid message found after " + failedAttempts + " attempts. Continuing auto announcements.");
                        failedAttempts = 0;
                    }
                    if (!PlayerData.returnToggleData(player.getUniqueId())) continue;
                    AdvancementHandler.displayTo(player, icon, message, style);
                }
                lastMessageIndex = order;
            }, 60L, (long)mainSection.getInt("interval") * 20L).getTaskId() : Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
                AdvancementHandler.Style style;
                if (order >= messageCount) {
                    order = 0;
                }
                String message = subSection.getConfigurationSection((String)keyList.get(order)).getString("message");
                String styleString = subSection.getConfigurationSection((String)keyList.get(order)).getString("style").toUpperCase();
                try {
                    style = AdvancementHandler.Style.valueOf(styleString);
                }
                catch (IllegalArgumentException e) {
                    plugin.getLogger().warning("Invalid style: " + styleString + ". Skipping announcement (" + (String)keyList.get(order) + ").");
                    ++order;
                    return;
                }
                String icon = subSection.getConfigurationSection((String)keyList.get(order)).getString("icon").toLowerCase();
                if (Material.matchMaterial((String)icon) == null) {
                    plugin.getLogger().warning("Invalid icon: " + icon + ". Skipping announcement (" + (String)keyList.get(order) + ").");
                    ++order;
                    return;
                }
                Collection playerList = Bukkit.getOnlinePlayers();
                if (playerList.isEmpty()) {
                    return;
                }
                for (Player player : playerList) {
                    if (!PlayerData.returnToggleData(player.getUniqueId())) continue;
                    AdvancementHandler.displayTo(player, icon, message, style);
                }
                ++order;
            }, 60L, (long)mainSection.getInt("interval") * 20L).getTaskId();
        }
    }

    public static void stopAutoAnnounce() {
        Bukkit.getScheduler().cancelTask(taskID);
    }

    static {
        order = 0;
        failedAttempts = 0;
    }
}

