/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.Handlers;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import io.github.altkat.advancementannouncer.Handlers.AdvancementHandler;
import io.github.altkat.advancementannouncer.Handlers.AutoAnnounce;
import io.github.altkat.advancementannouncer.Handlers.guis.ConfirmationGUI;
import io.github.altkat.advancementannouncer.Handlers.guis.IconSelectionGUI;
import io.github.altkat.advancementannouncer.Handlers.guis.StyleSelectionGUI;
import io.github.altkat.advancementannouncer.PlayerData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CommandHandler
implements CommandExecutor,
TabCompleter,
Listener {
    AdvancementAnnouncer plugin = AdvancementAnnouncer.getInstance();
    private static final int SLOT_EDIT_AUTO_ANNOUNCE = 11;
    private static final int SLOT_EDIT_PRESETS = 15;
    private static final int SLOT_BACK_BUTTON = 45;
    private static final int SLOT_AA_TOGGLE = 48;
    private static final int SLOT_AA_INTERVAL = 49;
    private static final int SLOT_AA_MODE = 50;
    private static final int SLOT_ADD_ITEM = 53;
    private static final int SLOT_SET_NAME = 10;
    private static final int SLOT_SET_MESSAGE = 13;
    private static final int SLOT_SET_STYLE = 16;
    private static final int SLOT_SET_ICON = 19;
    private static final int SLOT_SAVE = 49;
    private static final String STEP_NAME = "name";
    private static final String STEP_MESSAGE = "message";
    private static final String STEP_STYLE = "style";
    private static final String STEP_ICON = "icon";
    private static final String STEP_INTERVAL = "interval";
    private final Map<UUID, Map<String, Object>> activeSessions = new HashMap<UUID, Map<String, Object>>();
    private final Map<UUID, Runnable> confirmationActions = new HashMap<UUID, Runnable>();
    private final Set<UUID> isNavigating = new HashSet<UUID>();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        AdvancementHandler.Style style;
        if (args.length > 0 && args[0].equalsIgnoreCase("edit")) {
            if (sender instanceof Player) {
                if (sender.hasPermission("advancementannouncer.admin")) {
                    this.openEditGUI((Player)sender);
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                }
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You must be a player to use this command!");
            }
            return true;
        }
        if (!sender.hasPermission("advancementannouncer.admin")) {
            UUID playerUUID;
            if (args.length != 1 || !args[0].equalsIgnoreCase("toggle")) {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.wrong-usage")));
                return true;
            }
            PlayerData.setToggleData(playerUUID, !PlayerData.returnToggleData(playerUUID = Bukkit.getPlayer((String)sender.getName()).getUniqueId()));
            if (PlayerData.returnToggleData(playerUUID)) {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.announcements-toggled-on")));
            } else {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.announcements-toggled-off")));
            }
            return true;
        }
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("toggle")) {
            UUID playerUUID;
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You must be a player to use this command!");
                return true;
            }
            PlayerData.setToggleData(playerUUID, !PlayerData.returnToggleData(playerUUID = Bukkit.getPlayer((String)sender.getName()).getUniqueId()));
            if (PlayerData.returnToggleData(playerUUID)) {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.announcements-toggled-on")));
            } else {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.announcements-toggled-off")));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            AutoAnnounce.stopAutoAnnounce();
            this.plugin.reloadConfig();
            AutoAnnounce.startAutoAnnounce();
            PlayerData.reloadPlayerData();
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.config-reloaded")));
            return true;
        }
        if (args.length < 4) {
            this.sendHelpMessage(sender);
            return true;
        }
        try {
            style = AdvancementHandler.Style.valueOf(args[0].toUpperCase());
        }
        catch (Throwable t) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid style: " + args[0]);
            return true;
        }
        String materialName = args[1];
        try {
            Material.valueOf((String)materialName.toUpperCase());
        }
        catch (Throwable t) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid material: " + materialName);
            return true;
        }
        String audience = args[2];
        Object message = "";
        if (this.plugin.getConfig().getConfigurationSection("presets").getKeys(false).contains(args[3])) {
            message = this.plugin.getConfig().getString("presets." + args[3]);
        } else {
            for (int i = 3; i < args.length; ++i) {
                message = (String)message + args[i] + " ";
            }
        }
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)message).trim());
        if (audience.equalsIgnoreCase("all")) {
            if (sender.getServer().getOnlinePlayers().isEmpty()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "There are no online players in the server!");
                return true;
            }
            for (Player player : sender.getServer().getOnlinePlayers()) {
                if (!PlayerData.returnToggleData(player.getUniqueId())) continue;
                AdvancementHandler.displayTo(player, materialName, (String)message, style);
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3[AdvancementAnnouncer] &aAdvancement message sent to all players"));
        } else {
            Player player = sender.getServer().getPlayer(audience);
            if (player == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found: " + audience);
                return true;
            }
            AdvancementHandler.displayTo(player, materialName, (String)message, style);
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&3[AdvancementAnnouncer] &aAdvancement message sent to " + player.getName())));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> tab = new ArrayList<String>();
        if (!sender.hasPermission("advancementannouncer.admin")) {
            if (args.length == 1) {
                tab.add("toggle");
                return tab;
            }
            return tab;
        }
        switch (args.length) {
            case 1: {
                tab.add("reload");
                tab.add("toggle");
                tab.add("edit");
                for (AdvancementHandler.Style style : AdvancementHandler.Style.values()) {
                    tab.add(style.toString().toLowerCase());
                }
                break;
            }
            case 2: {
                if (!args[0].equalsIgnoreCase("goal") && !args[0].equalsIgnoreCase("challenge") && !args[0].equalsIgnoreCase("task")) break;
                for (Material material : Material.values()) {
                    tab.add(material.toString().toLowerCase());
                }
                break;
            }
            case 3: {
                tab.add("all");
                for (Player player : sender.getServer().getOnlinePlayers()) {
                    tab.add(player.getName());
                }
                break;
            }
            case 4: {
                tab.addAll(this.plugin.getConfig().getConfigurationSection("presets").getKeys(false));
                tab.add("your message");
            }
        }
        return tab.stream().filter(completion -> completion.startsWith(args[args.length - 1])).collect(Collectors.toList());
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3[AdvancementAnnouncer] &aCommands: "));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7- &a/aa <style> <material> <player> <message>"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7- &a/aa reload"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7- &a/aa toggle"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7- &a/aa edit"));
    }

    private void addFormattedMessage(List<String> lore, String message) {
        if (message.contains("|")) {
            for (String line : message.split("\\|")) {
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
        } else {
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }

    private void openEditGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.edit-gui-title")));
        ItemStack autoAnnounceItem = new ItemStack(Material.CLOCK);
        ItemMeta autoAnnounceMeta = autoAnnounceItem.getItemMeta();
        autoAnnounceMeta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Edit Auto Announce");
        autoAnnounceItem.setItemMeta(autoAnnounceMeta);
        gui.setItem(11, autoAnnounceItem);
        ItemStack presetsItem = new ItemStack(Material.PAPER);
        ItemMeta presetsMeta = presetsItem.getItemMeta();
        presetsMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Edit Presets");
        presetsItem.setItemMeta(presetsMeta);
        gui.setItem(15, presetsItem);
        player.openInventory(gui);
    }

    private void openPresetsGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.presets-gui-title")));
        ConfigurationSection presetsSection = this.plugin.getConfig().getConfigurationSection("presets");
        if (presetsSection != null) {
            for (String key : presetsSection.getKeys(false)) {
                ItemStack item = new ItemStack(Material.PAPER);
                ItemMeta meta = item.getItemMeta();
                meta.setDisplayName(String.valueOf(ChatColor.GREEN) + key);
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&f&nCurrent Message:"));
                lore.add(" ");
                this.addFormattedMessage(lore, presetsSection.getString(key));
                lore.add(" ");
                lore.add(String.valueOf(ChatColor.YELLOW) + "Left click to edit this preset.");
                lore.add(String.valueOf(ChatColor.RED) + "Right click to delete this preset.");
                meta.setLore(lore);
                item.setItemMeta(meta);
                gui.addItem(new ItemStack[]{item});
            }
        }
        ItemStack backItem = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Back");
        backItem.setItemMeta(backMeta);
        gui.setItem(45, backItem);
        ItemStack addItem = new ItemStack(Material.EMERALD);
        ItemMeta addMeta = addItem.getItemMeta();
        addMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Add Preset");
        addItem.setItemMeta(addMeta);
        gui.setItem(53, addItem);
        player.openInventory(gui);
    }

    private void openAutoAnnounceGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.auto-announce-gui-title")));
        ConfigurationSection aaSection = this.plugin.getConfig().getConfigurationSection("auto-announce");
        ItemStack enabledItem = new ItemStack(aaSection.getBoolean("enabled") ? Material.LIME_DYE : Material.GRAY_DYE);
        ItemMeta enabledMeta = enabledItem.getItemMeta();
        enabledMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Auto Announce: " + (aaSection.getBoolean("enabled") ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled"));
        enabledItem.setItemMeta(enabledMeta);
        gui.setItem(48, enabledItem);
        ItemStack intervalItem = new ItemStack(Material.CLOCK);
        ItemMeta intervalMeta = intervalItem.getItemMeta();
        intervalMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Interval: " + String.valueOf(ChatColor.GOLD) + aaSection.getInt(STEP_INTERVAL) + "s");
        intervalItem.setItemMeta(intervalMeta);
        gui.setItem(49, intervalItem);
        ItemStack modeItem = new ItemStack(Material.COMPARATOR);
        ItemMeta modeMeta = modeItem.getItemMeta();
        modeMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Mode: " + String.valueOf(ChatColor.GOLD) + aaSection.getString("mode"));
        modeItem.setItemMeta(modeMeta);
        gui.setItem(50, modeItem);
        ConfigurationSection messagesSection = aaSection.getConfigurationSection("messages");
        if (messagesSection != null) {
            for (String key : messagesSection.getKeys(false)) {
                Material iconMaterial;
                try {
                    iconMaterial = Material.valueOf((String)messagesSection.getString(key + ".icon").toUpperCase());
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    iconMaterial = Material.PAPER;
                    this.plugin.getLogger().warning("Invalid icon material for auto-announce message '" + key + "'. Using PAPER as a fallback.");
                }
                ItemStack item = new ItemStack(iconMaterial);
                ItemMeta meta = item.getItemMeta();
                meta.setDisplayName(String.valueOf(ChatColor.GREEN) + key);
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(String.valueOf(ChatColor.WHITE) + "Message: ");
                this.addFormattedMessage(lore, messagesSection.getString(key + ".message"));
                lore.add(" ");
                lore.add(String.valueOf(ChatColor.WHITE) + "Style: " + messagesSection.getString(key + ".style"));
                lore.add(String.valueOf(ChatColor.WHITE) + "Icon: " + messagesSection.getString(key + ".icon"));
                lore.add(" ");
                lore.add(String.valueOf(ChatColor.YELLOW) + "Left click to edit.");
                lore.add(String.valueOf(ChatColor.RED) + "Right click to delete.");
                meta.setLore(lore);
                item.setItemMeta(meta);
                gui.addItem(new ItemStack[]{item});
            }
        }
        ItemStack backItem = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Back");
        backItem.setItemMeta(backMeta);
        gui.setItem(45, backItem);
        ItemStack addItem = new ItemStack(Material.EMERALD);
        ItemMeta addMeta = addItem.getItemMeta();
        addMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Add Message");
        addItem.setItemMeta(addMeta);
        gui.setItem(53, addItem);
        player.openInventory(gui);
    }

    private void openCreatorEditorGUI(Player player, Map<String, Object> data) {
        boolean isCreator = (Boolean)data.get("isCreator");
        String type = (String)data.get("type");
        String title = isCreator ? "Creating new " + type : "Editing " + type + ": " + String.valueOf(data.get(STEP_NAME));
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)title);
        this.activeSessions.put(player.getUniqueId(), data);
        ItemStack nameItem = new ItemStack(Material.NAME_TAG);
        ItemMeta nameMeta = nameItem.getItemMeta();
        nameMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Set Name");
        ArrayList<Object> nameLore = new ArrayList<Object>();
        nameLore.add(String.valueOf(ChatColor.GRAY) + "Current: " + String.valueOf(data.get(STEP_NAME)));
        nameLore.add(" ");
        nameLore.add(String.valueOf(ChatColor.GREEN) + "Click to change the name via chat.");
        nameMeta.setLore(nameLore);
        nameItem.setItemMeta(nameMeta);
        gui.setItem(10, nameItem);
        ItemStack messageItem = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta messageMeta = messageItem.getItemMeta();
        messageMeta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Set Message");
        ArrayList<String> messageLore = new ArrayList<String>();
        messageLore.add(String.valueOf(ChatColor.GRAY) + "Current: ");
        this.addFormattedMessage(messageLore, (String)data.get(STEP_MESSAGE));
        messageLore.add(" ");
        messageLore.add(String.valueOf(ChatColor.GREEN) + "Click to change the message via chat.");
        messageMeta.setLore(messageLore);
        messageItem.setItemMeta(messageMeta);
        gui.setItem(13, messageItem);
        if (type.equals("auto-announce")) {
            Material iconMaterial;
            ItemStack styleItem = new ItemStack(Material.PAINTING);
            ItemMeta styleMeta = styleItem.getItemMeta();
            styleMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Set Style");
            ArrayList<Object> styleLore = new ArrayList<Object>();
            styleLore.add(String.valueOf(ChatColor.GRAY) + "Current: " + String.valueOf(data.get(STEP_STYLE)));
            styleLore.add(" ");
            styleLore.add(String.valueOf(ChatColor.GREEN) + "Click to choose a style.");
            styleMeta.setLore(styleLore);
            styleItem.setItemMeta(styleMeta);
            gui.setItem(16, styleItem);
            try {
                iconMaterial = Material.valueOf((String)((String)data.get(STEP_ICON)).toUpperCase());
            }
            catch (Exception e) {
                iconMaterial = Material.STONE;
            }
            ItemStack iconItem = new ItemStack(iconMaterial);
            ItemMeta iconMeta = iconItem.getItemMeta();
            iconMeta.setDisplayName(String.valueOf(ChatColor.LIGHT_PURPLE) + "Set Icon");
            ArrayList<Object> iconLore = new ArrayList<Object>();
            iconLore.add(String.valueOf(ChatColor.GRAY) + "Current: " + String.valueOf(data.get(STEP_ICON)));
            iconLore.add(" ");
            iconLore.add(String.valueOf(ChatColor.GREEN) + "Click to choose an icon.");
            iconMeta.setLore(iconLore);
            iconItem.setItemMeta(iconMeta);
            gui.setItem(19, iconItem);
        }
        ItemStack saveItem = new ItemStack(Material.GREEN_WOOL);
        ItemMeta saveMeta = saveItem.getItemMeta();
        saveMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Save");
        saveItem.setItemMeta(saveMeta);
        gui.setItem(49, saveItem);
        ItemStack backItem = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = backItem.getItemMeta();
        backMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Cancel");
        backItem.setItemMeta(backMeta);
        gui.setItem(45, backItem);
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        boolean isRelevantGUI;
        String clickedGUITitle = event.getView().getTitle();
        Player player = (Player)event.getWhoClicked();
        boolean bl = isRelevantGUI = Arrays.asList(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.edit-gui-title")), ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.presets-gui-title")), ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.auto-announce-gui-title")), "Select a Style", "Confirm Deletion").contains(clickedGUITitle) || clickedGUITitle.startsWith("Editing ") || clickedGUITitle.startsWith("Creating ") || clickedGUITitle.startsWith("Select an Icon");
        if (!isRelevantGUI) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        this.isNavigating.add(player.getUniqueId());
        if (clickedGUITitle.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.edit-gui-title")))) {
            if (event.getSlot() == 11) {
                this.openAutoAnnounceGUI(player);
            } else if (event.getSlot() == 15) {
                this.openPresetsGUI(player);
            }
        } else if (clickedGUITitle.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.presets-gui-title")))) {
            this.handlePresetsGUIClick(event);
        } else if (clickedGUITitle.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("lang-messages.auto-announce-gui-title")))) {
            this.handleAutoAnnounceGUIClick(event);
        } else if (clickedGUITitle.startsWith("Editing ") || clickedGUITitle.startsWith("Creating ")) {
            this.handleCreatorEditorGUIClick(event);
        } else if (clickedGUITitle.equals("Select a Style")) {
            this.handleStyleSelectionGUIClick(event);
        } else if (clickedGUITitle.startsWith("Select an Icon")) {
            this.handleIconSelectionGUIClick(event);
        } else if (clickedGUITitle.equals("Confirm Deletion")) {
            this.handleConfirmationGUIClick(event);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.isNavigating.remove(player.getUniqueId()), 1L);
    }

    private void handleCreatorEditorGUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Map<String, Object> data = this.activeSessions.get(player.getUniqueId());
        switch (event.getSlot()) {
            case 10: {
                player.closeInventory();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Please type the new name in chat. (Type 'cancel' to abort)");
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Current value: " + String.valueOf(data.get(STEP_NAME)));
                data.put("step", STEP_NAME);
                break;
            }
            case 13: {
                player.closeInventory();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Please type the new message in chat. (Use | for new line, type 'cancel' to abort)");
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Current value: " + String.valueOf(data.get(STEP_MESSAGE)));
                data.put("step", STEP_MESSAGE);
                break;
            }
            case 16: {
                StyleSelectionGUI.open(player);
                break;
            }
            case 19: {
                IconSelectionGUI.open(player, 0);
                break;
            }
            case 49: {
                this.saveChanges(player);
                break;
            }
            case 45: {
                this.activeSessions.remove(player.getUniqueId());
                if (data == null) break;
                if (((String)data.get("type")).equals("preset")) {
                    this.openPresetsGUI(player);
                    break;
                }
                this.openAutoAnnounceGUI(player);
            }
        }
    }

    private void handleStyleSelectionGUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem.getType() == Material.WRITABLE_BOOK) {
            player.closeInventory();
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Please type the style name (GOAL, TASK, CHALLENGE) in chat. (Type 'cancel' to abort)");
            this.activeSessions.get(player.getUniqueId()).put("step", STEP_STYLE);
            return;
        }
        if (clickedItem.getType() == Material.BARRIER) {
            Map<String, Object> data = this.activeSessions.get(player.getUniqueId());
            if (data != null) {
                this.openCreatorEditorGUI(player, data);
            }
            return;
        }
        String styleName = ChatColor.stripColor((String)clickedItem.getItemMeta().getDisplayName());
        Map<String, Object> data = this.activeSessions.get(player.getUniqueId());
        if (data != null) {
            data.put(STEP_STYLE, styleName);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Style set to " + styleName + "!");
            this.openCreatorEditorGUI(player, data);
        }
    }

    private void handleIconSelectionGUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        String title = event.getView().getTitle();
        if (clickedItem == null) {
            return;
        }
        if (clickedItem.getType() == Material.WRITABLE_BOOK) {
            player.closeInventory();
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Please type the material name for the icon in chat. (Type 'cancel' to abort)");
            this.activeSessions.get(player.getUniqueId()).put("step", STEP_ICON);
            return;
        }
        if (clickedItem.getType() == Material.BARRIER) {
            Map<String, Object> data = this.activeSessions.get(player.getUniqueId());
            if (data != null) {
                this.openCreatorEditorGUI(player, data);
            }
            return;
        }
        if (clickedItem.getType() == Material.ARROW) {
            String currentPageStr = title.substring(title.indexOf("Page ") + 5, title.indexOf("/"));
            int currentPage = Integer.parseInt(currentPageStr) - 1;
            String itemName = ChatColor.stripColor((String)clickedItem.getItemMeta().getDisplayName());
            if (itemName.equals("Next Page")) {
                IconSelectionGUI.open(player, currentPage + 1);
            } else if (itemName.equals("Previous Page")) {
                IconSelectionGUI.open(player, currentPage - 1);
            }
            return;
        }
        Material selectedMaterial = clickedItem.getType();
        Map<String, Object> data = this.activeSessions.get(player.getUniqueId());
        if (data != null) {
            data.put(STEP_ICON, selectedMaterial.name());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Icon set to " + selectedMaterial.name() + "!");
            this.openCreatorEditorGUI(player, data);
        }
    }

    private void handleConfirmationGUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 11) {
            Runnable action = this.confirmationActions.remove(player.getUniqueId());
            if (action != null) {
                action.run();
            }
        } else if (event.getSlot() == 15) {
            this.confirmationActions.remove(player.getUniqueId());
            String rawLore = (String)event.getInventory().getItem(13).getItemMeta().getLore().get(0);
            String itemName = ChatColor.stripColor((String)rawLore).replace("Delete '", "").replace("'?", "");
            if (this.plugin.getConfig().isSet("presets." + itemName)) {
                this.openPresetsGUI(player);
            } else {
                this.openAutoAnnounceGUI(player);
            }
        }
    }

    private void saveChanges(Player player) {
        String newPathCheck;
        Map<String, Object> data = this.activeSessions.get(player.getUniqueId());
        String name = (String)data.get(STEP_NAME);
        if (name == null || name.isBlank() || name.equals("<not set>")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must set a name before saving!");
            return;
        }
        if (name.contains(".") || name.contains(" ")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "The name cannot contain periods or spaces.");
            return;
        }
        boolean isCreator = (Boolean)data.get("isCreator");
        String type = (String)data.get("type");
        String originalName = (String)data.get("originalName");
        if (!isCreator && originalName != null && !originalName.equals(name)) {
            String oldPath = type.equals("preset") ? "presets." + originalName : "auto-announce.messages." + originalName;
            this.plugin.getConfig().set(oldPath, null);
        }
        String string = newPathCheck = type.equals("preset") ? "presets." : "auto-announce.messages.";
        if (this.plugin.getConfig().contains(newPathCheck + name) && (isCreator || !originalName.equals(name))) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "An item with this name already exists!");
            return;
        }
        this.activeSessions.remove(player.getUniqueId());
        if (type.equals("preset")) {
            this.plugin.getConfig().set("presets." + name, data.get(STEP_MESSAGE));
        } else {
            String path = "auto-announce.messages." + name;
            this.plugin.getConfig().set(path + ".message", data.get(STEP_MESSAGE));
            this.plugin.getConfig().set(path + ".style", data.get(STEP_STYLE));
            this.plugin.getConfig().set(path + ".icon", data.get(STEP_ICON));
        }
        this.plugin.saveConfig();
        AutoAnnounce.stopAutoAnnounce();
        AutoAnnounce.startAutoAnnounce();
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Changes saved successfully!");
        if (type.equals("preset")) {
            this.openPresetsGUI(player);
        } else {
            this.openAutoAnnounceGUI(player);
        }
    }

    private void handlePresetsGUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (event.getSlot() == 45) {
            this.openEditGUI(player);
            return;
        }
        if (event.getSlot() == 53) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("isCreator", true);
            data.put("type", "preset");
            data.put(STEP_NAME, "<not set>");
            data.put(STEP_MESSAGE, "Default message");
            this.openCreatorEditorGUI(player, data);
            return;
        }
        if (clickedItem.getType() == Material.PAPER) {
            String presetName = ChatColor.stripColor((String)clickedItem.getItemMeta().getDisplayName());
            if (event.isRightClick()) {
                ConfirmationGUI.open(player, presetName);
                this.confirmationActions.put(player.getUniqueId(), () -> {
                    this.plugin.getConfig().set("presets." + presetName, null);
                    this.plugin.saveConfig();
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Preset '" + presetName + "' has been deleted.");
                    this.openPresetsGUI(player);
                });
            } else if (event.isLeftClick()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("isCreator", false);
                data.put("originalName", presetName);
                data.put("type", "preset");
                data.put(STEP_NAME, presetName);
                data.put(STEP_MESSAGE, this.plugin.getConfig().getString("presets." + presetName));
                this.openCreatorEditorGUI(player, data);
            }
        }
    }

    private void handleAutoAnnounceGUIClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        if (slot == 45) {
            this.openEditGUI(player);
            return;
        }
        switch (slot) {
            case 48: {
                boolean currentStatus = this.plugin.getConfig().getBoolean("auto-announce.enabled");
                this.plugin.getConfig().set("auto-announce.enabled", (Object)(!currentStatus ? 1 : 0));
                this.plugin.saveConfig();
                AutoAnnounce.stopAutoAnnounce();
                AutoAnnounce.startAutoAnnounce();
                this.openAutoAnnounceGUI(player);
                break;
            }
            case 49: {
                player.closeInventory();
                int currentInterval = this.plugin.getConfig().getInt("auto-announce.interval");
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Please type the new interval (in seconds) in chat.");
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Current: " + currentInterval);
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "(Type 'cancel' to exit)");
                this.activeSessions.put(player.getUniqueId(), (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("step", CommandHandler.STEP_INTERVAL);
                    }
                });
                break;
            }
            case 50: {
                String currentMode = this.plugin.getConfig().getString("auto-announce.mode");
                String newMode = currentMode.equalsIgnoreCase("ORDERED") ? "RANDOM" : "ORDERED";
                this.plugin.getConfig().set("auto-announce.mode", (Object)newMode);
                this.plugin.saveConfig();
                AutoAnnounce.stopAutoAnnounce();
                AutoAnnounce.startAutoAnnounce();
                this.openAutoAnnounceGUI(player);
                break;
            }
            case 53: {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("isCreator", true);
                data.put("type", "auto-announce");
                data.put(STEP_NAME, "<not set>");
                data.put(STEP_MESSAGE, "Default message");
                data.put(STEP_STYLE, "GOAL");
                data.put(STEP_ICON, "STONE");
                this.openCreatorEditorGUI(player, data);
                return;
            }
            default: {
                if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null || slot >= 45) break;
                String messageName = ChatColor.stripColor((String)event.getCurrentItem().getItemMeta().getDisplayName());
                if (event.isRightClick()) {
                    ConfirmationGUI.open(player, messageName);
                    this.confirmationActions.put(player.getUniqueId(), () -> {
                        this.plugin.getConfig().set("auto-announce.messages." + messageName, null);
                        this.plugin.saveConfig();
                        AutoAnnounce.stopAutoAnnounce();
                        AutoAnnounce.startAutoAnnounce();
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Auto-announce message '" + messageName + "' has been deleted.");
                        this.openAutoAnnounceGUI(player);
                    });
                    break;
                }
                if (!event.isLeftClick()) break;
                HashMap<String, Object> editData = new HashMap<String, Object>();
                String path = "auto-announce.messages." + messageName;
                editData.put("isCreator", false);
                editData.put("originalName", messageName);
                editData.put("type", "auto-announce");
                editData.put(STEP_NAME, messageName);
                editData.put(STEP_MESSAGE, this.plugin.getConfig().getString(path + ".message", ""));
                editData.put(STEP_STYLE, this.plugin.getConfig().getString(path + ".style", "GOAL"));
                editData.put(STEP_ICON, this.plugin.getConfig().getString(path + ".icon", "STONE"));
                this.openCreatorEditorGUI(player, editData);
            }
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (!this.activeSessions.containsKey(playerUUID)) {
            return;
        }
        Map<String, Object> data = this.activeSessions.get(playerUUID);
        String message = event.getMessage();
        if (data.containsKey("step")) {
            event.setCancelled(true);
            if (message.equalsIgnoreCase("cancel")) {
                data.remove("step");
                player.sendMessage(String.valueOf(ChatColor.RED) + "Input cancelled.");
                if (!data.containsKey("type")) {
                    this.activeSessions.remove(playerUUID);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.openAutoAnnounceGUI(player));
                } else {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.openCreatorEditorGUI(player, data));
                }
                return;
            }
            String step = (String)data.get("step");
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                switch (step) {
                    case "name": {
                        if (message.contains(".") || message.contains(" ")) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "The name cannot contain periods or spaces. Please try again.");
                            break;
                        }
                        data.put(STEP_NAME, message);
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Name set to '" + message + "'");
                        break;
                    }
                    case "message": {
                        data.put(STEP_MESSAGE, message);
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Message updated!");
                        break;
                    }
                    case "style": {
                        try {
                            AdvancementHandler.Style.valueOf(message.toUpperCase());
                            data.put(STEP_STYLE, message.toUpperCase());
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Style set to " + message.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid style! Please use GOAL, TASK, or CHALLENGE.");
                        }
                        break;
                    }
                    case "icon": {
                        try {
                            Material.valueOf((String)message.toUpperCase());
                            data.put(STEP_ICON, message.toUpperCase());
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Icon set to " + message.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid material name! Please try again.");
                        }
                        break;
                    }
                    case "interval": {
                        try {
                            int interval = Integer.parseInt(message);
                            this.plugin.getConfig().set("auto-announce.interval", (Object)interval);
                            this.plugin.saveConfig();
                            AutoAnnounce.stopAutoAnnounce();
                            AutoAnnounce.startAutoAnnounce();
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Interval has been set to " + interval + " seconds.");
                            this.activeSessions.remove(playerUUID);
                            this.openAutoAnnounceGUI(player);
                            return;
                        }
                        catch (NumberFormatException e) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid number. Please type a valid interval in seconds. Type 'cancel' to exit.");
                            return;
                        }
                    }
                }
                data.remove("step");
                this.openCreatorEditorGUI(player, data);
            });
        }
    }
}

