/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer.Handlers;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateChecker
implements Listener {
    private final AdvancementAnnouncer plugin;
    private final int resourceId;
    private String latestVersion;

    public UpdateChecker(AdvancementAnnouncer plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void getVersion(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
                 Scanner scanner = new Scanner(inputStream);){
                if (scanner.hasNext()) {
                    String version;
                    this.latestVersion = version = scanner.next();
                    consumer.accept(version);
                }
            }
            catch (IOException exception) {
                this.plugin.getLogger().info("Unable to check for updates: " + exception.getMessage());
            }
        });
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("advancementannouncer.admin") && this.latestVersion != null && UpdateChecker.isNewerVersion(this.plugin.getDescription().getVersion(), this.latestVersion)) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "A new version of AdvancementAnnouncer is available! (" + this.latestVersion + ")");
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Download it from: " + String.valueOf(ChatColor.AQUA) + "https://www.spigotmc.org/resources/advancementannouncer." + this.resourceId + "/");
            }, 20L);
        }
    }

    public static boolean isNewerVersion(String currentVersion, String latestVersion) {
        String current = currentVersion.replaceAll("[vV]", "");
        String latest = latestVersion.replaceAll("[vV]", "");
        String[] currentParts = current.split("\\.");
        String[] latestParts = latest.split("\\.");
        int length = Math.max(currentParts.length, latestParts.length);
        for (int i = 0; i < length; ++i) {
            try {
                int latestPart;
                int currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
                int n = latestPart = i < latestParts.length ? Integer.parseInt(latestParts[i]) : 0;
                if (latestPart > currentPart) {
                    return true;
                }
                if (latestPart >= currentPart) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return !currentVersion.equalsIgnoreCase(latestVersion);
            }
        }
        return false;
    }
}

