/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.advancementannouncer;

import io.github.altkat.advancementannouncer.AdvancementAnnouncer;
import java.io.File;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerData {
    private static File file;
    private static FileConfiguration config;
    private static AdvancementAnnouncer plugin;

    public PlayerData(AdvancementAnnouncer plugin) {
        PlayerData.plugin = plugin;
        this.load();
    }

    public void load() {
        file = new File(plugin.getDataFolder(), "data/playerdata.yml");
        if (!file.exists()) {
            plugin.saveResource("data/playerdata.yml", false);
        }
        if ((config = YamlConfiguration.loadConfiguration((File)file)).getKeys(false).isEmpty()) {
            config.createSection("default");
            PlayerData.save();
        }
    }

    public static void save() {
        try {
            config.save(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addPlayerData(UUID uuid) {
        config.createSection(uuid.toString());
        config.getConfigurationSection(uuid.toString()).set("toggleStatus", (Object)true);
        config.getConfigurationSection(uuid.toString()).set("playerName", (Object)plugin.getServer().getPlayer(uuid).getName());
        PlayerData.save();
    }

    public static void setToggleData(UUID uuid, boolean status) {
        config.getConfigurationSection(uuid.toString()).set("toggleStatus", (Object)status);
        PlayerData.save();
    }

    public static boolean returnToggleData(UUID uuid) {
        if (config.getConfigurationSection(uuid.toString()) == null) {
            PlayerData.addPlayerData(uuid);
        }
        return config.getConfigurationSection(uuid.toString()).getBoolean("toggleStatus");
    }

    public static void updatePlayerData(UUID uuid) {
        if (!config.getConfigurationSection(uuid.toString()).contains("toggleStatus")) {
            config.getConfigurationSection(uuid.toString()).set("toggleStatus", (Object)false);
        }
        PlayerData.save();
    }

    public static void reloadPlayerData() {
        try {
            if (!file.exists()) {
                plugin.saveResource("data/playerdata.yml", false);
            }
            config = YamlConfiguration.loadConfiguration((File)file);
            PlayerData.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

