/*
 * Decompiled with CFR 0.152.
 */
package tn.naizo.jauml;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraftforge.fml.loading.FMLPaths;

public class JaumlConfigLib {
    private static final Logger LOGGER = Logger.getLogger("JaumlConfigLib");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static boolean createConfigFile(String dir, String fileName) {
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        File configDir = FMLPaths.CONFIGDIR.get().resolve(dir).toFile();
        File configFile = new File(configDir, fileName);
        if (!configDir.exists()) {
            configDir.mkdirs();
        } else {
            LOGGER.log(Level.FINE, "Config directory already exists: {0}", configDir.getPath());
        }
        if (configFile.exists()) {
            return true;
        }
        try {
            return configFile.createNewFile();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to create config file: {0}", configFile.getPath());
            LOGGER.log(Level.SEVERE, "Exception: {0}", e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean stringExistsInArray(String dir, String fileName, String arrayKey, String targetString) {
        File configFile;
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve(fileName).toFile()).exists()) {
            return false;
        }
        try (FileReader reader = new FileReader(configFile);){
            String value;
            JsonElement item;
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root == null) return false;
            if (!root.has(arrayKey)) return false;
            JsonElement element = root.get(arrayKey);
            if (!element.isJsonArray()) return false;
            JsonArray array = element.getAsJsonArray();
            Iterator iterator = array.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(item = (JsonElement)iterator.next()).isJsonPrimitive() || !(value = item.getAsString()).contains(targetString));
            boolean bl = true;
            return bl;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean arrayKeyExists(String dir, String fileName, String key) {
        File configFile;
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve(fileName).toFile()).exists()) {
            return false;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root == null) return false;
            boolean bl = root.has(key);
            return bl;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean addStringToArray(String dir, String fileName, String arrayKey, String stringToAdd) {
        JsonArray array;
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        File configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve(fileName).toFile();
        JsonObject root = new JsonObject();
        if (configFile.exists()) {
            try {
                FileReader reader = new FileReader(configFile);
                Object object = null;
                try {
                    root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (root == null) {
                        root = new JsonObject();
                    }
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader != null) {
                        if (object != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object).addSuppressed(throwable3);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (JsonParseException | IOException e) {
                return false;
            }
        }
        if (root.has(arrayKey) && root.get(arrayKey).isJsonArray()) {
            array = root.getAsJsonArray(arrayKey);
        } else {
            array = new JsonArray();
            root.add(arrayKey, (JsonElement)array);
        }
        for (JsonElement element : array) {
            if (!element.isJsonPrimitive() || !element.getAsString().equals(stringToAdd)) continue;
            return false;
        }
        array.add(stringToAdd);
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((JsonElement)root, (Appendable)writer);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean configFileExists(String dir, String fileName) {
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        File configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve(fileName).toFile();
        return configFile.exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getArrayLength(String dir, String fileName, String arrayKey) {
        File configFile;
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve(fileName).toFile()).exists()) {
            return 0;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root == null) return 0;
            if (!root.has(arrayKey)) return 0;
            JsonElement element = root.get(arrayKey);
            if (!element.isJsonArray()) return 0;
            int n = element.getAsJsonArray().size();
            return n;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getArrayElement(String dir, String fileName, String arrayKey, int index) {
        File configFile;
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve(fileName).toFile()).exists()) {
            return null;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root == null) return null;
            if (!root.has(arrayKey)) return null;
            JsonElement element = root.get(arrayKey);
            if (!element.isJsonArray()) return null;
            JsonArray array = element.getAsJsonArray();
            if (index < 0) return null;
            if (index >= array.size()) return null;
            JsonElement item = array.get(index);
            if (!item.isJsonPrimitive()) return null;
            String string = item.getAsString();
            return string;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStringValue(String dir, String fileName, String key) {
        File configFile;
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve(fileName).toFile()).exists()) {
            return null;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root == null) return null;
            if (!root.has(key)) return null;
            JsonElement element = root.get(key);
            if (!element.isJsonPrimitive()) return null;
            if (!element.getAsJsonPrimitive().isString()) return null;
            String string = element.getAsString();
            return string;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static double getNumberValue(String dir, String fileName, String key) {
        block24: {
            Throwable throwable;
            FileReader reader;
            block21: {
                double d;
                block22: {
                    block23: {
                        JsonElement element;
                        File configFile;
                        if (!fileName.endsWith(".json")) {
                            fileName = fileName + ".json";
                        }
                        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve(fileName).toFile()).exists()) {
                            return 0.0;
                        }
                        reader = new FileReader(configFile);
                        throwable = null;
                        JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        if (root == null || !root.has(key) || !(element = root.get(key)).isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) break block21;
                        d = element.getAsNumber().doubleValue();
                        if (reader == null) break block22;
                        if (throwable == null) break block23;
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block22;
                    }
                    reader.close();
                }
                return d;
            }
            try {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        reader.close();
                    }
                }
                break block24;
                {
                    catch (Throwable throwable4) {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (reader != null) {
                                if (throwable != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                }
            }
            catch (JsonParseException | IOException e) {
                LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
            }
        }
        return 0.0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setStringValue(String dir, String fileName, String key, String value) {
        Throwable throwable;
        File configFile;
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve(fileName).toFile()).exists() && !JaumlConfigLib.createConfigFile(dir, fileName)) {
            LOGGER.log(Level.SEVERE, "Failed to create config file: {0}", configFile.getPath());
            return false;
        }
        JsonObject root = new JsonObject();
        if (configFile.exists()) {
            try {
                throwable = null;
                try (FileReader reader = new FileReader(configFile);){
                    root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (root == null) {
                        root = new JsonObject();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (JsonParseException | IOException e) {
                LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
                return false;
            }
        }
        root.addProperty(key, value);
        try {
            throwable = null;
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error writing to config file: {0}", e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setNumberValue(String dir, String fileName, String key, double value) {
        Throwable throwable;
        File configFile;
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve(fileName).toFile()).exists() && !JaumlConfigLib.createConfigFile(dir, fileName)) {
            LOGGER.log(Level.SEVERE, "Failed to create config file: {0}", configFile.getPath());
            return false;
        }
        JsonObject root = new JsonObject();
        if (configFile.exists()) {
            try {
                throwable = null;
                try (FileReader reader = new FileReader(configFile);){
                    root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (root == null) {
                        root = new JsonObject();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (JsonParseException | IOException e) {
                LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
                return false;
            }
        }
        root.addProperty(key, (Number)value);
        try {
            throwable = null;
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error writing to config file: {0}", e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean getBooleanValue(String dir, String fileName, String key) {
        File configFile;
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve(fileName).toFile()).exists()) {
            return false;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root == null) return false;
            if (!root.has(key)) return false;
            JsonElement element = root.get(key);
            if (!element.isJsonPrimitive()) return false;
            if (!element.getAsJsonPrimitive().isBoolean()) return false;
            boolean bl = element.getAsBoolean();
            return bl;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setBooleanValue(String dir, String fileName, String key, boolean value) {
        Throwable throwable;
        File configFile;
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve(fileName).toFile()).exists() && !JaumlConfigLib.createConfigFile(dir, fileName)) {
            LOGGER.log(Level.SEVERE, "Failed to create config file: {0}", configFile.getPath());
            return false;
        }
        JsonObject root = new JsonObject();
        if (configFile.exists()) {
            try {
                throwable = null;
                try (FileReader reader = new FileReader(configFile);){
                    root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (root == null) {
                        root = new JsonObject();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (JsonParseException | IOException e) {
                LOGGER.log(Level.SEVERE, "Error reading or parsing config file: {0}", e.getMessage());
                return false;
            }
        }
        root.addProperty(key, Boolean.valueOf(value));
        try {
            throwable = null;
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error writing to config file: {0}", e.getMessage());
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean clearArray(String dir, String fileName, String arrayKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean removeArrayElement(String dir, String fileName, String arrayKey, String valueToRemove) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> getArrayAsList(String dir, String fileName, String arrayKey) {
        File configFile;
        ArrayList<String> result = new ArrayList<String>();
        if (!fileName.endsWith(".json")) {
            fileName = fileName + ".json";
        }
        if (!(configFile = FMLPaths.CONFIGDIR.get().resolve(dir).resolve(fileName).toFile()).exists()) {
            return result;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonElement element;
            JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (root != null && root.has(arrayKey) && (element = root.get(arrayKey)).isJsonArray()) {
                for (JsonElement item : element.getAsJsonArray()) {
                    if (item.isJsonPrimitive() && item.getAsJsonPrimitive().isString()) {
                        result.add(item.getAsString());
                        continue;
                    }
                    result.add(item.toString());
                }
            }
        }
        catch (JsonParseException | IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading array as list: {0}", e.getMessage());
        }
        return result;
    }
}

