// use this script if you want idc

import fs from 'fs';

console.log("\x1b[33mGenerating Models...\x1b[0m");
const files = fs.readdirSync("./").filter((name) => name.endsWith(".json"));
const template = fs.readFileSync("./_template").toString();

for(let i = 0; i < files.length; i++) {
    const name = files[i];
    if (!name.endsWith("_3d.json")) continue;
    const name2D = name.replace("_3d.json", ".json");
    if (files.includes(name2D)) continue;
    console.log(`\x1b[1m\x1b[32m- Making File ${name2D}...\x1b[0m`);
    fs.writeFileSync(`./${name2D}`, template.replaceAll("var", name2D.replace(".json", "")));
}

console.log("\x1b[33mFinished!\x1b[0m");