/*
 * Decompiled with CFR 0.152.
 */
package com.github.pemistahl.lingua.api.io;

import com.github.pemistahl.lingua.api.Language;
import com.github.pemistahl.lingua.internal.Constant;
import com.github.pemistahl.lingua.internal.io.FilesWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J>\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J<\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0007J.\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/github/pemistahl/lingua/api/io/TestDataFilesWriter;", "Lcom/github/pemistahl/lingua/internal/io/FilesWriter;", "()V", "createAndWriteSentencesFile", "", "inputFilePath", "Ljava/nio/file/Path;", "inputFileCharset", "Ljava/nio/charset/Charset;", "outputDirectoryPath", "language", "Lcom/github/pemistahl/lingua/api/Language;", "maximumLines", "", "createAndWriteSingleWordsFile", "", "", "charClass", "createAndWriteTestDataFiles", "createAndWriteWordPairsFile", "words", "lingua"})
public final class TestDataFilesWriter
extends FilesWriter {
    @NotNull
    public static final TestDataFilesWriter INSTANCE = new TestDataFilesWriter();

    private TestDataFilesWriter() {
    }

    @JvmStatic
    public static final void createAndWriteTestDataFiles(@NotNull Path inputFilePath, @NotNull Charset inputFileCharset, @NotNull Path outputDirectoryPath, @NotNull Language language, @NotNull String charClass, int maximumLines) {
        Intrinsics.checkNotNullParameter(inputFilePath, "inputFilePath");
        Intrinsics.checkNotNullParameter(inputFileCharset, "inputFileCharset");
        Intrinsics.checkNotNullParameter(outputDirectoryPath, "outputDirectoryPath");
        Intrinsics.checkNotNullParameter((Object)language, "language");
        Intrinsics.checkNotNullParameter(charClass, "charClass");
        INSTANCE.checkInputFilePath(inputFilePath);
        INSTANCE.checkOutputDirectoryPath(outputDirectoryPath);
        INSTANCE.createAndWriteSentencesFile(inputFilePath, inputFileCharset, outputDirectoryPath, language, maximumLines);
        List<String> singleWords = INSTANCE.createAndWriteSingleWordsFile(inputFilePath, inputFileCharset, outputDirectoryPath, language, charClass, maximumLines);
        INSTANCE.createAndWriteWordPairsFile(singleWords, outputDirectoryPath, language, maximumLines);
    }

    public static /* synthetic */ void createAndWriteTestDataFiles$default(Path path, Charset charset, Path path2, Language language, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n2 & 0x10) != 0) {
            string = "\\p{L}";
        }
        TestDataFilesWriter.createAndWriteTestDataFiles(path, charset, path2, language, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void createAndWriteSentencesFile(Path inputFilePath, Charset inputFileCharset, Path outputDirectoryPath, Language language, int maximumLines) {
        void $this$useLines$iv;
        String fileName = (Object)((Object)language.getIsoCode639_1()) + ".txt";
        Path sentencesDirectoryPath = outputDirectoryPath.resolve("sentences");
        Path sentencesFilePath = sentencesDirectoryPath.resolve(fileName);
        int lineCounter = 0;
        if (!Files.isDirectory(sentencesDirectoryPath, new LinkOption[0])) {
            Files.createDirectory(sentencesDirectoryPath, new FileAttribute[0]);
        }
        if (Files.isRegularFile(sentencesFilePath, new LinkOption[0])) {
            Files.delete(sentencesFilePath);
        }
        File file = inputFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "inputFilePath.toFile()");
        Object object = file;
        int n = 8192;
        Object object2 = object;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), inputFileCharset);
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        boolean $i$f$useLines = false;
        object2 = $this$useLines$iv;
        int n2 = 8192;
        object2 = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n2);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)object2;
            boolean bl = false;
            Sequence<String> lines = TextStreamsKt.lineSequence(it$iv);
            boolean bl2 = false;
            File file2 = sentencesFilePath.toFile();
            Intrinsics.checkNotNullExpressionValue(file2, "sentencesFilePath.toFile()");
            Object object3 = file2;
            Object object4 = Charsets.UTF_8;
            int n3 = 8192;
            Object object5 = object3;
            object5 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object5), (Charset)object4);
            object3 = object5 instanceof BufferedWriter ? (BufferedWriter)object5 : new BufferedWriter((Writer)object5, n3);
            object4 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object3;
                boolean bl3 = false;
                Iterator<String> iterator2 = lines.iterator();
                while (iterator2.hasNext()) {
                    String line = iterator2.next();
                    if (lineCounter >= maximumLines) continue;
                    CharSequence charSequence = line;
                    Regex regex = Constant.INSTANCE.getMULTIPLE_WHITESPACE();
                    String string = " ";
                    writer.write(StringsKt.replace$default(regex.replace(charSequence, string), "\"", "", false, 4, null));
                    writer.newLine();
                    ++lineCounter;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                object4 = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<String> createAndWriteSingleWordsFile(Path inputFilePath, Charset inputFileCharset, Path outputDirectoryPath, Language language, String charClass, int maximumLines) {
        void $this$useLines$iv;
        String fileName = (Object)((Object)language.getIsoCode639_1()) + ".txt";
        Path singleWordsDirectoryPath = outputDirectoryPath.resolve("single-words");
        Path singleWordsFilePath = singleWordsDirectoryPath.resolve(fileName);
        Regex wordRegex = new Regex('[' + charClass + "]{5,}");
        List words = new ArrayList();
        int lineCounter = 0;
        if (!Files.isDirectory(singleWordsDirectoryPath, new LinkOption[0])) {
            Files.createDirectory(singleWordsDirectoryPath, new FileAttribute[0]);
        }
        if (Files.isRegularFile(singleWordsFilePath, new LinkOption[0])) {
            Files.delete(singleWordsFilePath);
        }
        File file = inputFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "inputFilePath.toFile()");
        Object object = file;
        int n = 8192;
        Object object2 = object;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), inputFileCharset);
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        boolean $i$f$useLines = false;
        object2 = $this$useLines$iv;
        int n2 = 8192;
        object2 = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n2);
        Object object3 = null;
        try {
            BufferedReader it$iv = (BufferedReader)object2;
            boolean bl = false;
            Sequence<String> lines = TextStreamsKt.lineSequence(it$iv);
            boolean bl2 = false;
            Iterator<String> iterator2 = lines.iterator();
            while (iterator2.hasNext()) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                String it;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                String line = iterator2.next();
                Object object4 = line;
                Regex regex = Constant.INSTANCE.getPUNCTUATION();
                String string = "";
                object4 = regex.replace((CharSequence)object4, string);
                regex = Constant.INSTANCE.getNUMBERS();
                string = "";
                object4 = regex.replace((CharSequence)object4, string);
                regex = Constant.INSTANCE.getMULTIPLE_WHITESPACE();
                string = " ";
                CharSequence charSequence = StringsKt.replace$default(regex.replace((CharSequence)object4, string), "\"", "", false, 4, null);
                object4 = new char[1];
                object4[0] = 32;
                object4 = StringsKt.split$default(charSequence, (char[])object4, false, 0, 6, null);
                boolean $i$f$map = false;
                string = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    String string3 = ((Object)StringsKt.trim((CharSequence)it)).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    collection.add(string3);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl4 = false;
                    if (!wordRegex.matches(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List singleWords = (List)destination$iv$iv;
                words.addAll(singleWords);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        File file2 = singleWordsFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue(file2, "singleWordsFilePath.toFile()");
        object = file2;
        Object object5 = Charsets.UTF_8;
        int n3 = 8192;
        object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object5);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n3);
        object5 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl = false;
            for (String word : words) {
                if (lineCounter >= maximumLines) break;
                writer.write(word);
                writer.newLine();
                ++lineCounter;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object5 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object5);
        }
        return words;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createAndWriteWordPairsFile(List<String> words, Path outputDirectoryPath, Language language, int maximumLines) {
        int n;
        int n2;
        int i;
        String fileName = (Object)((Object)language.getIsoCode639_1()) + ".txt";
        Path wordPairsDirectoryPath = outputDirectoryPath.resolve("word-pairs");
        Path wordPairsFilePath = wordPairsDirectoryPath.resolve(fileName);
        Set wordPairs = new LinkedHashSet();
        int lineCounter = 0;
        if (!Files.isDirectory(wordPairsDirectoryPath, new LinkOption[0])) {
            Files.createDirectory(wordPairsDirectoryPath, new FileAttribute[0]);
        }
        if (Files.isRegularFile(wordPairsFilePath, new LinkOption[0])) {
            Files.delete(wordPairsFilePath);
        }
        if ((i = 0) <= (n2 = ProgressionUtilKt.getProgressionLastElement(0, n = words.size() - 2, 2))) {
            while (true) {
                wordPairs.add(CollectionsKt.joinToString$default(CollectionsKt.slice(words, new IntRange(i, i + 1)), " ", null, null, 0, null, null, 62, null));
                if (i == n2) break;
                i += 2;
            }
        }
        File file = wordPairsFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "wordPairsFilePath.toFile()");
        Object object = file;
        Object object2 = Charsets.UTF_8;
        n2 = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n2);
        object2 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl = false;
            for (String wordPair : wordPairs) {
                if (lineCounter >= maximumLines) break;
                writer.write(wordPair);
                writer.newLine();
                ++lineCounter;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }
}

