/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang;

import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.texboobcat.autolang.config.ConfigManager;
import org.texboobcat.autolang.detect.HeuristicDetector;
import org.texboobcat.autolang.detect.LanguageDetector;
import org.texboobcat.autolang.detect.LinguaDetector;
import org.texboobcat.autolang.manager.TranslationManager;
import org.texboobcat.autolang.storage.PlayerLanguageService;
import org.texboobcat.autolang.storage.PlayerLanguageStore;
import org.texboobcat.autolang.storage.SQLitePlayerLanguageStore;
import org.texboobcat.autolang.storage.YamlPlayerLanguageStore;
import org.texboobcat.autolang.translate.LibreTranslateEngineAdapter;
import org.texboobcat.autolang.translate.LocalModelEngineAdapter;
import org.texboobcat.autolang.translate.RulebookEngine;
import org.texboobcat.autolang.translate.TranslationEngine;
import org.texboobcat.autolang.util.AsyncExecutor;
import org.texboobcat.autolang.util.LRUCache;

public final class Autolang {
    public static final String MOD_ID = "autolang";
    private static final Logger LOGGER = LoggerFactory.getLogger("autolang");
    private static Autolang INSTANCE;
    private ConfigManager configManager;
    private AsyncExecutor asyncExecutor;
    private PlayerLanguageService playerLanguageService;
    private LanguageDetector languageDetector;
    private TranslationEngine translationEngine;
    private TranslationManager translationManager;
    private Path configDir;

    public static Autolang getInstance() {
        return INSTANCE;
    }

    public static void init(Path configDirectory) {
        if (INSTANCE != null) {
            LOGGER.warn("AutoLang already initialized!");
            return;
        }
        INSTANCE = new Autolang();
        Autolang.INSTANCE.configDir = configDirectory;
        INSTANCE.onEnable();
        LOGGER.info("AutoLang mod initialized");
    }

    public static void shutdown() {
        if (INSTANCE != null) {
            INSTANCE.onDisable();
            INSTANCE = null;
        }
    }

    private void onEnable() {
        Path configFile = this.configDir.resolve("autolang.json");
        this.configManager = new ConfigManager(configFile, LOGGER);
        this.configManager.load();
        this.asyncExecutor = new AsyncExecutor(this.configManager.getMaxTranslationThreads());
        PlayerLanguageStore store = this.createStoreFromConfig();
        this.playerLanguageService = new PlayerLanguageService(this.configManager, store, this.configDir);
        this.languageDetector = this.createDetectorFromConfig();
        this.translationEngine = this.createEngineFromConfig();
        LRUCache<String, String> cache2 = new LRUCache<String, String>(this.configManager.getCacheSize(), this.configManager.getCacheTtlSeconds());
        this.translationManager = new TranslationManager(LOGGER, this.asyncExecutor, this.translationEngine, cache2, this.configManager.getTranslationTimeoutMs(), this.configManager.isCacheEnabled());
        LOGGER.info("AutoLang enabled. Languages: {}, threads: {}, detector: {}, engine: {}", this.configManager.getLanguages().size(), this.configManager.getMaxTranslationThreads(), this.languageDetector.getClass().getSimpleName(), this.translationEngine.getClass().getSimpleName());
    }

    private void onDisable() {
        TranslationEngine translationEngine = this.translationEngine;
        if (translationEngine instanceof LocalModelEngineAdapter) {
            LocalModelEngineAdapter adapter = (LocalModelEngineAdapter)translationEngine;
            adapter.shutdown();
        }
        if (this.asyncExecutor != null) {
            this.asyncExecutor.shutdown();
        }
        if (this.playerLanguageService != null) {
            this.playerLanguageService.shutdown();
        }
        LOGGER.info("AutoLang disabled.");
    }

    private TranslationEngine createEngineFromConfig() {
        if (this.configManager.isLibreTranslateEnabled()) {
            LOGGER.info("Using LibreTranslate engine");
            return new LibreTranslateEngineAdapter(this.configManager, LOGGER);
        }
        if (this.configManager.isLocalModelEnabled() && this.configManager.getLocalModelCommand() != null && !this.configManager.getLocalModelCommand().isEmpty()) {
            LOGGER.info("Using Local Model engine");
            return new LocalModelEngineAdapter(this.configManager, LOGGER);
        }
        LOGGER.info("Using Rulebook engine (fallback)");
        return new RulebookEngine(this.asyncExecutor);
    }

    private LanguageDetector createDetectorFromConfig() {
        String type2 = this.configManager.getDetectorType();
        if (type2 != null && type2.equalsIgnoreCase("lingua")) {
            if (this.configManager.getLanguages().size() >= 2) {
                try {
                    LOGGER.info("Using Lingua detector with {} languages", (Object)this.configManager.getLanguages().size());
                    return new LinguaDetector(this.configManager);
                }
                catch (Throwable e) {
                    LOGGER.warn("Failed to initialize Lingua detector, falling back to Heuristic: {}", (Object)e.getMessage());
                }
            } else {
                LOGGER.warn("Lingua detector requires at least 2 languages; falling back to Heuristic");
            }
        }
        LOGGER.info("Using Heuristic detector");
        return new HeuristicDetector(this.configManager);
    }

    private PlayerLanguageStore createStoreFromConfig() {
        String type2 = this.configManager.getStorageType();
        if ("yaml".equalsIgnoreCase(type2)) {
            LOGGER.info("Using YAML storage");
            return new YamlPlayerLanguageStore(this.configDir, LOGGER);
        }
        LOGGER.info("Using SQLite storage");
        Path sqlitePath = this.configDir.resolve("languages.db");
        LOGGER.info("SQLite database path: {}", (Object)sqlitePath.toAbsolutePath());
        LOGGER.info("Config directory: {}", (Object)this.configDir.toAbsolutePath());
        return new SQLitePlayerLanguageStore(sqlitePath, LOGGER);
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public AsyncExecutor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public PlayerLanguageService getPlayerLanguageService() {
        return this.playerLanguageService;
    }

    public LanguageDetector getLanguageDetector() {
        return this.languageDetector;
    }

    public TranslationManager getTranslationManager() {
        return this.translationManager;
    }

    public Path getConfigDir() {
        return this.configDir;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

