/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.detect;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.texboobcat.autolang.config.ConfigManager;
import org.texboobcat.autolang.detect.LanguageConfidence;
import org.texboobcat.autolang.detect.LanguageDetector;
import org.texboobcat.autolang.locale.Language;

public class LinguaDetector
implements LanguageDetector {
    private final ConfigManager config;
    private Object detector;
    private boolean initialized = false;
    private boolean initializationFailed = false;

    public LinguaDetector(ConfigManager config) {
        this.config = config;
    }

    private synchronized void ensureInitialized() {
        if (this.initialized || this.initializationFailed) {
            return;
        }
        try {
            Object builder;
            Class<?> languageClass = Class.forName("com.github.pemistahl.lingua.api.Language");
            Class<?> builderClass = Class.forName("com.github.pemistahl.lingua.api.LanguageDetectorBuilder");
            HashSet<Object> linguaLangs = new HashSet<Object>();
            for (Language lang : this.config.getLanguages()) {
                Object linguaLang = this.convertToLinguaLanguage(lang.getCode(), languageClass);
                if (linguaLang == null) continue;
                linguaLangs.add(linguaLang);
            }
            if (linguaLangs.isEmpty()) {
                builder = builderClass.getMethod("fromAllLanguages", new Class[0]).invoke(null, new Object[0]);
            } else {
                Object[] langArray = linguaLangs.toArray();
                builder = builderClass.getMethod("fromLanguages", langArray.getClass()).invoke(null, new Object[]{langArray});
            }
            this.detector = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
            this.initialized = true;
        }
        catch (Throwable e) {
            this.initializationFailed = true;
            throw new RuntimeException("Failed to initialize Lingua detector. Make sure lingua library is available.", e);
        }
    }

    @Override
    public Optional<LanguageConfidence> detectLanguage(String text) {
        if (text == null || text.isBlank()) {
            return Optional.empty();
        }
        this.ensureInitialized();
        if (this.initializationFailed || this.detector == null) {
            return Optional.empty();
        }
        try {
            Map confidenceMap = (Map)this.detector.getClass().getMethod("computeLanguageConfidenceValues", String.class).invoke(this.detector, text);
            if (confidenceMap == null || confidenceMap.isEmpty()) {
                return Optional.empty();
            }
            Map.Entry best = confidenceMap.entrySet().stream().max(Comparator.comparingDouble(Map.Entry::getValue)).orElse(null);
            if (best == null) {
                return Optional.empty();
            }
            String code = this.getIsoCodeReflectively(best.getKey());
            if (code == null) {
                return Optional.empty();
            }
            Language detectedLang = this.config.getLanguageByCode(code);
            if (detectedLang == null) {
                detectedLang = new Language(code, code);
            }
            double confidence = Math.max(0.0, Math.min(1.0, (Double)best.getValue()));
            return Optional.of(new LanguageConfidence(detectedLang, confidence));
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    private String getIsoCodeReflectively(Object linguaLanguage) {
        try {
            Object isoCode = linguaLanguage.getClass().getMethod("getIsoCode639_1", new Class[0]).invoke(linguaLanguage, new Object[0]);
            if (isoCode != null) {
                String name = (String)isoCode.getClass().getMethod("name", new Class[0]).invoke(isoCode, new Object[0]);
                return name.toLowerCase(Locale.ROOT);
            }
        }
        catch (Throwable isoCode) {
            // empty catch block
        }
        try {
            String name = (String)linguaLanguage.getClass().getMethod("name", new Class[0]).invoke(linguaLanguage, new Object[0]);
            return this.mapLanguageNameToCode(name.toLowerCase(Locale.ROOT));
        }
        catch (Throwable e) {
            return null;
        }
    }

    private String mapLanguageNameToCode(String name) {
        return switch (name) {
            case "english" -> "en";
            case "spanish" -> "es";
            case "french" -> "fr";
            case "german" -> "de";
            case "italian" -> "it";
            case "portuguese" -> "pt";
            case "russian" -> "ru";
            case "chinese" -> "zh";
            case "japanese" -> "ja";
            case "korean" -> "ko";
            case "arabic" -> "ar";
            case "hindi" -> "hi";
            case "turkish" -> "tr";
            case "polish" -> "pl";
            case "dutch" -> "nl";
            case "swedish" -> "sv";
            case "norwegian" -> "no";
            case "danish" -> "da";
            case "finnish" -> "fi";
            case "czech" -> "cs";
            case "greek" -> "el";
            case "hebrew" -> "he";
            case "indonesian" -> "id";
            case "malay" -> "ms";
            case "thai" -> "th";
            case "vietnamese" -> "vi";
            case "romanian" -> "ro";
            case "bulgarian" -> "bg";
            case "croatian" -> "hr";
            case "serbian" -> "sr";
            case "slovak" -> "sk";
            case "slovene", "slovenian" -> "sl";
            case "ukrainian" -> "uk";
            case "welsh" -> "cy";
            case "irish" -> "ga";
            case "estonian" -> "et";
            case "latvian" -> "lv";
            case "lithuanian" -> "lt";
            case "bengali" -> "bn";
            case "urdu" -> "ur";
            case "persian" -> "fa";
            case "hungarian" -> "hu";
            case "albanian" -> "sq";
            default -> null;
        };
    }

    private Object convertToLinguaLanguage(String code, Class<?> languageClass) {
        if (code == null) {
            return null;
        }
        try {
            Object[] allLanguages;
            String lowerCode = code.toLowerCase(Locale.ROOT);
            for (Object lang : allLanguages = (Object[])languageClass.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                String isoCode = this.getIsoCodeReflectively(lang);
                if (isoCode == null || !isoCode.equals(lowerCode)) continue;
                return lang;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

