/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.fabric.client;

import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.texboobcat.autolang.Autolang;
import org.texboobcat.autolang.config.ConfigManager;
import org.texboobcat.autolang.locale.Language;
import org.texboobcat.autolang.manager.TranslationManager;
import org.texboobcat.autolang.storage.PlayerLanguageService;

public class AutolangFabricClient
implements ClientModInitializer {
    private static final Pattern CHAT_PATTERN = Pattern.compile("^<([^>]+)> (.+)$");

    public void onInitializeClient() {
        this.autoDetectClientLocale();
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            if (overlay) {
                return;
            }
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null) {
                return;
            }
            if (mc.method_1496()) {
                return;
            }
            Autolang mod = Autolang.getInstance();
            if (mod == null) {
                return;
            }
            String messageText = message.getString();
            if (messageText == null || messageText.isEmpty()) {
                return;
            }
            if (messageText.startsWith("!")) {
                return;
            }
            Matcher matcher = CHAT_PATTERN.matcher(messageText);
            if (!matcher.matches()) {
                return;
            }
            String senderName = matcher.group(1);
            String chatMessage = matcher.group(2);
            ConfigManager config = mod.getConfigManager();
            PlayerLanguageService pls = mod.getPlayerLanguageService();
            TranslationManager tm = mod.getTranslationManager();
            UUID clientUUID = mc.field_1724.method_5667();
            Language targetLang = pls.getLanguage(clientUUID).orElse(config.getDefaultLanguage());
            Language sourceLang = config.getDefaultLanguage();
            if (targetLang.getCode().equalsIgnoreCase(sourceLang.getCode())) {
                return;
            }
            HashSet<Language> targets = new HashSet<Language>();
            targets.add(targetLang);
            ((CompletableFuture)tm.translateForRecipients(chatMessage, sourceLang, targets).orTimeout(config.getTranslationTimeoutMs(), TimeUnit.MILLISECONDS).thenAccept(translations -> {
                String translated = translations.getOrDefault(targetLang, chatMessage);
                mc.execute(() -> {
                    class_5250 translatedComponent = class_2561.method_43470((String)("\u00a77[Translated] \u00a7f<" + senderName + "> " + translated));
                    mc.field_1705.method_1743().method_1812((class_2561)translatedComponent);
                });
            })).exceptionally(ex -> {
                mod.getLogger().error("Client-side translation failed", (Throwable)ex);
                return null;
            });
        });
    }

    private void autoDetectClientLocale() {
        try {
            class_310 mc = class_310.method_1551();
            if (mc == null) {
                return;
            }
            Autolang mod = Autolang.getInstance();
            if (mod == null) {
                return;
            }
            String clientLocale = mc.field_1690.field_1883;
            if (clientLocale == null || clientLocale.isEmpty()) {
                return;
            }
            if (mc.field_1724 != null) {
                Language detectedLang;
                UUID clientUUID = mc.field_1724.method_5667();
                PlayerLanguageService pls = mod.getPlayerLanguageService();
                if (!pls.hasLanguage(clientUUID) && (detectedLang = this.mapClientLocaleToLanguage(clientLocale, mod)) != null) {
                    pls.setLanguage(clientUUID, detectedLang);
                    mod.getLogger().info("Auto-detected client language: {} ({})", (Object)detectedLang.getName(), (Object)detectedLang.getCode());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Language mapClientLocaleToLanguage(String clientLocale, Autolang mod) {
        if (clientLocale == null || clientLocale.isEmpty()) {
            return null;
        }
        String[] parts = clientLocale.toLowerCase().split("_");
        String baseCode = parts[0];
        if (baseCode.equals("zh")) {
            if (clientLocale.toLowerCase().contains("cn") || clientLocale.toLowerCase().contains("hans")) {
                baseCode = "zh";
            } else if (clientLocale.toLowerCase().contains("tw") || clientLocale.toLowerCase().contains("hant")) {
                baseCode = "zh";
            }
        } else if (baseCode.equals("pt")) {
            baseCode = clientLocale.toLowerCase().contains("br") ? "pt" : "pt";
        }
        Language lang = mod.getConfigManager().getLanguageByCode(baseCode);
        return lang;
    }
}

