/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.fabric.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.texboobcat.autolang.Autolang;
import org.texboobcat.autolang.locale.Language;
import org.texboobcat.autolang.storage.PlayerLanguageService;

public class FabricLanguageCommand {
    private static final SuggestionProvider<class_2168> LANGUAGE_SUGGESTIONS = (context, builder) -> FabricLanguageCommand.suggestLanguages(builder);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lang").executes(ctx -> FabricLanguageCommand.listLanguages((CommandContext<class_2168>)ctx))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"language", (ArgumentType)StringArgumentType.string()).suggests(LANGUAGE_SUGGESTIONS).executes(ctx -> FabricLanguageCommand.setLanguage((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"language")))))).then(class_2170.method_9247((String)"view").executes(ctx -> FabricLanguageCommand.viewLanguage((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source2 -> source2.method_9259(2))).executes(ctx -> FabricLanguageCommand.reloadConfig((CommandContext<class_2168>)ctx))));
    }

    private static CompletableFuture<Suggestions> suggestLanguages(SuggestionsBuilder builder) {
        Autolang mod = Autolang.getInstance();
        if (mod != null) {
            List<Language> languages = mod.getConfigManager().getLanguages();
            for (Language lang : languages) {
                builder.suggest(lang.getCode(), (Message)class_2561.method_43470((String)lang.getName()));
            }
        }
        return builder.buildFuture();
    }

    private static int listLanguages(CommandContext<class_2168> ctx) {
        Autolang mod = Autolang.getInstance();
        if (mod == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cAutoLang not initialized"));
            return 0;
        }
        List<Language> languages = mod.getConfigManager().getLanguages();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aAvailable languages:"), false);
        for (Language lang : languages) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7e- " + lang.getCode() + "\u00a77: " + lang.getName())), false);
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a77Use \u00a7e/lang set <code>\u00a77 to set your language"), false);
        return 1;
    }

    private static int setLanguage(CommandContext<class_2168> ctx, String langCode) {
        class_1297 class_12972 = ((class_2168)ctx.getSource()).method_9228();
        if (!(class_12972 instanceof class_3222)) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cOnly players can use this command"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        Autolang mod = Autolang.getInstance();
        if (mod == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cAutoLang not initialized"));
            return 0;
        }
        Language language = mod.getConfigManager().getLanguageByCode(langCode);
        if (language == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7cLanguage not found: " + langCode)));
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a77Use \u00a7e/lang\u00a77 to see available languages"));
            return 0;
        }
        PlayerLanguageService pls = mod.getPlayerLanguageService();
        pls.setLanguage(player.method_5667(), language);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aLanguage set to: \u00a7e" + language.getName() + " (" + language.getCode() + ")")), false);
        return 1;
    }

    private static int viewLanguage(CommandContext<class_2168> ctx) {
        class_1297 class_12972 = ((class_2168)ctx.getSource()).method_9228();
        if (!(class_12972 instanceof class_3222)) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cOnly players can use this command"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        Autolang mod = Autolang.getInstance();
        if (mod == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cAutoLang not initialized"));
            return 0;
        }
        PlayerLanguageService pls = mod.getPlayerLanguageService();
        Language language = pls.getLanguage(player.method_5667()).orElse(mod.getConfigManager().getDefaultLanguage());
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aYour language: \u00a7e" + language.getName() + " (" + language.getCode() + ")")), false);
        return 1;
    }

    private static int reloadConfig(CommandContext<class_2168> ctx) {
        Autolang mod = Autolang.getInstance();
        if (mod == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cAutoLang not initialized"));
            return 0;
        }
        try {
            mod.getConfigManager().load();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aConfiguration reloaded successfully"), false);
            return 1;
        }
        catch (Exception e) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("\u00a7cFailed to reload configuration: " + e.getMessage())));
            return 0;
        }
    }
}

