/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.fabric.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7471;
import org.texboobcat.autolang.Autolang;
import org.texboobcat.autolang.config.ConfigManager;
import org.texboobcat.autolang.locale.Language;
import org.texboobcat.autolang.manager.TranslationManager;
import org.texboobcat.autolang.storage.PlayerLanguageService;

public class FabricChatHandler
implements ServerMessageEvents.AllowChatMessage {
    public boolean allowChatMessage(class_7471 message, class_3222 sender, class_2556.class_7602 params) {
        String messageText = message.method_44862();
        if (messageText == null || messageText.isEmpty()) {
            return true;
        }
        if (messageText.startsWith("!")) {
            return true;
        }
        Autolang mod = Autolang.getInstance();
        if (mod == null) {
            return true;
        }
        ConfigManager config = mod.getConfigManager();
        PlayerLanguageService pls = mod.getPlayerLanguageService();
        TranslationManager tm = mod.getTranslationManager();
        Language senderLang = pls.getLanguage(sender.method_5667()).orElse(config.getDefaultLanguage());
        if (!pls.hasLanguage(sender.method_5667()) && config.isAutodetectEnabled() && pls.shouldAttemptDetection(sender.method_5667())) {
            mod.getAsyncExecutor().execute(() -> mod.getLanguageDetector().detectLanguage(messageText).ifPresent(lc -> {
                if (lc.getConfidence() >= config.getAutodetectConfidenceThreshold()) {
                    sender.method_43496((class_2561)class_2561.method_43470((String)("\u00a7eDetected language: " + lc.getLanguage().getName() + " (" + lc.getLanguage().getCode() + ")")));
                    sender.method_43496((class_2561)class_2561.method_43470((String)("\u00a7aUse \u00a7e/lang set " + lc.getLanguage().getCode() + "\u00a7a to accept, or \u00a7e/lang\u00a7a to choose manually")));
                }
            }));
        }
        List recipients = sender.method_5682().method_3760().method_14571();
        HashMap<Language, List> groups2 = new HashMap<Language, List>();
        for (class_3222 player : recipients) {
            Language lang = pls.getLanguage(player.method_5667()).orElse(config.getDefaultLanguage());
            groups2.computeIfAbsent(lang, k -> new ArrayList()).add(player);
        }
        Set<Language> targetLangs = groups2.keySet();
        try {
            String finalMessage = messageText;
            CompletableFuture<Map<Language, String>> translationFuture = tm.translateForRecipients(finalMessage, senderLang, targetLangs).orTimeout(config.getTranslationTimeoutMs(), TimeUnit.MILLISECONDS);
            ((CompletableFuture)translationFuture.thenAccept(translations -> {
                for (Map.Entry entry : groups2.entrySet()) {
                    Language lang = (Language)entry.getKey();
                    String translated = translations.getOrDefault(lang, finalMessage);
                    class_5250 chatComponent = class_2561.method_43470((String)("<" + sender.method_5477().getString() + "> " + translated));
                    for (class_3222 player : (List)entry.getValue()) {
                        player.method_43496((class_2561)chatComponent);
                    }
                }
            })).exceptionally(ex -> {
                mod.getLogger().error("Translation failed", (Throwable)ex);
                class_5250 originalMessage = class_2561.method_43470((String)("<" + sender.method_5477().getString() + "> " + finalMessage));
                for (class_3222 player : recipients) {
                    player.method_43496((class_2561)originalMessage);
                }
                return null;
            });
        }
        catch (Exception e) {
            mod.getLogger().error("Error handling chat translation", e);
            return true;
        }
        return false;
    }
}

