/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.fabric.event;

import java.lang.reflect.Field;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.texboobcat.autolang.Autolang;
import org.texboobcat.autolang.locale.Language;
import org.texboobcat.autolang.storage.PlayerLanguageService;

public class FabricPlayerJoinHandler {
    public static void register() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> FabricPlayerJoinHandler.onPlayerJoin(handler.field_14140));
    }

    private static void onPlayerJoin(class_3222 player) {
        Language detectedLang;
        Autolang mod = Autolang.getInstance();
        if (mod == null) {
            return;
        }
        PlayerLanguageService pls = mod.getPlayerLanguageService();
        if (pls.hasLanguage(player.method_5667())) {
            return;
        }
        String clientLocale = null;
        try {
            if (player.field_13987 != null) {
                Field languageField = player.field_13987.getClass().getSuperclass().getDeclaredField("language");
                languageField.setAccessible(true);
                clientLocale = (String)languageField.get(player.field_13987);
            }
        }
        catch (Exception e) {
            mod.getLogger().warn("Could not retrieve client locale via reflection: {}", (Object)e.getMessage());
        }
        if (clientLocale != null && !clientLocale.isEmpty() && (detectedLang = FabricPlayerJoinHandler.mapClientLocaleToLanguage(clientLocale, mod)) != null) {
            pls.setLanguage(player.method_5667(), detectedLang);
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a7aWelcome! Your language has been automatically set to: \u00a7e" + detectedLang.getName() + " (" + detectedLang.getCode() + ")")));
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a77Based on your client locale: \u00a7e" + clientLocale)));
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a77Use \u00a7e/lang set <code>\u00a77 if you want to change it"));
            return;
        }
        player.method_43496((class_2561)class_2561.method_43470((String)"\u00a7eWelcome! Please set your preferred language with \u00a7a/lang\u00a7e or \u00a7a/lang set <code>"));
    }

    private static Language mapClientLocaleToLanguage(String clientLocale, Autolang mod) {
        if (clientLocale == null || clientLocale.isEmpty()) {
            return null;
        }
        String[] parts = clientLocale.toLowerCase().split("_");
        String baseCode = parts[0];
        if (baseCode.equals("zh")) {
            if (clientLocale.toLowerCase().contains("cn") || clientLocale.toLowerCase().contains("hans")) {
                baseCode = "zh";
            } else if (clientLocale.toLowerCase().contains("tw") || clientLocale.toLowerCase().contains("hant")) {
                baseCode = "zh";
            }
        } else if (baseCode.equals("pt")) {
            baseCode = clientLocale.toLowerCase().contains("br") ? "pt" : "pt";
        }
        Language lang = mod.getConfigManager().getLanguageByCode(baseCode);
        if (lang != null) {
            return lang;
        }
        return null;
    }
}

