/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.storage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.texboobcat.autolang.storage.PlayerLanguageStore;

public class YamlPlayerLanguageStore
implements PlayerLanguageStore {
    private final Path dataFile;
    private final Logger logger;
    private final Map<UUID, String> cache = new ConcurrentHashMap<UUID, String>();

    public YamlPlayerLanguageStore(Path dataFolder, Logger logger) {
        this.dataFile = dataFolder.resolve("player_languages.txt");
        this.logger = logger;
        this.load();
    }

    private void load() {
        block13: {
            if (!Files.exists(this.dataFile, new LinkOption[0])) {
                return;
            }
            try {
                BufferedReader reader = Files.newBufferedReader(this.dataFile);
                block9: while (true) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String[] parts;
                        if ((line = line.trim()).isEmpty() || line.startsWith("#") || (parts = line.split("=", 2)).length != 2) continue;
                        try {
                            UUID uuid = UUID.fromString(parts[0].trim());
                            String code = parts[1].trim();
                            this.cache.put(uuid, code);
                            continue block9;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                    break block13;
                    {
                        continue block9;
                        break;
                    }
                    break;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                this.logger.error("Failed to load player languages from file", e);
            }
        }
    }

    private synchronized void save() {
        try {
            Files.createDirectories(this.dataFile.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.dataFile, new OpenOption[0]);){
                writer.write("# AutoLang Player Language Preferences\n");
                writer.write("# Format: uuid=language_code\n");
                for (Map.Entry<UUID, String> entry : this.cache.entrySet()) {
                    writer.write(entry.getKey().toString() + "=" + entry.getValue() + "\n");
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to save player languages to file", e);
        }
    }

    @Override
    public Optional<String> getLanguageCode(UUID uuid) {
        return Optional.ofNullable(this.cache.get(uuid));
    }

    @Override
    public void setLanguageCode(UUID uuid, String languageCode) {
        this.cache.put(uuid, languageCode);
        this.save();
    }

    @Override
    public boolean hasLanguage(UUID uuid) {
        return this.cache.containsKey(uuid);
    }

    @Override
    public Map<UUID, String> getAll() {
        return new HashMap<UUID, String>(this.cache);
    }

    @Override
    public void importAll(Map<UUID, String> data2) {
        this.cache.putAll(data2);
        this.save();
    }

    @Override
    public void shutdown() {
        this.save();
    }
}

