/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.translate;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.slf4j.Logger;
import org.texboobcat.autolang.config.ConfigManager;
import org.texboobcat.autolang.locale.Language;
import org.texboobcat.autolang.translate.TranslationEngine;

public class LibreTranslateEngineAdapter
implements TranslationEngine {
    private final ConfigManager config;
    private final Logger logger;
    private final HttpClient httpClient;
    private final Gson gson;

    public LibreTranslateEngineAdapter(ConfigManager config, Logger logger) {
        this.config = config;
        this.logger = logger;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
        this.gson = new Gson();
    }

    @Override
    public String translate(String sourceText, Language from, Language to) throws Exception {
        if (sourceText == null || sourceText.isEmpty()) {
            return sourceText;
        }
        if (from.getCode().equalsIgnoreCase(to.getCode())) {
            return sourceText;
        }
        String baseUrl = this.config.getLibreTranslateBaseUrl();
        if (baseUrl == null || baseUrl.isEmpty()) {
            this.logger.error("LibreTranslate base URL not configured");
            throw new IllegalStateException("LibreTranslate base URL not configured");
        }
        if (!this.isLocalhost(baseUrl) && !this.config.isLibreTranslateAllowRemote()) {
            this.logger.warn("LibreTranslate base-url is remote and allow-remote is false. Skipping translation.");
            return sourceText;
        }
        String url = baseUrl.endsWith("/") ? baseUrl + "translate" : baseUrl + "/translate";
        JsonObject body = new JsonObject();
        body.addProperty("q", sourceText);
        body.addProperty("source", from.getCode());
        body.addProperty("target", to.getCode());
        body.addProperty("format", "text");
        String apiKey = this.config.getLibreTranslateApiKey();
        if (apiKey != null && !apiKey.isEmpty()) {
            body.addProperty("api_key", apiKey);
        }
        String json = this.gson.toJson(body);
        this.logger.debug("Translating from {} to {}: {}", from.getCode(), to.getCode(), sourceText);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(5L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).build();
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            if (response.statusCode() != 200) {
                this.logger.warn("LibreTranslate returned status {}: {}", (Object)response.statusCode(), (Object)response.body());
                return sourceText;
            }
            JsonObject result2 = this.gson.fromJson(response.body(), JsonObject.class);
            if (result2 == null || !result2.has("translatedText")) {
                this.logger.warn("LibreTranslate response missing translatedText field: {}", (Object)response.body());
                return sourceText;
            }
            String translated = result2.get("translatedText").getAsString();
            if (translated == null || translated.isBlank()) {
                this.logger.warn("LibreTranslate returned empty translation");
                return sourceText;
            }
            this.logger.debug("Translated to: {}", (Object)translated);
            return translated;
        }
        catch (Exception e) {
            this.logger.error("LibreTranslate request failed: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    private boolean isLocalhost(String baseUrl) {
        if (baseUrl == null) {
            return false;
        }
        String lower = baseUrl.toLowerCase();
        return lower.contains("localhost") || lower.contains("127.0.0.1") || lower.contains("0.0.0.0");
    }
}

