/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.forge;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.platform.forge.EventBuses;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import org.texboobcat.autolang.Autolang;
import org.texboobcat.autolang.forge.client.AutolangForgeClient;
import org.texboobcat.autolang.forge.command.ForgeLanguageCommand;
import org.texboobcat.autolang.forge.event.ForgeChatHandler;
import org.texboobcat.autolang.forge.event.ForgePlayerJoinHandler;

@Mod(value="autolang")
public class AutolangForge {
    public AutolangForge() {
        EventBuses.registerModEventBus((String)"autolang", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeChatHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ForgePlayerJoinHandler());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("autolang");
        Autolang.init(configDir);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        AutolangForgeClient.init();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ForgeLanguageCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

