/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.forge.client;

import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.texboobcat.autolang.Autolang;
import org.texboobcat.autolang.config.ConfigManager;
import org.texboobcat.autolang.locale.Language;
import org.texboobcat.autolang.manager.TranslationManager;
import org.texboobcat.autolang.storage.PlayerLanguageService;

@Mod.EventBusSubscriber(modid="autolang", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class AutolangForgeClient {
    private static final Pattern CHAT_PATTERN = Pattern.compile("^<([^>]+)> (.+)$");

    public static void init() {
        MinecraftForge.EVENT_BUS.register(AutolangForgeClient.class);
        AutolangForgeClient.autoDetectClientLocale();
    }

    private static void autoDetectClientLocale() {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc == null) {
                return;
            }
            Autolang mod = Autolang.getInstance();
            if (mod == null) {
                return;
            }
            String clientLocale = mc.f_91066_.f_92075_;
            if (clientLocale == null || clientLocale.isEmpty()) {
                return;
            }
            if (mc.f_91074_ != null) {
                Language detectedLang;
                UUID clientUUID = mc.f_91074_.m_20148_();
                PlayerLanguageService pls = mod.getPlayerLanguageService();
                if (!pls.hasLanguage(clientUUID) && (detectedLang = AutolangForgeClient.mapClientLocaleToLanguage(clientLocale, mod)) != null) {
                    pls.setLanguage(clientUUID, detectedLang);
                    mod.getLogger().info("Auto-detected client language: {} ({})", (Object)detectedLang.getName(), (Object)detectedLang.getCode());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Language mapClientLocaleToLanguage(String clientLocale, Autolang mod) {
        if (clientLocale == null || clientLocale.isEmpty()) {
            return null;
        }
        String[] parts = clientLocale.toLowerCase().split("_");
        String baseCode = parts[0];
        if (baseCode.equals("zh")) {
            if (clientLocale.toLowerCase().contains("cn") || clientLocale.toLowerCase().contains("hans")) {
                baseCode = "zh";
            } else if (clientLocale.toLowerCase().contains("tw") || clientLocale.toLowerCase().contains("hant")) {
                baseCode = "zh";
            }
        } else if (baseCode.equals("pt")) {
            baseCode = clientLocale.toLowerCase().contains("br") ? "pt" : "pt";
        }
        Language lang = mod.getConfigManager().getLanguageByCode(baseCode);
        return lang;
    }

    @SubscribeEvent
    public static void onClientChatReceived(ClientChatReceivedEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (mc.m_91091_()) {
            return;
        }
        Autolang mod = Autolang.getInstance();
        if (mod == null) {
            return;
        }
        String message = event.getMessage().getString();
        if (message == null || message.isEmpty()) {
            return;
        }
        if (message.startsWith("!")) {
            return;
        }
        Matcher matcher = CHAT_PATTERN.matcher(message);
        if (!matcher.matches()) {
            return;
        }
        String senderName = matcher.group(1);
        String chatMessage = matcher.group(2);
        ConfigManager config = mod.getConfigManager();
        PlayerLanguageService pls = mod.getPlayerLanguageService();
        TranslationManager tm = mod.getTranslationManager();
        UUID clientUUID = mc.f_91074_.m_20148_();
        Language targetLang = pls.getLanguage(clientUUID).orElse(config.getDefaultLanguage());
        Language sourceLang = config.getDefaultLanguage();
        if (targetLang.getCode().equalsIgnoreCase(sourceLang.getCode())) {
            return;
        }
        HashSet<Language> targets = new HashSet<Language>();
        targets.add(targetLang);
        ((CompletableFuture)tm.translateForRecipients(chatMessage, sourceLang, targets).orTimeout(config.getTranslationTimeoutMs(), TimeUnit.MILLISECONDS).thenAccept(translations -> {
            String translated = translations.getOrDefault(targetLang, chatMessage);
            event.setCanceled(true);
            mc.execute(() -> {
                MutableComponent translatedComponent = Component.m_237113_((String)("<" + senderName + "> " + translated));
                mc.f_91065_.m_93076_().m_93785_((Component)translatedComponent);
            });
        })).exceptionally(ex -> {
            mod.getLogger().error("Client-side translation failed", ex);
            return null;
        });
    }
}

