/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.forge.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.texboobcat.autolang.Autolang;
import org.texboobcat.autolang.locale.Language;
import org.texboobcat.autolang.storage.PlayerLanguageService;

public class ForgeLanguageCommand {
    private static final SuggestionProvider<CommandSourceStack> LANGUAGE_SUGGESTIONS = (context, builder) -> ForgeLanguageCommand.suggestLanguages(builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lang").executes(ctx -> ForgeLanguageCommand.listLanguages((CommandContext<CommandSourceStack>)ctx))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"language", (ArgumentType)StringArgumentType.string()).suggests(LANGUAGE_SUGGESTIONS).executes(ctx -> ForgeLanguageCommand.setLanguage((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"language")))))).then(Commands.m_82127_((String)"view").executes(ctx -> ForgeLanguageCommand.viewLanguage((CommandContext<CommandSourceStack>)ctx)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(source2 -> source2.m_6761_(2))).executes(ctx -> ForgeLanguageCommand.reloadConfig((CommandContext<CommandSourceStack>)ctx))));
    }

    private static CompletableFuture<Suggestions> suggestLanguages(SuggestionsBuilder builder) {
        Autolang mod = Autolang.getInstance();
        if (mod != null) {
            List<Language> languages = mod.getConfigManager().getLanguages();
            for (Language lang : languages) {
                builder.suggest(lang.getCode(), (Message)Component.m_237113_((String)lang.getName()));
            }
        }
        return builder.buildFuture();
    }

    private static int listLanguages(CommandContext<CommandSourceStack> ctx) {
        Autolang mod = Autolang.getInstance();
        if (mod == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7cAutoLang not initialized"));
            return 0;
        }
        List<Language> languages = mod.getConfigManager().getLanguages();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7aAvailable languages:"), false);
        for (Language lang : languages) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7e- " + lang.getCode() + "\u00a77: " + lang.getName())), false);
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77Use \u00a7e/lang set <code>\u00a77 to set your language"), false);
        return 1;
    }

    private static int setLanguage(CommandContext<CommandSourceStack> ctx, String langCode) {
        Entity entity = ((CommandSourceStack)ctx.getSource()).m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7cOnly players can use this command"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        Autolang mod = Autolang.getInstance();
        if (mod == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7cAutoLang not initialized"));
            return 0;
        }
        Language language = mod.getConfigManager().getLanguageByCode(langCode);
        if (language == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7cLanguage not found: " + langCode)));
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a77Use \u00a7e/lang\u00a77 to see available languages"));
            return 0;
        }
        PlayerLanguageService pls = mod.getPlayerLanguageService();
        pls.setLanguage(player.m_20148_(), language);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7aLanguage set to: \u00a7e" + language.getName() + " (" + language.getCode() + ")")), false);
        return 1;
    }

    private static int viewLanguage(CommandContext<CommandSourceStack> ctx) {
        Entity entity = ((CommandSourceStack)ctx.getSource()).m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7cOnly players can use this command"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        Autolang mod = Autolang.getInstance();
        if (mod == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7cAutoLang not initialized"));
            return 0;
        }
        PlayerLanguageService pls = mod.getPlayerLanguageService();
        Language language = pls.getLanguage(player.m_20148_()).orElse(mod.getConfigManager().getDefaultLanguage());
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7aYour language: \u00a7e" + language.getName() + " (" + language.getCode() + ")")), false);
        return 1;
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> ctx) {
        Autolang mod = Autolang.getInstance();
        if (mod == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7cAutoLang not initialized"));
            return 0;
        }
        try {
            mod.getConfigManager().load();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7aConfiguration reloaded successfully"), false);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7cFailed to reload configuration: " + e.getMessage())));
            return 0;
        }
    }
}

