/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.forge.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.texboobcat.autolang.Autolang;
import org.texboobcat.autolang.config.ConfigManager;
import org.texboobcat.autolang.locale.Language;
import org.texboobcat.autolang.manager.TranslationManager;
import org.texboobcat.autolang.storage.PlayerLanguageService;

public class ForgeChatHandler {
    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        ServerPlayer sender = event.getPlayer();
        String message = event.getMessage().getString();
        if (message == null || message.isEmpty()) {
            return;
        }
        if (message.startsWith("!")) {
            return;
        }
        Autolang mod = Autolang.getInstance();
        if (mod == null) {
            return;
        }
        ConfigManager config = mod.getConfigManager();
        PlayerLanguageService pls = mod.getPlayerLanguageService();
        TranslationManager tm = mod.getTranslationManager();
        Language senderLang = pls.getLanguage(sender.m_20148_()).orElse(config.getDefaultLanguage());
        if (!pls.hasLanguage(sender.m_20148_()) && config.isAutodetectEnabled() && pls.shouldAttemptDetection(sender.m_20148_())) {
            mod.getAsyncExecutor().execute(() -> mod.getLanguageDetector().detectLanguage(message).ifPresent(lc -> {
                if (lc.getConfidence() >= config.getAutodetectConfidenceThreshold()) {
                    sender.m_213846_((Component)Component.m_237113_((String)("\u00a7eDetected language: " + lc.getLanguage().getName() + " (" + lc.getLanguage().getCode() + ")")));
                    sender.m_213846_((Component)Component.m_237113_((String)("\u00a7aUse \u00a7e/lang set " + lc.getLanguage().getCode() + "\u00a7a to accept, or \u00a7e/lang\u00a7a to choose manually")));
                }
            }));
        }
        List recipients = sender.m_20194_().m_6846_().m_11314_();
        HashMap<Language, List> groups2 = new HashMap<Language, List>();
        for (ServerPlayer player : recipients) {
            Language lang = pls.getLanguage(player.m_20148_()).orElse(config.getDefaultLanguage());
            groups2.computeIfAbsent(lang, k -> new ArrayList()).add(player);
        }
        Set<Language> targetLangs = groups2.keySet();
        try {
            CompletableFuture<Map<Language, String>> translationFuture = tm.translateForRecipients(message, senderLang, targetLangs).orTimeout(config.getTranslationTimeoutMs(), TimeUnit.MILLISECONDS);
            ((CompletableFuture)translationFuture.thenAccept(translations -> {
                for (Map.Entry entry : groups2.entrySet()) {
                    Language lang = (Language)entry.getKey();
                    String translated = translations.getOrDefault(lang, message);
                    MutableComponent chatComponent = Component.m_237113_((String)("<" + sender.m_7755_().getString() + "> " + translated));
                    for (ServerPlayer player : (List)entry.getValue()) {
                        player.m_213846_((Component)chatComponent);
                    }
                }
            })).exceptionally(ex -> {
                mod.getLogger().error("Translation failed", ex);
                return null;
            });
            event.setCanceled(true);
        }
        catch (Exception e) {
            mod.getLogger().error("Error handling chat translation", (Throwable)e);
        }
    }
}

