/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.forge.event;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.texboobcat.autolang.Autolang;
import org.texboobcat.autolang.locale.Language;
import org.texboobcat.autolang.storage.PlayerLanguageService;

public class ForgePlayerJoinHandler {
    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Language detectedLang;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Autolang mod = Autolang.getInstance();
        if (mod == null) {
            return;
        }
        PlayerLanguageService pls = mod.getPlayerLanguageService();
        if (pls.hasLanguage(player2.m_20148_())) {
            return;
        }
        String clientLocale = null;
        try {
            if (player2.f_8906_ != null) {
                clientLocale = player2.f_8906_.m_142253_().getLanguage();
            }
        }
        catch (Exception e) {
            mod.getLogger().warn("Could not retrieve client locale: {}", (Object)e.getMessage());
        }
        if (clientLocale != null && !clientLocale.isEmpty() && (detectedLang = this.mapClientLocaleToLanguage(clientLocale, mod)) != null) {
            pls.setLanguage(player2.m_20148_(), detectedLang);
            player2.m_213846_((Component)Component.m_237113_((String)("\u00a7aWelcome! Your language has been automatically set to: \u00a7e" + detectedLang.getName() + " (" + detectedLang.getCode() + ")")));
            player2.m_213846_((Component)Component.m_237113_((String)("\u00a77Based on your client locale: \u00a7e" + clientLocale)));
            player2.m_213846_((Component)Component.m_237113_((String)"\u00a77Use \u00a7e/lang set <code>\u00a77 if you want to change it"));
            return;
        }
        player2.m_213846_((Component)Component.m_237113_((String)"\u00a7eWelcome! Please set your preferred language with \u00a7a/lang\u00a7e or \u00a7a/lang set <code>"));
    }

    private Language mapClientLocaleToLanguage(String clientLocale, Autolang mod) {
        if (clientLocale == null || clientLocale.isEmpty()) {
            return null;
        }
        String[] parts = clientLocale.toLowerCase().split("_");
        String baseCode = parts[0];
        if (baseCode.equals("zh")) {
            if (clientLocale.toLowerCase().contains("cn") || clientLocale.toLowerCase().contains("hans")) {
                baseCode = "zh";
            } else if (clientLocale.toLowerCase().contains("tw") || clientLocale.toLowerCase().contains("hant")) {
                baseCode = "zh";
            }
        } else if (baseCode.equals("pt")) {
            baseCode = clientLocale.toLowerCase().contains("br") ? "pt" : "pt";
        }
        Language lang = mod.getConfigManager().getLanguageByCode(baseCode);
        if (lang != null) {
            return lang;
        }
        return null;
    }
}

