/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.libs.gson.internal.bind;

import org.texboobcat.autolang.libs.gson.Gson;
import org.texboobcat.autolang.libs.gson.JsonDeserializer;
import org.texboobcat.autolang.libs.gson.JsonSerializer;
import org.texboobcat.autolang.libs.gson.TypeAdapter;
import org.texboobcat.autolang.libs.gson.TypeAdapterFactory;
import org.texboobcat.autolang.libs.gson.annotations.JsonAdapter;
import org.texboobcat.autolang.libs.gson.internal.ConstructorConstructor;
import org.texboobcat.autolang.libs.gson.internal.bind.TreeTypeAdapter;
import org.texboobcat.autolang.libs.gson.reflect.TypeToken;

public final class JsonAdapterAnnotationTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public JsonAdapterAnnotationTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> targetType) {
        Class<T> rawType = targetType.getRawType();
        JsonAdapter annotation = rawType.getAnnotation(JsonAdapter.class);
        if (annotation == null) {
            return null;
        }
        return this.getTypeAdapter(this.constructorConstructor, gson, targetType, annotation);
    }

    TypeAdapter<?> getTypeAdapter(ConstructorConstructor constructorConstructor, Gson gson, TypeToken<?> type2, JsonAdapter annotation) {
        TypeAdapter<?> typeAdapter;
        Object instance = constructorConstructor.get(TypeToken.get(annotation.value())).construct();
        boolean nullSafe = annotation.nullSafe();
        if (instance instanceof TypeAdapter) {
            typeAdapter = (TypeAdapter<?>)instance;
        } else if (instance instanceof TypeAdapterFactory) {
            typeAdapter = ((TypeAdapterFactory)instance).create(gson, type2);
        } else if (instance instanceof JsonSerializer || instance instanceof JsonDeserializer) {
            JsonSerializer serializer = instance instanceof JsonSerializer ? (JsonSerializer)instance : null;
            JsonDeserializer deserializer = instance instanceof JsonDeserializer ? (JsonDeserializer)instance : null;
            TreeTypeAdapter tempAdapter = new TreeTypeAdapter(serializer, deserializer, gson, type2, null, nullSafe);
            typeAdapter = tempAdapter;
            nullSafe = false;
        } else {
            throw new IllegalArgumentException("Invalid attempt to bind an instance of " + instance.getClass().getName() + " as a @JsonAdapter for " + type2.toString() + ". @JsonAdapter value must be a TypeAdapter, TypeAdapterFactory, JsonSerializer or JsonDeserializer.");
        }
        if (typeAdapter != null && nullSafe) {
            typeAdapter = typeAdapter.nullSafe();
        }
        return typeAdapter;
    }
}

