/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.libs.lingua.api;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.io.Closeable;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.texboobcat.autolang.libs.lingua.api.Language;
import org.texboobcat.autolang.libs.lingua.internal.Alphabet;
import org.texboobcat.autolang.libs.lingua.internal.Constant;
import org.texboobcat.autolang.libs.lingua.internal.Ngram;
import org.texboobcat.autolang.libs.lingua.internal.TestDataLanguageModel;
import org.texboobcat.autolang.libs.lingua.internal.TrainingDataLanguageModel;
import org.texboobcat.autolang.libs.lingua.internal.util.extension.CharExtensionsKt;
import org.texboobcat.autolang.libs.lingua.internal.util.extension.MapExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0014\u0018\u0000 G2\u00020\u0001:\u0001GB7\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001dJ\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010\u001c\u001a\u00020\u001bJ/\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!0\u00182\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%H\u0000\u00a2\u0006\u0002\b&J&\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u00042\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0%H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\b+J/\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010-\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%H\u0000\u00a2\u0006\u0002\b.J\b\u0010/\u001a\u000200H\u0007J\u000e\u00101\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001bJ\u001b\u00102\u001a\u00020\u00042\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001b04H\u0000\u00a2\u0006\u0002\b5J\u0013\u00106\u001a\u00020\b2\b\u00107\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J!\u00108\u001a\b\u0012\u0004\u0012\u00020\u00040%2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001b04H\u0000\u00a2\u0006\u0002\b9J\b\u0010:\u001a\u00020\u000bH\u0016J%\u0010;\u001a\u00020!2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010<\u001a\u00020*H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b=\u0010>J\b\u0010?\u001a\u000200H\u0002J\u001b\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001b042\u0006\u0010\u001c\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\bAJU\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!0\u00182\u0018\u0010C\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!0\u0018042\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u00182\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%H\u0000\u00a2\u0006\u0002\bEJ\u0006\u0010F\u001a\u000200R\u0014\u0010\t\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00040\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006H"}, d2={"Lorg/texboobcat/autolang/libs/lingua/api/LanguageDetector;", "", "languages", "", "Lorg/texboobcat/autolang/libs/lingua/api/Language;", "minimumRelativeDistance", "", "isEveryLanguageModelPreloaded", "", "isLowAccuracyModeEnabled", "numberOfLoadedLanguages", "", "(Ljava/util/Set;DZZI)V", "isLowAccuracyModeEnabled$lingua", "()Z", "getLanguages$lingua", "()Ljava/util/Set;", "languagesWithUniqueCharacters", "Lkotlin/sequences/Sequence;", "getMinimumRelativeDistance$lingua", "()D", "getNumberOfLoadedLanguages$lingua", "()I", "oneLanguageAlphabets", "", "Lorg/texboobcat/autolang/libs/lingua/internal/Alphabet;", "cleanUpInputText", "", "text", "cleanUpInputText$lingua", "computeLanguageConfidenceValues", "Ljava/util/SortedMap;", "computeLanguageProbabilities", "", "testDataModel", "Lorg/texboobcat/autolang/libs/lingua/internal/TestDataLanguageModel;", "filteredLanguages", "", "computeLanguageProbabilities$lingua", "computeSumOfNgramProbabilities", "language", "ngrams", "Lorg/texboobcat/autolang/libs/lingua/internal/Ngram;", "computeSumOfNgramProbabilities$lingua", "countUnigramsOfInputText", "unigramLanguageModel", "countUnigramsOfInputText$lingua", "destroy", "", "detectLanguageOf", "detectLanguageWithRules", "words", "", "detectLanguageWithRules$lingua", "equals", "other", "filterLanguagesByRules", "filterLanguagesByRules$lingua", "hashCode", "lookUpNgramProbability", "ngram", "lookUpNgramProbability-as5wtIs$lingua", "(Lcom/github/pemistahl/lingua/api/Language;Ljava/lang/String;)F", "preloadLanguageModels", "splitTextIntoWords", "splitTextIntoWords$lingua", "sumUpProbabilities", "probabilities", "unigramCountsOfInputText", "sumUpProbabilities$lingua", "unloadLanguageModels", "Companion", "lingua"})
public final class LanguageDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Language> languages;
    private final double minimumRelativeDistance;
    private final boolean isLowAccuracyModeEnabled;
    private final int numberOfLoadedLanguages;
    @NotNull
    private final Sequence<Language> languagesWithUniqueCharacters;
    @NotNull
    private final Map<Alphabet, Language> oneLanguageAlphabets;
    private static final int HIGH_ACCURACY_MODE_MAX_TEXT_LENGTH = 120;
    @NotNull
    private static final EnumMap<Language, Object2FloatMap<String>> unigramLanguageModels;
    @NotNull
    private static final EnumMap<Language, Object2FloatMap<String>> bigramLanguageModels;
    @NotNull
    private static final EnumMap<Language, Object2FloatMap<String>> trigramLanguageModels;
    @NotNull
    private static final EnumMap<Language, Object2FloatMap<String>> quadrigramLanguageModels;
    @NotNull
    private static final EnumMap<Language, Object2FloatMap<String>> fivegramLanguageModels;

    /*
     * WARNING - void declaration
     */
    public LanguageDetector(@NotNull Set<Language> languages, double minimumRelativeDistance, boolean isEveryLanguageModelPreloaded, boolean isLowAccuracyModeEnabled, int numberOfLoadedLanguages) {
        void $this$filterValues$iv;
        void $this$filterNotTo$iv$iv;
        Map<Alphabet, Language> $this$filterNot$iv;
        Intrinsics.checkNotNullParameter(languages, "languages");
        this.languages = languages;
        this.minimumRelativeDistance = minimumRelativeDistance;
        this.isLowAccuracyModeEnabled = isLowAccuracyModeEnabled;
        this.numberOfLoadedLanguages = numberOfLoadedLanguages;
        Iterable iterable = this.languages;
        LanguageDetector languageDetector = this;
        boolean $i$f$filterNot = false;
        void var9_9 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Language it = (Language)((Object)element$iv$iv);
            boolean bl = false;
            CharSequence charSequence = it.getUniqueCharacters$lingua();
            if (charSequence == null || StringsKt.isBlank(charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        languageDetector.languagesWithUniqueCharacters = CollectionsKt.asSequence((List)destination$iv$iv);
        $this$filterNot$iv = Alphabet.Companion.allSupportingExactlyOneLanguage();
        languageDetector = this;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            Language it = (Language)((Object)entry$iv.getValue());
            boolean bl = false;
            if (!this.languages.contains((Object)it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        languageDetector.oneLanguageAlphabets = result$iv;
        if (isEveryLanguageModelPreloaded) {
            this.preloadLanguageModels();
        }
    }

    public /* synthetic */ LanguageDetector(Set set, double d, boolean bl, boolean bl2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            n = set.size();
        }
        this(set, d, bl, bl2, n);
    }

    @NotNull
    public final Set<Language> getLanguages$lingua() {
        return this.languages;
    }

    public final double getMinimumRelativeDistance$lingua() {
        return this.minimumRelativeDistance;
    }

    public final boolean isLowAccuracyModeEnabled$lingua() {
        return this.isLowAccuracyModeEnabled;
    }

    public final int getNumberOfLoadedLanguages$lingua() {
        return this.numberOfLoadedLanguages;
    }

    @NotNull
    public final Language detectLanguageOf(@NotNull String text) {
        Language language;
        Intrinsics.checkNotNullParameter(text, "text");
        SortedMap<Language, Double> confidenceValues = this.computeLanguageConfidenceValues(text);
        if (confidenceValues.isEmpty()) {
            return Language.UNKNOWN;
        }
        Language mostLikelyLanguage = confidenceValues.firstKey();
        if (confidenceValues.size() == 1) {
            Intrinsics.checkNotNullExpressionValue((Object)mostLikelyLanguage, "mostLikelyLanguage");
            return mostLikelyLanguage;
        }
        Double mostLikelyLanguageProbability = (Double)MapsKt.getValue((Map)confidenceValues, mostLikelyLanguage);
        Collection<Double> collection = confidenceValues.values();
        Intrinsics.checkNotNullExpressionValue(collection, "confidenceValues.values");
        Double secondMostLikelyLanguageProbability = (Double)CollectionsKt.elementAt((Iterable)collection, 1);
        if (Intrinsics.areEqual(mostLikelyLanguageProbability, secondMostLikelyLanguageProbability)) {
            language = Language.UNKNOWN;
        } else {
            double d = mostLikelyLanguageProbability;
            Intrinsics.checkNotNullExpressionValue(secondMostLikelyLanguageProbability, "secondMostLikelyLanguageProbability");
            if (d - secondMostLikelyLanguageProbability < this.minimumRelativeDistance) {
                language = Language.UNKNOWN;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)mostLikelyLanguage, "mostLikelyLanguage");
                language = mostLikelyLanguage;
            }
        }
        return language;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SortedMap<Language, Double> computeLanguageConfidenceValues(@NotNull String text) {
        Comparator sortedByConfidenceValue;
        void $this$mapValuesTo$iv$iv;
        Object v2;
        Map<Language, Integer> unigramCounts2;
        Map<Language, Float> summedUpProbabilities;
        Object item$iv$iv4;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Object object;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        int i;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(text, "text");
        TreeMap values2 = new TreeMap();
        String cleanedUpText = this.cleanUpInputText$lingua(text);
        if (((CharSequence)cleanedUpText).length() == 0 || Constant.INSTANCE.getNO_LETTER().matches(cleanedUpText)) {
            return values2;
        }
        List<String> words = this.splitTextIntoWords$lingua(cleanedUpText);
        Language languageDetectedByRules = this.detectLanguageWithRules$lingua(words);
        if (languageDetectedByRules != Language.UNKNOWN) {
            ((Map)values2).put(languageDetectedByRules, 1.0);
            return values2;
        }
        Set<Language> filteredLanguages2 = this.filterLanguagesByRules$lingua(words);
        if (filteredLanguages2.size() == 1) {
            Language filteredLanguage = filteredLanguages2.iterator().next();
            ((Map)values2).put(filteredLanguage, 1.0);
            return values2;
        }
        if (this.isLowAccuracyModeEnabled && cleanedUpText.length() < 3) {
            return values2;
        }
        IntRange ngramSizeRange = cleanedUpText.length() >= 120 || this.isLowAccuracyModeEnabled ? new IntRange(3, 3) : new IntRange(1, 5);
        Iterable $this$filter$iv = ngramSizeRange;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            i = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(cleanedUpText.length() >= i)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
            i = ((Number)item$iv$iv2).intValue();
            object = destination$iv$iv;
            boolean bl = false;
            object.add(() -> LanguageDetector.computeLanguageConfidenceValues$lambda-5$lambda-4(cleanedUpText, i, this, filteredLanguages2));
        }
        List tasks2 = (List)destination$iv$iv;
        List list = ForkJoinPool.commonPool().invokeAll(tasks2);
        Intrinsics.checkNotNullExpressionValue(list, "commonPool().invokeAll(tasks)");
        Iterable $this$map$iv2 = list;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
            void it;
            Future bl = (Future)item$iv$iv3;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.add((Pair)it.get());
        }
        List allProbabilitiesAndUnigramCounts = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = allProbabilitiesAndUnigramCounts;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
        boolean $i$f$mapTo3 = false;
        Object item$iv$iv3 = $this$mapTo$iv$iv.iterator();
        while (item$iv$iv3.hasNext()) {
            Object item$iv$iv4 = item$iv$iv3.next();
            Pair bl2 = (Pair)item$iv$iv4;
            object = destination$iv$iv3;
            boolean bl = false;
            Map probabilities = (Map)bl2.component1();
            object.add(probabilities);
        }
        List allProbabilities = (List)destination$iv$iv3;
        Map<Language, Integer> map = (Map<Language, Integer>)((Pair)allProbabilitiesAndUnigramCounts.get(0)).getSecond();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        if (!(item$iv$iv4 = (item$iv$iv3 = (Iterable)(summedUpProbabilities = this.sumUpProbabilities$lingua(allProbabilities, unigramCounts2 = map, filteredLanguages2)).entrySet()).iterator()).hasNext()) {
            v2 = null;
        } else {
            Object bl2 = item$iv$iv4.next();
            if (!item$iv$iv4.hasNext()) {
                v2 = bl2;
            } else {
                Map.Entry it22 = (Map.Entry)bl2;
                boolean bl3 = false;
                float it22 = ((Number)it22.getValue()).floatValue();
                do {
                    Object bl3 = item$iv$iv4.next();
                    Map.Entry it32 = (Map.Entry)bl3;
                    boolean $i$a$-maxByOrNull-LanguageDetector$computeLanguageConfidenceValues$highestProbability$2 = false;
                    float it32 = ((Number)it32.getValue()).floatValue();
                    if (Float.compare(it22, it32) >= 0) continue;
                    bl2 = bl3;
                    it22 = it32;
                } while (item$iv$iv4.hasNext());
                v2 = bl2;
            }
        }
        Map.Entry entry = v2;
        if (entry == null) {
            return MapsKt.sortedMapOf(new Pair[0]);
        }
        float highestProbability = ((Number)entry.getValue()).floatValue();
        Map<Language, Float> $this$mapValues$iv = summedUpProbabilities;
        boolean $i$f$mapValues = false;
        item$iv$iv4 = $this$mapValues$iv;
        Map destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv4;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map2;
            boolean bl4 = false;
            Double d = highestProbability / ((Number)it.getValue()).floatValue();
            object.put(k, d);
        }
        Map confidenceValues = destination$iv$iv4;
        Comparator comparator = sortedByConfidenceValue = (Comparator)new Comparator(confidenceValues){
            final /* synthetic */ Map $confidenceValues$inlined;
            {
                this.$confidenceValues$inlined = map;
            }

            public final int compare(T a, T b) {
                Language language = (Language)((Object)b);
                boolean bl = false;
                Comparable comparable = (Comparable)this.$confidenceValues$inlined.get((Object)((Object)language));
                language = (Language)((Object)a);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)this.$confidenceValues$inlined.get((Object)((Object)language)));
            }
        };
        Comparator sortedByConfidenceValueThenByLanguage = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Language language = (Language)((Object)a);
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)language);
                    language = (Language)((Object)b);
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, (Comparable)((Object)language));
                }
                return n;
            }
        };
        return MapsKt.toSortedMap(confidenceValues, sortedByConfidenceValueThenByLanguage);
    }

    @Deprecated(message="since 1.2.0, will be removed in 1.3.0", replaceWith=@ReplaceWith(expression="unloadLanguageModels()", imports={}))
    public final void destroy() {
        this.unloadLanguageModels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unloadLanguageModels() {
        Language p0;
        Iterable $this$forEach$iv;
        boolean $i$f$forEach;
        EnumMap<Language, Object2FloatMap<String>> enumMap;
        EnumMap<Language, Object2FloatMap<String>> enumMap2 = trigramLanguageModels;
        synchronized (enumMap2) {
            boolean $i$a$-synchronized-LanguageDetector$unloadLanguageModels$62 = false;
            Iterable iterable = this.languages;
            enumMap = trigramLanguageModels;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (Language)((Object)element$iv);
                boolean bl = false;
                enumMap.remove((Object)p0);
            }
            Unit $i$a$-synchronized-LanguageDetector$unloadLanguageModels$62 = Unit.INSTANCE;
        }
        if (!this.isLowAccuracyModeEnabled) {
            enumMap2 = unigramLanguageModels;
            synchronized (enumMap2) {
                boolean $i$a$-synchronized-LanguageDetector$unloadLanguageModels$72 = false;
                $this$forEach$iv = this.languages;
                enumMap = unigramLanguageModels;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    p0 = (Language)((Object)element$iv);
                    boolean bl = false;
                    enumMap.remove((Object)p0);
                }
                Unit $i$a$-synchronized-LanguageDetector$unloadLanguageModels$72 = Unit.INSTANCE;
            }
            enumMap2 = bigramLanguageModels;
            synchronized (enumMap2) {
                boolean $i$a$-synchronized-LanguageDetector$unloadLanguageModels$82 = false;
                $this$forEach$iv = this.languages;
                enumMap = bigramLanguageModels;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    p0 = (Language)((Object)element$iv);
                    boolean bl = false;
                    enumMap.remove((Object)p0);
                }
                Unit $i$a$-synchronized-LanguageDetector$unloadLanguageModels$82 = Unit.INSTANCE;
            }
            enumMap2 = quadrigramLanguageModels;
            synchronized (enumMap2) {
                boolean $i$a$-synchronized-LanguageDetector$unloadLanguageModels$92 = false;
                $this$forEach$iv = this.languages;
                enumMap = quadrigramLanguageModels;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    p0 = (Language)((Object)element$iv);
                    boolean bl = false;
                    enumMap.remove((Object)p0);
                }
                Unit $i$a$-synchronized-LanguageDetector$unloadLanguageModels$92 = Unit.INSTANCE;
            }
            enumMap2 = fivegramLanguageModels;
            synchronized (enumMap2) {
                boolean bl = false;
                $this$forEach$iv = this.languages;
                enumMap = fivegramLanguageModels;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    p0 = (Language)((Object)element$iv);
                    boolean bl2 = false;
                    enumMap.remove((Object)p0);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @NotNull
    public final String cleanUpInputText$lingua(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        String string = ((Object)StringsKt.trim((CharSequence)text)).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        CharSequence charSequence = string;
        Regex regex = Constant.INSTANCE.getPUNCTUATION();
        String string2 = "";
        charSequence = regex.replace(charSequence, string2);
        regex = Constant.INSTANCE.getNUMBERS();
        string2 = "";
        charSequence = regex.replace(charSequence, string2);
        regex = Constant.INSTANCE.getMULTIPLE_WHITESPACE();
        string2 = " ";
        return regex.replace(charSequence, string2);
    }

    @NotNull
    public final List<String> splitTextIntoWords$lingua(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        List words = new ArrayList();
        int nextWordStart = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            if (c == ' ') {
                if (nextWordStart != i) {
                    String string = text.substring(nextWordStart, i);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    words.add(string);
                }
                nextWordStart = i + 1;
                continue;
            }
            if (!CharExtensionsKt.isLogogram(c)) continue;
            if (nextWordStart != i) {
                String string = text.substring(nextWordStart, i);
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                words.add(string);
            }
            words.add(String.valueOf(text.charAt(i)));
            nextWordStart = i + 1;
        }
        if (nextWordStart != text.length()) {
            String string = text.substring(nextWordStart, text.length());
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            words.add(string);
        }
        return words;
    }

    @NotNull
    public final Map<Language, Integer> countUnigramsOfInputText$lingua(@NotNull TestDataLanguageModel unigramLanguageModel, @NotNull Set<? extends Language> filteredLanguages2) {
        Intrinsics.checkNotNullParameter(unigramLanguageModel, "unigramLanguageModel");
        Intrinsics.checkNotNullParameter(filteredLanguages2, "filteredLanguages");
        Map unigramCounts2 = new LinkedHashMap();
        for (Language language : filteredLanguages2) {
            Iterator<Ngram> iterator2 = unigramLanguageModel.getNgrams().iterator();
            while (iterator2.hasNext()) {
                String unigram = iterator2.next().unbox-impl();
                float probability = this.lookUpNgramProbability-as5wtIs$lingua(language, unigram);
                if (!(probability > 0.0f)) continue;
                MapExtensionsKt.incrementCounter(unigramCounts2, language);
            }
        }
        return unigramCounts2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Language, Float> sumUpProbabilities$lingua(@NotNull List<? extends Map<Language, Float>> probabilities, @NotNull Map<Language, Integer> unigramCountsOfInputText, @NotNull Set<? extends Language> filteredLanguages2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(probabilities, "probabilities");
        Intrinsics.checkNotNullParameter(unigramCountsOfInputText, "unigramCountsOfInputText");
        Intrinsics.checkNotNullParameter(filteredLanguages2, "filteredLanguages");
        Map summedUpProbabilities = new LinkedHashMap();
        for (Language language : filteredLanguages2) {
            float sum = 0.0f;
            for (Map<Language, Float> map : probabilities) {
                Float f = map.get((Object)language);
                sum += f != null ? f.floatValue() : 0.0f;
            }
            Float f = Float.valueOf(sum);
            summedUpProbabilities.put(language, f);
            if (!unigramCountsOfInputText.containsKey((Object)language)) continue;
            summedUpProbabilities.put(language, Float.valueOf(((Number)MapsKt.getValue(summedUpProbabilities, language)).floatValue() / ((Number)MapsKt.getValue(unigramCountsOfInputText, language)).floatValue()));
        }
        Map $this$filter$iv = summedUpProbabilities;
        boolean bl = false;
        Map sum = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean bl2 = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl3 = false;
            if (!(!(((Number)it.getValue()).floatValue() == 0.0f))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Language detectLanguageWithRules$lingua(@NotNull List<String> words) {
        int secondCharCount;
        int unknownLanguageCount;
        Intrinsics.checkNotNullParameter(words, "words");
        Map totalLanguageCounts = new LinkedHashMap();
        for (String word : words) {
            int secondCharCount2;
            Map wordLanguageCounts = new LinkedHashMap();
            int n = word.length();
            for (int i = 0; i < n; ++i) {
                void $this$forEach$iv;
                char character = word.charAt(i);
                boolean isMatch = false;
                for (Map.Entry<Alphabet, Language> entry : this.oneLanguageAlphabets.entrySet()) {
                    Alphabet alphabet = entry.getKey();
                    Language language = entry.getValue();
                    if (!alphabet.matches(character)) continue;
                    MapExtensionsKt.incrementCounter(wordLanguageCounts, language);
                    isMatch = true;
                    break;
                }
                if (isMatch) continue;
                if (Alphabet.HAN.matches(character)) {
                    MapExtensionsKt.incrementCounter(wordLanguageCounts, Language.CHINESE);
                    continue;
                }
                if (Constant.INSTANCE.isJapaneseAlphabet(character)) {
                    MapExtensionsKt.incrementCounter(wordLanguageCounts, Language.JAPANESE);
                    continue;
                }
                if (!Alphabet.LATIN.matches(character) && !Alphabet.CYRILLIC.matches(character) && !Alphabet.DEVANAGARI.matches(character)) continue;
                Sequence<Language> sequence = SequencesKt.filter(this.languagesWithUniqueCharacters, (Function1)new Function1<Language, Boolean>(character){
                    final /* synthetic */ char $character;
                    {
                        this.$character = $character;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Language it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), "it");
                        String string = it.getUniqueCharacters$lingua();
                        return string != null ? StringsKt.contains$default((CharSequence)string, this.$character, false, 2, null) : false;
                    }
                });
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Language it = (Language)((Object)element$iv);
                    boolean bl = false;
                    MapExtensionsKt.incrementCounter(wordLanguageCounts, it);
                }
            }
            if (wordLanguageCounts.isEmpty()) {
                MapExtensionsKt.incrementCounter(totalLanguageCounts, Language.UNKNOWN);
                continue;
            }
            if (wordLanguageCounts.size() == 1) {
                Language language = (Language)((Object)CollectionsKt.first(wordLanguageCounts.keySet()));
                if (this.languages.contains((Object)language)) {
                    MapExtensionsKt.incrementCounter(totalLanguageCounts, language);
                    continue;
                }
                MapExtensionsKt.incrementCounter(totalLanguageCounts, Language.UNKNOWN);
                continue;
            }
            Object $this$sortedByDescending$iv = MapsKt.toList(wordLanguageCounts);
            boolean $i$f$sortedByDescending = false;
            List sortedWordLanguageCounts = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)b;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getSecond();
                    it = (Pair)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getSecond()));
                }
            });
            $this$sortedByDescending$iv = (Pair)sortedWordLanguageCounts.get(0);
            Language mostFrequentLanguage = (Language)((Object)((Pair)$this$sortedByDescending$iv).component1());
            int firstCharCount = ((Number)((Pair)$this$sortedByDescending$iv).component2()).intValue();
            if (firstCharCount > (secondCharCount2 = ((Number)((Pair)sortedWordLanguageCounts.get(1)).component2()).intValue()) && this.languages.contains((Object)mostFrequentLanguage)) {
                MapExtensionsKt.incrementCounter(totalLanguageCounts, mostFrequentLanguage);
                continue;
            }
            MapExtensionsKt.incrementCounter(totalLanguageCounts, Language.UNKNOWN);
        }
        Integer n = (Integer)totalLanguageCounts.get((Object)Language.UNKNOWN);
        int n2 = unknownLanguageCount = n != null ? n : 0;
        if ((double)unknownLanguageCount < 0.5 * (double)words.size()) {
            totalLanguageCounts.remove((Object)Language.UNKNOWN);
        }
        if (totalLanguageCounts.isEmpty()) {
            return Language.UNKNOWN;
        }
        if (totalLanguageCounts.size() == 1) {
            return (Language)((Object)CollectionsKt.first(totalLanguageCounts.keySet()));
        }
        if (totalLanguageCounts.size() == 2 && totalLanguageCounts.containsKey((Object)Language.CHINESE) && totalLanguageCounts.containsKey((Object)Language.JAPANESE)) {
            return Language.JAPANESE;
        }
        Iterable $this$sortedByDescending$iv = MapsKt.toList(totalLanguageCounts);
        boolean $i$f$sortedByDescending = false;
        List sortedTotalLanguageCounts = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getSecond()));
            }
        });
        Pair pair = (Pair)sortedTotalLanguageCounts.get(0);
        Language mostFrequentLanguage = (Language)((Object)pair.component1());
        int firstCharCount = ((Number)pair.component2()).intValue();
        return firstCharCount == (secondCharCount = ((Number)((Pair)sortedTotalLanguageCounts.get(1)).component2()).intValue()) ? Language.UNKNOWN : mostFrequentLanguage;
    }

    @NotNull
    public final Set<Language> filterLanguagesByRules$lingua(@NotNull List<String> words) {
        Set set;
        Object v0;
        Intrinsics.checkNotNullParameter(words, "words");
        Map detectedAlphabets = new LinkedHashMap();
        block0: for (String string : words) {
            for (Alphabet alphabet : Alphabet.values()) {
                if (!alphabet.matches(string)) continue;
                MapExtensionsKt.incrementCounter(detectedAlphabets, alphabet);
                continue block0;
            }
        }
        if (detectedAlphabets.isEmpty()) {
            return this.languages;
        }
        if (detectedAlphabets.size() > 1) {
            Set distinctAlphabets = new LinkedHashSet();
            Iterator iterator2 = detectedAlphabets.values().iterator();
            while (iterator2.hasNext()) {
                int count = ((Number)iterator2.next()).intValue();
                distinctAlphabets.add(count);
            }
            if (distinctAlphabets.size() == 1) {
                return this.languages;
            }
        }
        Iterable $this$maxByOrNull$iv = detectedAlphabets.entrySet();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator3 = $this$maxByOrNull$iv.iterator();
        if (!iterator3.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator3.next();
            if (!iterator3.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Map.Entry it = (Map.Entry)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = ((Number)it.getValue()).intValue();
                do {
                    Object e$iv = iterator3.next();
                    Map.Entry it2 = (Map.Entry)e$iv;
                    boolean bl2 = false;
                    int v$iv = ((Number)it2.getValue()).intValue();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator3.hasNext());
                v0 = maxElem$iv;
            }
        }
        Map.Entry entry = v0;
        Alphabet mostFrequentAlphabet = entry != null ? (Alphabet)((Object)entry.getKey()) : null;
        Set set2 = SequencesKt.toSet(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.languages), (Function1)new Function1<Language, Boolean>(mostFrequentAlphabet){
            final /* synthetic */ Alphabet $mostFrequentAlphabet;
            {
                this.$mostFrequentAlphabet = $mostFrequentAlphabet;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Language it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), "it");
                return it.getAlphabets$lingua().contains((Object)((Object)this.$mostFrequentAlphabet));
            }
        }));
        Map languageCounts = new LinkedHashMap();
        for (Map.Entry<String, EnumSet<Language>> entry2 : Constant.INSTANCE.getCHARS_TO_LANGUAGES_MAPPING().entrySet()) {
            String characters = entry2.getKey();
            EnumSet<Language> languages = entry2.getValue();
            Set<Language> relevantLanguages = CollectionsKt.intersect((Iterable)languages, set2);
            for (String word : words) {
                int n = characters.length();
                for (int i = 0; i < n; ++i) {
                    char character = characters.charAt(i);
                    if (!StringsKt.contains$default((CharSequence)word, character, false, 2, null)) continue;
                    for (Language language : relevantLanguages) {
                        Intrinsics.checkNotNullExpressionValue((Object)language, "language");
                        MapExtensionsKt.incrementCounter(languageCounts, language);
                    }
                }
            }
        }
        Map map = languageCounts;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : map.entrySet()) {
            int it = ((Number)entry$iv.getValue()).intValue();
            boolean bl = false;
            if (!((double)it >= (double)words.size() / 2.0)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set languagesSubset = ((Map)result$iv).keySet();
        Set set3 = languagesSubset;
        if (set3.isEmpty()) {
            boolean bl = false;
            set = set2;
        } else {
            set = set3;
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Language, Float> computeLanguageProbabilities$lingua(@NotNull TestDataLanguageModel testDataModel, @NotNull Set<? extends Language> filteredLanguages2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(testDataModel, "testDataModel");
        Intrinsics.checkNotNullParameter(filteredLanguages2, "filteredLanguages");
        Map probabilities = new LinkedHashMap();
        for (Language language : filteredLanguages2) {
            probabilities.put(language, Float.valueOf(this.computeSumOfNgramProbabilities$lingua(language, testDataModel.getNgrams())));
        }
        Map $this$filter$iv = probabilities;
        boolean bl = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            if (!((double)((Number)it.getValue()).floatValue() < 0.0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    public final float computeSumOfNgramProbabilities$lingua(@NotNull Language language, @NotNull Set<Ngram> ngrams) {
        Intrinsics.checkNotNullParameter((Object)language, "language");
        Intrinsics.checkNotNullParameter(ngrams, "ngrams");
        float probabilitiesSum = 0.0f;
        Iterator<Ngram> iterator2 = ngrams.iterator();
        block0: while (iterator2.hasNext()) {
            String ngram = iterator2.next().unbox-impl();
            Iterator<Ngram> iterator3 = Ngram.rangeOfLowerOrderNgrams-impl(ngram).iterator();
            while (iterator3.hasNext()) {
                String elem = iterator3.next().unbox-impl();
                float probability = this.lookUpNgramProbability-as5wtIs$lingua(language, elem);
                if (!(probability > 0.0f)) continue;
                probabilitiesSum += (float)Math.log(probability);
                continue block0;
            }
        }
        return probabilitiesSum;
    }

    public final float lookUpNgramProbability-as5wtIs$lingua(@NotNull Language language, @NotNull String ngram) {
        EnumMap<Language, Object2FloatMap<String>> enumMap;
        Intrinsics.checkNotNullParameter((Object)language, "language");
        Intrinsics.checkNotNullParameter(ngram, "ngram");
        int ngramLength = ngram.length();
        switch (ngramLength) {
            case 5: {
                enumMap = fivegramLanguageModels;
                break;
            }
            case 4: {
                enumMap = quadrigramLanguageModels;
                break;
            }
            case 3: {
                enumMap = trigramLanguageModels;
                break;
            }
            case 2: {
                enumMap = bigramLanguageModels;
                break;
            }
            case 1: {
                enumMap = unigramLanguageModels;
                break;
            }
            case 0: {
                throw new IllegalArgumentException("Zerogram detected");
            }
            default: {
                throw new IllegalArgumentException("unsupported ngram length detected: " + ngram.length());
            }
        }
        EnumMap<Language, Object2FloatMap<String>> languageModels = enumMap;
        Object2FloatMap model = LanguageDetector.Companion.loadLanguageModels(languageModels, language, ngramLength);
        return model.getFloat(ngram);
    }

    private final void preloadLanguageModels() {
        List tasks2 = new ArrayList();
        for (Language language : this.languages) {
            tasks2.add(() -> LanguageDetector.preloadLanguageModels$lambda-29(language));
            if (this.isLowAccuracyModeEnabled) continue;
            tasks2.add(() -> LanguageDetector.preloadLanguageModels$lambda-30(language));
            tasks2.add(() -> LanguageDetector.preloadLanguageModels$lambda-31(language));
            tasks2.add(() -> LanguageDetector.preloadLanguageModels$lambda-32(language));
            tasks2.add(() -> LanguageDetector.preloadLanguageModels$lambda-33(language));
        }
        List list = ForkJoinPool.commonPool().invokeAll(tasks2);
        Intrinsics.checkNotNullExpressionValue(list, "commonPool().invokeAll(tasks)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Future it = (Future)element$iv;
            boolean bl = false;
            it.get();
        }
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof LanguageDetector) ? false : (!Intrinsics.areEqual(this.languages, ((LanguageDetector)other).languages) ? false : (!(this.minimumRelativeDistance == ((LanguageDetector)other).minimumRelativeDistance) ? false : this.isLowAccuracyModeEnabled == ((LanguageDetector)other).isLowAccuracyModeEnabled)));
    }

    public int hashCode() {
        return 31 * ((Object)this.languages).hashCode() + Double.hashCode(this.minimumRelativeDistance) + Boolean.hashCode(this.isLowAccuracyModeEnabled);
    }

    private static final Pair computeLanguageConfidenceValues$lambda-5$lambda-4$lambda-3(String $cleanedUpText, int $i, LanguageDetector this$0, Set $filteredLanguages) {
        Map<Language, Integer> map;
        Intrinsics.checkNotNullParameter($cleanedUpText, "$cleanedUpText");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($filteredLanguages, "$filteredLanguages");
        TestDataLanguageModel testDataModel = TestDataLanguageModel.Companion.fromText($cleanedUpText, $i);
        Map<Language, Float> probabilities = this$0.computeLanguageProbabilities$lingua(testDataModel, $filteredLanguages);
        if ($i == 1) {
            Set<Language> languages = probabilities.keySet();
            Set unigramFilteredLanguages2 = !((Collection)languages).isEmpty() ? SequencesKt.toSet(SequencesKt.filter(CollectionsKt.asSequence($filteredLanguages), (Function1)new Function1<Language, Boolean>(languages){
                final /* synthetic */ Set<Language> $languages;
                {
                    this.$languages = $languages;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Language it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), "it");
                    return this.$languages.contains((Object)((Object)it));
                }
            })) : $filteredLanguages;
            map = this$0.countUnigramsOfInputText$lingua(testDataModel, unigramFilteredLanguages2);
        } else {
            map = null;
        }
        Map<Language, Integer> unigramCounts2 = map;
        return new Pair<Map<Language, Float>, Map>(probabilities, unigramCounts2);
    }

    private static final Pair computeLanguageConfidenceValues$lambda-5$lambda-4(String $cleanedUpText, int $i, LanguageDetector this$0, Set $filteredLanguages) {
        Intrinsics.checkNotNullParameter($cleanedUpText, "$cleanedUpText");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($filteredLanguages, "$filteredLanguages");
        return AccessController.doPrivileged(() -> LanguageDetector.computeLanguageConfidenceValues$lambda-5$lambda-4$lambda-3($cleanedUpText, $i, this$0, $filteredLanguages));
    }

    private static final Object2FloatMap preloadLanguageModels$lambda-29(Language $language) {
        Intrinsics.checkNotNullParameter((Object)$language, "$language");
        return LanguageDetector.Companion.loadLanguageModels(LanguageDetector.trigramLanguageModels, $language, 3);
    }

    private static final Object2FloatMap preloadLanguageModels$lambda-30(Language $language) {
        Intrinsics.checkNotNullParameter((Object)$language, "$language");
        return LanguageDetector.Companion.loadLanguageModels(LanguageDetector.unigramLanguageModels, $language, 1);
    }

    private static final Object2FloatMap preloadLanguageModels$lambda-31(Language $language) {
        Intrinsics.checkNotNullParameter((Object)$language, "$language");
        return LanguageDetector.Companion.loadLanguageModels(LanguageDetector.bigramLanguageModels, $language, 2);
    }

    private static final Object2FloatMap preloadLanguageModels$lambda-32(Language $language) {
        Intrinsics.checkNotNullParameter((Object)$language, "$language");
        return LanguageDetector.Companion.loadLanguageModels(LanguageDetector.quadrigramLanguageModels, $language, 4);
    }

    private static final Object2FloatMap preloadLanguageModels$lambda-33(Language $language) {
        Intrinsics.checkNotNullParameter((Object)$language, "$language");
        return LanguageDetector.Companion.loadLanguageModels(LanguageDetector.fivegramLanguageModels, $language, 5);
    }

    static {
        Pair[] pairs$iv = new Pair[]{};
        boolean $i$f$enumMapOf = false;
        unigramLanguageModels = pairs$iv.length == 0 ? new EnumMap(Language.class) : new EnumMap(MapsKt.toMap(pairs$iv));
        pairs$iv = new Pair[]{};
        $i$f$enumMapOf = false;
        bigramLanguageModels = pairs$iv.length == 0 ? new EnumMap(Language.class) : new EnumMap(MapsKt.toMap(pairs$iv));
        pairs$iv = new Pair[]{};
        $i$f$enumMapOf = false;
        trigramLanguageModels = pairs$iv.length == 0 ? new EnumMap(Language.class) : new EnumMap(MapsKt.toMap(pairs$iv));
        pairs$iv = new Pair[]{};
        $i$f$enumMapOf = false;
        quadrigramLanguageModels = pairs$iv.length == 0 ? new EnumMap(Language.class) : new EnumMap(MapsKt.toMap(pairs$iv));
        pairs$iv = new Pair[]{};
        $i$f$enumMapOf = false;
        fivegramLanguageModels = pairs$iv.length == 0 ? new EnumMap(Language.class) : new EnumMap(MapsKt.toMap(pairs$iv));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J8\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00062\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR&\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR&\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR&\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/texboobcat/autolang/libs/lingua/api/LanguageDetector$Companion;", "", "()V", "HIGH_ACCURACY_MODE_MAX_TEXT_LENGTH", "", "bigramLanguageModels", "Ljava/util/EnumMap;", "Lorg/texboobcat/autolang/libs/lingua/api/Language;", "Lit/unimi/dsi/fastutil/objects/Object2FloatMap;", "", "getBigramLanguageModels$lingua", "()Ljava/util/EnumMap;", "fivegramLanguageModels", "getFivegramLanguageModels$lingua", "quadrigramLanguageModels", "getQuadrigramLanguageModels$lingua", "trigramLanguageModels", "getTrigramLanguageModels$lingua", "unigramLanguageModels", "getUnigramLanguageModels$lingua", "loadLanguageModel", "language", "ngramLength", "loadLanguageModels", "languageModels", "lingua"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnumMap<Language, Object2FloatMap<String>> getUnigramLanguageModels$lingua() {
            return unigramLanguageModels;
        }

        @NotNull
        public final EnumMap<Language, Object2FloatMap<String>> getBigramLanguageModels$lingua() {
            return bigramLanguageModels;
        }

        @NotNull
        public final EnumMap<Language, Object2FloatMap<String>> getTrigramLanguageModels$lingua() {
            return trigramLanguageModels;
        }

        @NotNull
        public final EnumMap<Language, Object2FloatMap<String>> getQuadrigramLanguageModels$lingua() {
            return quadrigramLanguageModels;
        }

        @NotNull
        public final EnumMap<Language, Object2FloatMap<String>> getFivegramLanguageModels$lingua() {
            return fivegramLanguageModels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Object2FloatMap<String> loadLanguageModels(EnumMap<Language, Object2FloatMap<String>> languageModels, Language language, int ngramLength) {
            Object object;
            EnumMap<Language, Object2FloatMap<String>> enumMap = languageModels;
            synchronized (enumMap) {
                block7: {
                    boolean bl = false;
                    if (!languageModels.containsKey((Object)language)) break block7;
                    Object v = MapsKt.getValue((Map)languageModels, language);
                    Intrinsics.checkNotNullExpressionValue(v, "languageModels.getValue(language)");
                    Object2FloatMap object2FloatMap = (Object2FloatMap)v;
                    return object2FloatMap;
                }
                object = Unit.INSTANCE;
            }
            Object2FloatMap<String> model = this.loadLanguageModel(language, ngramLength);
            object = languageModels;
            synchronized (object) {
                boolean bl = false;
                languageModels.putIfAbsent(language, model);
                Object v = MapsKt.getValue((Map)languageModels, language);
                Intrinsics.checkNotNullExpressionValue(v, "languageModels.getValue(language)");
                Object2FloatMap object2FloatMap = (Object2FloatMap)v;
                return object2FloatMap;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Object2FloatMap<String> loadLanguageModel(Language language, int ngramLength) {
            Object2FloatMap<String> object2FloatMap;
            String fileName = Ngram.Companion.getNgramNameByLength(ngramLength) + "s.json";
            String filePath = "/language-models/" + (Object)((Object)language.getIsoCode639_1()) + '/' + fileName;
            InputStream inputStream2 = Language.class.getResourceAsStream(filePath);
            if (inputStream2 == null) {
                return new Object2FloatOpenHashMap();
            }
            InputStream inputStream3 = inputStream2;
            Closeable closeable = inputStream3;
            TrainingDataLanguageModel.Companion companion = TrainingDataLanguageModel.Companion;
            Throwable throwable = null;
            try {
                InputStream p0 = (InputStream)closeable;
                boolean bl = false;
                object2FloatMap = companion.fromJson(p0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            return object2FloatMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

