/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.storage;

import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.texboobcat.autolang.config.ConfigManager;
import org.texboobcat.autolang.locale.Language;
import org.texboobcat.autolang.storage.PlayerLanguageStore;

public class PlayerLanguageService {
    private final ConfigManager config;
    private final PlayerLanguageStore store;
    private final Path dataFolder;
    private final Map<UUID, Integer> messageCounters = new ConcurrentHashMap<UUID, Integer>();

    public PlayerLanguageService(ConfigManager config, PlayerLanguageStore store, Path dataFolder) {
        this.config = config;
        this.store = store;
        this.dataFolder = dataFolder;
    }

    public Optional<Language> getLanguage(UUID uuid) {
        Optional<String> code = this.store.getLanguageCode(uuid);
        return code.flatMap(c -> Optional.ofNullable(this.config.getLanguageByCode((String)c)).or(() -> Optional.of(new Language((String)c, (String)c))));
    }

    public void setLanguage(UUID uuid, Language language) {
        if (language == null) {
            return;
        }
        this.store.setLanguageCode(uuid, language.getCode());
        this.resetDetectionCounter(uuid);
    }

    public boolean hasLanguage(UUID uuid) {
        return this.store.hasLanguage(uuid);
    }

    public Language getDefaultLanguage() {
        return this.config.getDefaultLanguage();
    }

    public boolean shouldAttemptDetection(UUID uuid) {
        if (!this.config.isAutodetectEnabled()) {
            return false;
        }
        int n = this.messageCounters.merge(uuid, 1, Integer::sum);
        return n >= this.config.getMinMessagesBeforeDetect();
    }

    public void resetDetectionCounter(UUID uuid) {
        this.messageCounters.remove(uuid);
    }

    public Map<UUID, String> exportAll() {
        return this.store.getAll();
    }

    public void importAll(Map<UUID, String> data2) {
        this.store.importAll(data2);
    }

    public Path getDataFolder() {
        return this.dataFolder;
    }

    public void shutdown() {
        this.store.shutdown();
    }

    public Optional<Language> resolveFromLocale(String localeString) {
        if (localeString == null || localeString.isEmpty()) {
            return Optional.empty();
        }
        try {
            String lower = localeString.toLowerCase(Locale.ROOT);
            if (this.config.isLanguageSupported(lower)) {
                return Optional.ofNullable(this.config.getLanguageByCode(lower));
            }
            String base = lower.split("[_-]")[0];
            if (this.config.isLanguageSupported(base)) {
                return Optional.ofNullable(this.config.getLanguageByCode(base));
            }
            String alt = lower.replace('_', '-');
            if (this.config.isLanguageSupported(alt)) {
                return Optional.ofNullable(this.config.getLanguageByCode(alt));
            }
            alt = lower.replace('-', '_');
            if (this.config.isLanguageSupported(alt)) {
                return Optional.ofNullable(this.config.getLanguageByCode(alt));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Optional.empty();
    }
}

