/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.storage;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.texboobcat.autolang.storage.PlayerLanguageStore;

public class SQLitePlayerLanguageStore
implements PlayerLanguageStore {
    private final Logger logger;
    private final Path dbPath;
    private Connection connection;

    public SQLitePlayerLanguageStore(Path dbPath, Logger logger) {
        this.dbPath = dbPath;
        this.logger = logger;
        this.init();
    }

    private void init() {
        try {
            if (this.dbPath.getParent() != null) {
                Files.createDirectories(this.dbPath.getParent(), new FileAttribute[0]);
            }
            Class.forName("org.texboobcat.autolang.libs.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(this.dbPath.toAbsolutePath()));
            try (Statement stmt = this.connection.createStatement();){
                stmt.execute("PRAGMA foreign_keys = ON");
                stmt.execute("CREATE TABLE IF NOT EXISTS player_languages (uuid TEXT PRIMARY KEY, language_code TEXT NOT NULL)");
            }
            this.logger.info("SQLite database initialized at: {}", (Object)this.dbPath.toAbsolutePath());
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize SQLite storage at: {}", (Object)this.dbPath.toAbsolutePath(), (Object)e);
            this.connection = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<String> getLanguageCode(UUID uuid) {
        if (this.connection == null) {
            this.logger.warn("Database connection is not available");
            return Optional.empty();
        }
        String sql = "SELECT language_code FROM player_languages WHERE uuid = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return Optional.empty();
                Optional<String> optional = Optional.of(rs.getString("language_code"));
                return optional;
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to get language for " + String.valueOf(uuid), (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public void setLanguageCode(UUID uuid, String languageCode) {
        if (this.connection == null) {
            this.logger.warn("Database connection is not available, cannot set language");
            return;
        }
        String sql = "INSERT OR REPLACE INTO player_languages (uuid, language_code) VALUES (?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            stmt.setString(2, languageCode);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.error("Failed to set language for " + String.valueOf(uuid), (Throwable)e);
        }
    }

    @Override
    public boolean hasLanguage(UUID uuid) {
        return this.getLanguageCode(uuid).isPresent();
    }

    @Override
    public Map<UUID, String> getAll() {
        HashMap<UUID, String> result2 = new HashMap<UUID, String>();
        if (this.connection == null) {
            this.logger.warn("Database connection is not available");
            return result2;
        }
        String sql = "SELECT uuid, language_code FROM player_languages";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                try {
                    UUID uuid = UUID.fromString(rs.getString("uuid"));
                    String code = rs.getString("language_code");
                    result2.put(uuid, code);
                }
                catch (IllegalArgumentException e) {
                    this.logger.warn("Invalid UUID in database: {}", (Object)rs.getString("uuid"));
                }
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to get all languages", (Throwable)e);
        }
        return result2;
    }

    @Override
    public void importAll(Map<UUID, String> data2) {
        if (this.connection == null) {
            this.logger.warn("Database connection is not available, cannot import languages");
            return;
        }
        String sql = "INSERT OR REPLACE INTO player_languages (uuid, language_code) VALUES (?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            for (Map.Entry<UUID, String> entry : data2.entrySet()) {
                stmt.setString(1, entry.getKey().toString());
                stmt.setString(2, entry.getValue());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            this.logger.error("Failed to import languages", (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.logger.info("SQLite connection closed");
            }
            catch (SQLException e) {
                this.logger.error("Failed to close SQLite connection", (Throwable)e);
            }
        }
    }
}

