/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.translate;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.texboobcat.autolang.config.ConfigManager;
import org.texboobcat.autolang.locale.Language;
import org.texboobcat.autolang.translate.TranslationEngine;

public class LocalModelEngineAdapter
implements TranslationEngine {
    private final ConfigManager config;
    private final Logger logger;

    public LocalModelEngineAdapter(ConfigManager config, Logger logger) {
        this.config = config;
        this.logger = logger;
    }

    @Override
    public String translate(String sourceText, Language from, Language to) throws Exception {
        if (sourceText == null || sourceText.isEmpty()) {
            return sourceText;
        }
        String command = this.config.getLocalModelCommand();
        if (command == null || command.isEmpty()) {
            throw new IllegalStateException("Local model command not configured");
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(command);
        cmdList.add("--from");
        cmdList.add(from.getCode());
        cmdList.add("--to");
        cmdList.add(to.getCode());
        cmdList.add("--text");
        cmdList.add(sourceText);
        ProcessBuilder pb = new ProcessBuilder(cmdList);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        StringBuilder output = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
        }
        boolean finished = process.waitFor(5L, TimeUnit.SECONDS);
        if (!finished) {
            process.destroyForcibly();
            throw new Exception("Local model process timeout");
        }
        if (process.exitValue() != 0) {
            this.logger.warn("Local model exited with code {}: {}", (Object)process.exitValue(), (Object)output);
            return sourceText;
        }
        String result2 = output.toString().trim();
        return result2.isEmpty() ? sourceText : result2;
    }

    public void shutdown() {
    }
}

