/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.translate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.texboobcat.autolang.locale.Language;
import org.texboobcat.autolang.translate.TranslationEngine;
import org.texboobcat.autolang.util.AsyncExecutor;

public class RulebookEngine
implements TranslationEngine {
    private final AsyncExecutor executor;
    private static final Map<String, Map<String, String>> DICT = new HashMap<String, Map<String, String>>();

    public RulebookEngine(AsyncExecutor executor) {
        this.executor = executor;
    }

    private static void initializeDictionaries() {
        HashMap<String, String> en_es = new HashMap<String, String>();
        en_es.put("hello", "hola");
        en_es.put("hi", "hola");
        en_es.put("hey", "oye");
        en_es.put("good morning", "buenos d\u00edas");
        en_es.put("good afternoon", "buenas tardes");
        en_es.put("good evening", "buenas tardes");
        en_es.put("good night", "buenas noches");
        en_es.put("goodbye", "adi\u00f3s");
        en_es.put("bye", "adi\u00f3s");
        en_es.put("thank you", "gracias");
        en_es.put("thanks", "gracias");
        en_es.put("please", "por favor");
        en_es.put("yes", "s\u00ed");
        en_es.put("no", "no");
        en_es.put("how are you", "c\u00f3mo est\u00e1s");
        en_es.put("i am", "soy");
        en_es.put("you are", "eres");
        DICT.put("en->es", en_es);
        HashMap<String, String> en_fr = new HashMap<String, String>();
        en_fr.put("hello", "bonjour");
        en_fr.put("hi", "salut");
        en_fr.put("hey", "salut");
        en_fr.put("good morning", "bonjour");
        en_fr.put("good evening", "bonsoir");
        en_fr.put("good night", "bonne nuit");
        en_fr.put("goodbye", "au revoir");
        en_fr.put("bye", "salut");
        en_fr.put("thank you", "merci");
        en_fr.put("thanks", "merci");
        en_fr.put("please", "s'il vous pla\u00eet");
        en_fr.put("yes", "oui");
        en_fr.put("no", "non");
        en_fr.put("how are you", "comment allez-vous");
        DICT.put("en->fr", en_fr);
        HashMap<String, String> es_en = new HashMap<String, String>();
        es_en.put("hola", "hello");
        es_en.put("buenos d\u00edas", "good morning");
        es_en.put("buenas tardes", "good afternoon");
        es_en.put("buenas noches", "good night");
        es_en.put("adi\u00f3s", "goodbye");
        es_en.put("gracias", "thank you");
        es_en.put("por favor", "please");
        es_en.put("s\u00ed", "yes");
        DICT.put("es->en", es_en);
        HashMap<String, String> fr_en = new HashMap<String, String>();
        fr_en.put("bonjour", "hello");
        fr_en.put("salut", "hi");
        fr_en.put("bonsoir", "good evening");
        fr_en.put("bonne nuit", "good night");
        fr_en.put("au revoir", "goodbye");
        fr_en.put("merci", "thank you");
        fr_en.put("oui", "yes");
        fr_en.put("non", "no");
        DICT.put("fr->en", fr_en);
    }

    @Override
    public String translate(String sourceText, Language from, Language to) throws Exception {
        if (sourceText == null || sourceText.isEmpty()) {
            return sourceText;
        }
        String key = from.getCode() + "->" + to.getCode();
        Map<String, String> dict = DICT.get(key);
        if (dict == null || dict.isEmpty()) {
            return sourceText;
        }
        String lower = sourceText.toLowerCase(Locale.ROOT);
        if (dict.containsKey(lower)) {
            return dict.get(lower);
        }
        ArrayList<String> phrases = new ArrayList<String>(dict.keySet());
        phrases.sort((a, b) -> Integer.compare(b.length(), a.length()));
        String result2 = sourceText;
        for (String phrase : phrases) {
            if (!lower.contains(phrase)) continue;
            String translation = dict.get(phrase);
            result2 = result2.replaceAll("(?i)" + Pattern.quote(phrase), translation);
        }
        return result2;
    }

    @Override
    public CompletableFuture<String> translateAsync(String sourceText, Language from, Language to, AsyncExecutor executor) {
        return executor.supplyAsync(() -> this.translate(sourceText, from, to));
    }

    static {
        RulebookEngine.initializeDictionaries();
    }
}

