/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.autolang.util;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncExecutor {
    private final ExecutorService executor;

    public AsyncExecutor(int threads) {
        int n = Math.max(1, threads);
        this.executor = new ThreadPoolExecutor(n, n, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread t = new Thread(r);
            t.setName("AutoLang-Worker");
            t.setDaemon(true);
            return t;
        });
    }

    public <T> CompletableFuture<T> supplyAsync(Callable<T> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        CompletableFuture cf = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                cf.complete(supplier.call());
            }
            catch (Throwable t) {
                cf.completeExceptionally(t);
            }
        });
        return cf;
    }

    public void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public void shutdown() {
        this.executor.shutdown();
    }
}

