/*
 * Decompiled with CFR 0.152.
 */
package me.autolang;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import me.autolang.command.LanguageCommand;
import me.autolang.config.ConfigManager;
import me.autolang.detect.HeuristicDetector;
import me.autolang.detect.LanguageDetector;
import me.autolang.detect.LinguaDetector;
import me.autolang.listener.ChatListener;
import me.autolang.listener.ClientOptionsListener;
import me.autolang.listener.JoinListener;
import me.autolang.listener.PacketChatListener;
import me.autolang.manager.TranslationManager;
import me.autolang.storage.PlayerLanguageService;
import me.autolang.storage.PlayerLanguageStore;
import me.autolang.storage.SQLitePlayerLanguageStore;
import me.autolang.storage.YamlPlayerLanguageStore;
import me.autolang.translate.LibreTranslateEngineAdapter;
import me.autolang.translate.LibreTranslateProcessManager;
import me.autolang.translate.LocalModelEngineAdapter;
import me.autolang.translate.RulebookEngine;
import me.autolang.translate.TranslationEngine;
import me.autolang.util.AsyncExecutor;
import me.autolang.util.LRUCache;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class AutoLang
extends JavaPlugin {
    private static AutoLang INSTANCE;
    private Logger log;
    private ConfigManager configManager;
    private AsyncExecutor asyncExecutor;
    private PlayerLanguageService playerLanguageService;
    private LanguageDetector languageDetector;
    private TranslationEngine translationEngine;
    private TranslationManager translationManager;
    private LibreTranslateProcessManager ltProcess;
    private PacketChatListener packetChatListener;

    public static AutoLang getInstance() {
        return INSTANCE;
    }

    public void onEnable() {
        INSTANCE = this;
        this.log = this.getLogger();
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.configManager.migrateOldStorage();
        this.configManager.load();
        this.ensureSqlitePath();
        this.asyncExecutor = new AsyncExecutor(this.configManager.getMaxTranslationThreads());
        this.playerLanguageService = new PlayerLanguageService(this.configManager, this.createStoreFromConfig(), this.getDataFolder());
        this.languageDetector = this.createDetectorFromConfig();
        if (this.configManager.isLibreTranslateManagedEnabled()) {
            this.ltProcess = new LibreTranslateProcessManager(this, this.configManager);
            this.ltProcess.start();
            if (this.configManager.getLanguages().size() < 2) {
                this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                    try {
                        this.configManager.load();
                        if ("lingua".equalsIgnoreCase(this.configManager.getDetectorType()) && this.configManager.getLanguages().size() >= 2) {
                            this.setLanguageDetector(new LinguaDetector(this.configManager));
                            this.log.info("Initialized Lingua detector after LibreTranslate became ready.");
                        }
                    }
                    catch (Throwable t) {
                        this.log.fine("Deferred language refresh failed: " + t.getMessage());
                    }
                }, 200L);
            }
        }
        this.translationEngine = this.createEngineFromConfig();
        if (this.configManager.getLanguages().size() < 3) {
            this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
                try {
                    int before = this.configManager.getLanguages().size();
                    this.configManager.load();
                    int after = this.configManager.getLanguages().size();
                    if (after > before) {
                        if ("lingua".equalsIgnoreCase(this.configManager.getDetectorType()) && after >= 2) {
                            this.setLanguageDetector(new LinguaDetector(this.configManager));
                        }
                        this.log.info("Post-start languages refresh loaded " + after + " languages.");
                    }
                }
                catch (Throwable t) {
                    this.log.fine("Post-start languages refresh failed: " + t.getMessage());
                }
            }, 60L);
        }
        LRUCache<String, String> cache2 = new LRUCache<String, String>(this.configManager.getCacheSize(), this.configManager.getCacheTtlSeconds());
        this.translationManager = new TranslationManager(this, this.asyncExecutor, this.translationEngine, cache2, this.configManager.getTranslationTimeoutMs(), this.configManager.isCacheEnabled());
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new ChatListener(this, this.configManager, this.playerLanguageService, this.translationManager), (Plugin)this);
        pm.registerEvents((Listener)new JoinListener(this, this.configManager, this.playerLanguageService), (Plugin)this);
        pm.registerEvents((Listener)new ClientOptionsListener(this, this.configManager, this.playerLanguageService), (Plugin)this);
        if (this.configManager.isPacketInterceptionEnabled()) {
            if (pm.getPlugin("ProtocolLib") != null) {
                this.packetChatListener = new PacketChatListener(this, this.configManager, this.playerLanguageService, this.translationManager);
                this.packetChatListener.register();
                this.log.info("ProtocolLib detected - packet-level chat interception enabled");
            } else {
                this.log.warning("packet-interception.enabled=true but ProtocolLib not found - install ProtocolLib to support chat plugins");
            }
        } else {
            this.log.info("Packet interception disabled - using event-based chat interception only");
        }
        LanguageCommand langCmd = new LanguageCommand(this, this.configManager, this.playerLanguageService, this.translationManager);
        this.getCommand("lang").setExecutor((CommandExecutor)langCmd);
        this.getCommand("lang").setTabCompleter((TabCompleter)langCmd);
        this.log.info("AutoLang enabled. Languages: " + this.configManager.getLanguages().size() + ", threads: " + this.configManager.getMaxTranslationThreads());
    }

    public void onDisable() {
        TranslationEngine translationEngine;
        if (this.packetChatListener != null) {
            this.packetChatListener.unregister();
        }
        if ((translationEngine = this.translationEngine) instanceof LocalModelEngineAdapter) {
            LocalModelEngineAdapter adapter = (LocalModelEngineAdapter)translationEngine;
            adapter.shutdown();
        }
        if (this.ltProcess != null) {
            this.ltProcess.stop();
        }
        if (this.asyncExecutor != null) {
            this.asyncExecutor.shutdown();
        }
        if (this.playerLanguageService != null) {
            this.playerLanguageService.shutdown();
        }
        this.log.info("AutoLang disabled.");
    }

    private LanguageDetector createDetectorFromConfig() {
        String type2 = this.configManager.getDetectorType();
        if (type2 != null && type2.equalsIgnoreCase("lingua")) {
            if (this.configManager.getLanguages().size() >= 2) {
                return new LinguaDetector(this.configManager);
            }
            this.log.warning("Lingua detector selected but fewer than 2 languages are configured; falling back to heuristic detector.");
            return new HeuristicDetector(this.configManager);
        }
        return new HeuristicDetector(this.configManager);
    }

    private TranslationEngine createEngineFromConfig() {
        if (this.configManager.isLibreTranslateEnabled() || this.configManager.isLibreTranslateManagedEnabled()) {
            return new LibreTranslateEngineAdapter(this.configManager, this.asyncExecutor, this.log);
        }
        if (this.configManager.isLocalModelEnabled() && this.configManager.getLocalModelCommand() != null && !this.configManager.getLocalModelCommand().isEmpty()) {
            return new LocalModelEngineAdapter(this.configManager, this.asyncExecutor, this.log);
        }
        return new RulebookEngine(this.asyncExecutor);
    }

    private void ensureSqlitePath() {
        String file;
        if ("sqlite".equalsIgnoreCase(this.configManager.getStorageType()) && (file = this.configManager.getSqliteFile()) != null && !file.isEmpty()) {
            try {
                Path p = Path.of(file, new String[0]).toAbsolutePath();
                File parent = p.getParent().toFile();
                if (!parent.exists()) {
                    Files.createDirectories(parent.toPath(), new FileAttribute[0]);
                }
            }
            catch (Exception e) {
                this.log.warning("Failed to ensure sqlite path: " + e.getMessage());
            }
        }
    }

    private PlayerLanguageStore createStoreFromConfig() {
        String type2 = this.configManager.getStorageType();
        if ("yaml".equalsIgnoreCase(type2)) {
            return new YamlPlayerLanguageStore(this);
        }
        return new SQLitePlayerLanguageStore(this.configManager, this.getLogger());
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public AsyncExecutor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public PlayerLanguageService getPlayerLanguageService() {
        return this.playerLanguageService;
    }

    public LanguageDetector getLanguageDetector() {
        return this.languageDetector;
    }

    public void setLanguageDetector(LanguageDetector detector) {
        this.languageDetector = detector;
    }

    public TranslationManager getTranslationManager() {
        return this.translationManager;
    }

    public LibreTranslateProcessManager getLibreTranslateProcessManager() {
        return this.ltProcess;
    }

    public LibreTranslateProcessManager ensureLibreTranslateProcessManager() {
        if (this.ltProcess == null) {
            this.ltProcess = new LibreTranslateProcessManager(this, this.configManager);
        }
        return this.ltProcess;
    }
}

