/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.autolang.locale.Language;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class ChatTranslatedEvent
extends Event
implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();
    private final Player sender;
    private final String original;
    private final Map<Language, String> translations;
    private boolean cancelled;

    public ChatTranslatedEvent(Player sender, String original, Map<Language, String> translations) {
        super(true);
        this.sender = sender;
        this.original = original;
        this.translations = new HashMap<Language, String>(translations);
    }

    public Player getSender() {
        return this.sender;
    }

    public String getOriginal() {
        return this.original;
    }

    public Map<Language, String> getTranslations() {
        return Collections.unmodifiableMap(this.translations);
    }

    public void setTranslation(Language lang, String text) {
        this.translations.put(lang, text);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

