/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.command;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import me.autolang.AutoLang;
import me.autolang.config.ConfigManager;
import me.autolang.detect.HeuristicDetector;
import me.autolang.detect.LinguaDetector;
import me.autolang.libs.gson.Gson;
import me.autolang.libs.gson.GsonBuilder;
import me.autolang.locale.Language;
import me.autolang.manager.TranslationManager;
import me.autolang.storage.PlayerLanguageService;
import me.autolang.translate.LibreTranslateEngineAdapter;
import me.autolang.translate.LocalModelEngineAdapter;
import me.autolang.translate.RulebookEngine;
import me.autolang.translate.TranslationEngine;
import me.autolang.util.LRUCache;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LanguageCommand
implements CommandExecutor,
TabCompleter {
    private final AutoLang plugin;
    private final ConfigManager cfg;
    private PlayerLanguageService pls;
    private final TranslationManager manager;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public LanguageCommand(AutoLang plugin, ConfigManager cfg, PlayerLanguageService pls, TranslationManager manager) {
        this.plugin = plugin;
        this.cfg = cfg;
        this.pls = pls;
        this.manager = manager;
    }

    private void handleLt(CommandSender sender, String[] args2) {
        String action;
        if (!sender.hasPermission("autolang.admin.lt")) {
            sender.sendMessage("No permission.");
            return;
        }
        if (args2.length < 2) {
            sender.sendMessage("Usage: /lang lt <start|stop|status>");
            return;
        }
        switch (action = args2[1].toLowerCase(Locale.ROOT)) {
            case "start": {
                if (!this.cfg.isLibreTranslateManagedEnabled()) {
                    sender.sendMessage("Enable libretranslate.managed.enabled in config.yml first.");
                    return;
                }
                boolean ok = this.plugin.ensureLibreTranslateProcessManager().start();
                sender.sendMessage(ok ? "Starting managed LibreTranslate (see console logs)." : "Failed to start managed LibreTranslate. See console.");
                break;
            }
            case "stop": {
                boolean was = this.plugin.ensureLibreTranslateProcessManager().stop();
                sender.sendMessage(was ? "Stopped managed LibreTranslate." : "Managed LibreTranslate was not running.");
                break;
            }
            case "status": {
                boolean running = this.plugin.ensureLibreTranslateProcessManager().isRunning();
                sender.sendMessage((String)(running ? "Running at " + this.plugin.getConfigManager().getLibreTranslateBaseUrl() : "Not running."));
                break;
            }
            default: {
                sender.sendMessage("Usage: /lang lt <start|stop|status>");
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        String sub;
        if (args2.length == 0) {
            this.sendHelp(sender, label);
            return true;
        }
        switch (sub = args2[0].toLowerCase(Locale.ROOT)) {
            case "set": {
                this.handleSet(sender, args2);
                break;
            }
            case "view": {
                this.handleView(sender, args2);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "importmodel": {
                this.handleImportModel(sender, args2);
                break;
            }
            case "export": {
                this.handleExport(sender, args2);
                break;
            }
            case "import": {
                this.handleImport(sender, args2);
                break;
            }
            case "gc": {
                this.handleGc(sender);
                break;
            }
            case "health": {
                this.handleHealth(sender);
                break;
            }
            case "lt": {
                this.handleLt(sender, args2);
                break;
            }
            default: {
                this.sendHelp(sender, label);
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender, String label) {
        sender.sendMessage("/" + label + " set <code|client> [player] - Set language (client uses player's current client locale)");
        sender.sendMessage("/" + label + " view [player] - View language");
        if (sender.hasPermission("autolang.admin.reload")) {
            sender.sendMessage("/" + label + " reload - Reload config");
        }
        if (sender.hasPermission("autolang.admin.importmodel")) {
            sender.sendMessage("/" + label + " importModel <path> - Register local model command");
        }
        if (sender.hasPermission("autolang.admin.export")) {
            sender.sendMessage("/" + label + " export [file] - Export player languages to JSON");
        }
        if (sender.hasPermission("autolang.admin.import")) {
            sender.sendMessage("/" + label + " import <file> - Import player languages from JSON");
        }
        if (sender.hasPermission("autolang.admin.gc")) {
            sender.sendMessage("/" + label + " gc - Clear caches");
        }
        if (sender.hasPermission("autolang.admin.health")) {
            sender.sendMessage("/" + label + " health - Check translation backend connectivity");
        }
        if (sender.hasPermission("autolang.admin.lt")) {
            sender.sendMessage("/" + label + " lt <start|stop|status> - Manage embedded LibreTranslate");
        }
    }

    private void handleSet(CommandSender sender, String[] args2) {
        if (args2.length < 2) {
            sender.sendMessage("Usage: /lang set <code> [player]");
            return;
        }
        String code = args2[1].toLowerCase(Locale.ROOT);
        if ("client".equals(code)) {
            if (args2.length >= 3) {
                if (!sender.hasPermission("autolang.admin.set")) {
                    sender.sendMessage("You do not have permission to set other players' language.");
                    return;
                }
                Player target = Bukkit.getPlayerExact((String)args2[2]);
                if (target == null) {
                    sender.sendMessage("Player not found or not online.");
                    return;
                }
                Optional<Language> maybe = this.pls.resolveFromLocale(target.locale());
                if (maybe.isEmpty()) {
                    sender.sendMessage("Could not map the player's client locale to a configured language.");
                    return;
                }
                Language lang = maybe.get();
                this.pls.setLanguage(target.getUniqueId(), lang);
                sender.sendMessage("Set language for " + target.getName() + " to " + lang.getName() + " (" + lang.getCode() + ") from client locale.");
                target.sendMessage("Your language was set to " + lang.getName() + " (" + lang.getCode() + ") by an admin (from your client settings).");
                return;
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage("Console must specify a player: /lang set client <player>");
                return;
            }
            Player p = (Player)sender;
            Optional<Language> maybe = this.pls.resolveFromLocale(p.locale());
            if (maybe.isEmpty()) {
                sender.sendMessage("Could not map your client locale to a configured language.");
                return;
            }
            Language lang = maybe.get();
            this.pls.setLanguage(p.getUniqueId(), lang);
            sender.sendMessage("Your language is now " + lang.getName() + " (" + lang.getCode() + ") (from your client settings)");
            return;
        }
        if (!this.cfg.isLanguageSupported(code)) {
            sender.sendMessage("Unknown language code. Available: " + this.cfg.getLanguages().stream().map(Language::getCode).collect(Collectors.joining(", ")));
            return;
        }
        Language lang = this.cfg.getLanguageByCode(code);
        if (args2.length >= 3) {
            if (!sender.hasPermission("autolang.admin.set")) {
                sender.sendMessage("You do not have permission to set other players' language.");
                return;
            }
            Player target = Bukkit.getPlayerExact((String)args2[2]);
            if (target == null) {
                sender.sendMessage("Player not found or not online.");
                return;
            }
            this.pls.setLanguage(target.getUniqueId(), lang);
            sender.sendMessage("Set language for " + target.getName() + " to " + lang.getName() + " (" + lang.getCode() + ")");
            target.sendMessage("Your language was set to " + lang.getName() + " (" + lang.getCode() + ") by an admin.");
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Console must specify a player: /lang set <code> <player>");
                return;
            }
            Player p = (Player)sender;
            this.pls.setLanguage(p.getUniqueId(), lang);
            sender.sendMessage("Your language is now " + lang.getName() + " (" + lang.getCode() + ")");
        }
    }

    private void handleView(CommandSender sender, String[] args2) {
        if (args2.length >= 2) {
            Player target = Bukkit.getPlayerExact((String)args2[1]);
            if (target == null) {
                sender.sendMessage("Player not found or not online.");
                return;
            }
            Language lang = this.pls.getLanguage(target.getUniqueId()).orElse(this.pls.getDefaultLanguage());
            sender.sendMessage(target.getName() + " language: " + lang.getName() + " (" + lang.getCode() + ")");
        } else if (sender instanceof Player) {
            Player p = (Player)sender;
            Language lang = this.pls.getLanguage(p.getUniqueId()).orElse(this.pls.getDefaultLanguage());
            sender.sendMessage("Your language: " + lang.getName() + " (" + lang.getCode() + ")");
        } else {
            sender.sendMessage("Console must specify a player: /lang view <player>");
        }
    }

    private void handleReload(CommandSender sender) {
        if (!sender.hasPermission("autolang.admin.reload")) {
            sender.sendMessage("No permission.");
            return;
        }
        this.plugin.reloadConfig();
        this.cfg.load();
        if (this.cfg.isLibreTranslateManagedEnabled()) {
            this.plugin.ensureLibreTranslateProcessManager().start();
        } else if (this.plugin.getLibreTranslateProcessManager() != null && this.plugin.getLibreTranslateProcessManager().isRunning()) {
            this.plugin.getLibreTranslateProcessManager().stop();
        }
        if ("lingua".equalsIgnoreCase(this.cfg.getDetectorType())) {
            this.plugin.setLanguageDetector(new LinguaDetector(this.cfg));
        } else {
            this.plugin.setLanguageDetector(new HeuristicDetector(this.cfg));
        }
        TranslationEngine engine = this.cfg.isLibreTranslateEnabled() || this.cfg.isLibreTranslateManagedEnabled() ? new LibreTranslateEngineAdapter(this.cfg, this.plugin.getAsyncExecutor(), this.plugin.getLogger()) : (this.cfg.isLocalModelEnabled() && this.cfg.getLocalModelCommand() != null && !this.cfg.getLocalModelCommand().isEmpty() ? new LocalModelEngineAdapter(this.cfg, this.plugin.getAsyncExecutor(), this.plugin.getLogger()) : new RulebookEngine(this.plugin.getAsyncExecutor()));
        this.manager.setEngine(engine);
        this.manager.reload(this.cfg.getTranslationTimeoutMs(), this.cfg.isCacheEnabled(), new LRUCache<String, String>(this.cfg.getCacheSize(), this.cfg.getCacheTtlSeconds()));
        sender.sendMessage("AutoLang reloaded.");
    }

    private void handleImportModel(CommandSender sender, String[] args2) {
        if (!sender.hasPermission("autolang.admin.importmodel")) {
            sender.sendMessage("No permission.");
            return;
        }
        if (args2.length < 2) {
            sender.sendMessage("Usage: /lang importModel <path>");
            return;
        }
        String path = args2[1];
        this.plugin.getConfig().set("local-model.enabled", (Object)true);
        this.plugin.getConfig().set("local-model.command", (Object)path);
        this.plugin.saveConfig();
        this.cfg.load();
        LocalModelEngineAdapter engine = new LocalModelEngineAdapter(this.cfg, this.plugin.getAsyncExecutor(), this.plugin.getLogger());
        this.manager.setEngine(engine);
        sender.sendMessage("Local model command set. Using LocalModelEngineAdapter.");
    }

    private void handleExport(CommandSender sender, String[] args2) {
        if (!sender.hasPermission("autolang.admin.export")) {
            sender.sendMessage("No permission.");
            return;
        }
        File outFile = args2.length >= 2 ? new File(args2[1]) : new File(this.plugin.getDataFolder(), "players.json");
        this.plugin.getAsyncExecutor().execute(() -> {
            try (BufferedWriter writer = Files.newBufferedWriter(outFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                Map<UUID, String> data2 = this.pls.exportAll();
                this.gson.toJson(data2, (Appendable)writer);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("Exported " + data2.size() + " players to " + outFile.getAbsolutePath()));
            }
            catch (Exception e) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("Export failed: " + e.getMessage()));
            }
        });
    }

    private void handleImport(CommandSender sender, String[] args2) {
        if (!sender.hasPermission("autolang.admin.import")) {
            sender.sendMessage("No permission.");
            return;
        }
        if (args2.length < 2) {
            sender.sendMessage("Usage: /lang import <file>");
            return;
        }
        File inFile = new File(args2[1]);
        if (!inFile.exists()) {
            sender.sendMessage("File not found: " + inFile.getAbsolutePath());
            return;
        }
        this.plugin.getAsyncExecutor().execute(() -> {
            try (BufferedReader br = Files.newBufferedReader(inFile.toPath(), StandardCharsets.UTF_8);){
                Map map = this.gson.fromJson((Reader)br, Map.class);
                HashMap<UUID, String> converted = new HashMap<UUID, String>();
                for (Map.Entry e : map.entrySet()) {
                    try {
                        converted.put(UUID.fromString((String)e.getKey()), (String)e.getValue());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                this.pls.importAll(converted);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("Imported " + converted.size() + " player entries."));
            }
            catch (Exception ex) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage("Import failed: " + ex.getMessage()));
            }
        });
    }

    private void handleGc(CommandSender sender) {
        if (!sender.hasPermission("autolang.admin.gc")) {
            sender.sendMessage("No permission.");
            return;
        }
        this.manager.clearCache();
        System.gc();
        sender.sendMessage("Caches cleared.");
    }

    private void handleHealth(CommandSender sender) {
        if (!sender.hasPermission("autolang.admin.health")) {
            sender.sendMessage("No permission.");
            return;
        }
        String base = this.cfg.getLibreTranslateBaseUrl();
        if (!(base.contains("127.0.0.1") || base.toLowerCase(Locale.ROOT).contains("localhost") || this.cfg.isLibreTranslateAllowRemote())) {
            sender.sendMessage("LibreTranslate base-url is remote but allow-remote is false.");
            return;
        }
        try {
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).build();
            URI uri = URI.create(base.endsWith("/") ? base + "languages" : base + "/languages");
            HttpRequest req = HttpRequest.newBuilder(uri).timeout(Duration.ofSeconds(5L)).GET().build();
            client.sendAsync(req, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).whenComplete((resp, ex) -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (ex != null) {
                    sender.sendMessage("Health check failed: " + ex.getClass().getSimpleName() + ": " + ex.getMessage());
                    return;
                }
                if (resp.statusCode() == 200) {
                    sender.sendMessage("LibreTranslate reachable at " + base + " (\u2713)");
                    sender.sendMessage("Languages payload size: " + Math.max(1, ((String)resp.body()).length()));
                } else {
                    sender.sendMessage("LibreTranslate responded with status " + resp.statusCode());
                }
            }));
        }
        catch (Exception e) {
            sender.sendMessage("Health check failed: " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args2) {
        if (args2.length == 1) {
            ArrayList<String> subs = new ArrayList<String>(List.of("set", "view"));
            if (sender.hasPermission("autolang.admin.reload")) {
                subs.add("reload");
            }
            if (sender.hasPermission("autolang.admin.importmodel")) {
                subs.add("importModel");
            }
            if (sender.hasPermission("autolang.admin.export")) {
                subs.add("export");
            }
            if (sender.hasPermission("autolang.admin.import")) {
                subs.add("import");
            }
            if (sender.hasPermission("autolang.admin.gc")) {
                subs.add("gc");
            }
            if (sender.hasPermission("autolang.admin.health")) {
                subs.add("health");
            }
            if (sender.hasPermission("autolang.admin.lt")) {
                subs.add("lt");
            }
            return subs.stream().filter(s -> s.startsWith(args2[0].toLowerCase(Locale.ROOT))).toList();
        }
        if (args2.length == 2) {
            String sub = args2[0].toLowerCase(Locale.ROOT);
            if (sub.equals("set")) {
                ArrayList<String> options = new ArrayList<String>();
                options.add("client");
                options.addAll(this.cfg.getLanguages().stream().map(Language::getCode).toList());
                return options.stream().filter(c -> c.startsWith(args2[1].toLowerCase(Locale.ROOT))).sorted().toList();
            }
            if (sub.equals("lt")) {
                List<String> acts = List.of("start", "stop", "status");
                return acts.stream().filter(a -> a.startsWith(args2[1].toLowerCase(Locale.ROOT))).toList();
            }
            if (sub.equals("view")) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(n -> n.toLowerCase(Locale.ROOT).startsWith(args2[1].toLowerCase(Locale.ROOT))).sorted().toList();
            }
        }
        if (args2.length == 3 && args2[0].equalsIgnoreCase("set")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(n -> n.toLowerCase(Locale.ROOT).startsWith(args2[2].toLowerCase(Locale.ROOT))).sorted().toList();
        }
        return Collections.emptyList();
    }
}

