/*
 * Decompiled with CFR 0.152.
 */
package me.autolang.config;

import java.io.File;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import me.autolang.AutoLang;
import me.autolang.libs.gson.JsonArray;
import me.autolang.libs.gson.JsonElement;
import me.autolang.libs.gson.JsonObject;
import me.autolang.libs.gson.JsonParser;
import me.autolang.locale.Language;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final AutoLang plugin;
    private final Logger log;
    private Map<String, Language> languagesByCode = new HashMap<String, Language>();
    private Language defaultLanguage;
    private boolean languagesAutoFromLibreTranslate;
    private Set<String> languagesInclude = new HashSet<String>();
    private Set<String> languagesExclude = new HashSet<String>();
    private Map<String, String> languagesOverrideNames = new HashMap<String, String>();
    private int maxTranslationThreads;
    private int translationTimeoutMs;
    private boolean cacheEnabled;
    private int cacheSize;
    private int cacheTtlSeconds;
    private boolean autodetectEnabled;
    private int minMessagesBeforeDetect;
    private double autodetectConfidenceThreshold;
    private boolean clientLocaleEnabled;
    private boolean clientLocaleAutoAccept;
    private boolean clientLocaleOnChange;
    private String storageType;
    private String sqliteFile;
    private boolean logMessages;
    private boolean packetInterceptionEnabled;
    private List<Map<String, Object>> customChatFormats = new ArrayList<Map<String, Object>>();
    private boolean localModelEnabled;
    private String localModelCommand;
    private boolean allowRemote;
    private String detectorType;
    private boolean libreTranslateEnabled;
    private String libreTranslateBaseUrl;
    private boolean libreTranslateAllowRemote;
    private boolean libreTranslateInsecureTls;
    private String libreTranslateApiKey;
    private boolean libreTranslateManagedEnabled;
    private String libreTranslateManagedCommand;
    private int libreTranslateManagedPort;
    private String libreTranslateManagedLoadOnly;
    private boolean libreTranslateManagedDownloadModels;
    private String libreTranslateManagedExtraArgs;
    private boolean libreTranslateManagedWatchdogEnabled;
    private int libreTranslateManagedWatchdogIntervalSeconds;
    private int libreTranslateManagedWatchdogRestartThreshold;
    private boolean libreTranslateManagedBootstrapEnabled;
    private String libreTranslateManagedBootstrapPython;
    private volatile String libreTranslateBaseUrlOverride;

    public ConfigManager(AutoLang plugin) {
        this.plugin = plugin;
        this.log = plugin.getLogger();
    }

    public void migrateOldStorage() {
        FileConfiguration cfg = this.plugin.getConfig();
        boolean changed = false;
        if (cfg.contains("sqlite-file") && !cfg.contains("storage.sqlite-file")) {
            String path = cfg.getString("sqlite-file");
            cfg.set("storage.sqlite-file", (Object)path);
            changed = true;
        }
        if (changed) {
            this.plugin.saveConfig();
        }
    }

    public void load() {
        ConfigurationSection lm;
        this.plugin.reloadConfig();
        FileConfiguration cfg = this.plugin.getConfig();
        ConfigurationSection ltPre = cfg.getConfigurationSection("libretranslate");
        if (ltPre != null) {
            String preBase = ltPre.getString("base-url", null);
            if (preBase != null && !preBase.isBlank()) {
                this.libreTranslateBaseUrl = preBase;
            }
            this.libreTranslateAllowRemote = ltPre.getBoolean("allow-remote", this.libreTranslateAllowRemote);
            this.libreTranslateInsecureTls = ltPre.getBoolean("insecure-tls", this.libreTranslateInsecureTls);
            String preKey = ltPre.getString("api-key", null);
            if (preKey != null) {
                this.libreTranslateApiKey = preKey;
            }
        }
        this.languagesByCode.clear();
        this.languagesInclude.clear();
        this.languagesExclude.clear();
        this.languagesOverrideNames.clear();
        boolean legacyList = cfg.isList("languages");
        if (legacyList) {
            List list = cfg.getMapList("languages");
            for (Object m : list) {
                Object codeObj = m.get("code");
                String string = codeObj == null ? "" : String.valueOf(codeObj).trim().toLowerCase(Locale.ROOT);
                Object nameObj = m.get("name");
                String string2 = name = nameObj == null ? string : String.valueOf(nameObj).trim();
                if (string.isEmpty()) continue;
                this.languagesByCode.put(string, new Language(string, name));
            }
        } else {
            ConfigurationSection langsSec = cfg.getConfigurationSection("languages");
            if (langsSec != null) {
                Object nameObj;
                String code;
                this.languagesAutoFromLibreTranslate = langsSec.getBoolean("auto-from-libretranslate", false);
                this.languagesInclude.addAll(langsSec.getStringList("include").stream().map(s -> s.toLowerCase(Locale.ROOT)).toList());
                this.languagesExclude.addAll(langsSec.getStringList("exclude").stream().map(s -> s.toLowerCase(Locale.ROOT)).toList());
                List staticList = langsSec.getMapList("static");
                for (Object m : staticList) {
                    String name;
                    Object v = m.get("code");
                    code = v == null ? "" : String.valueOf(v).trim().toLowerCase(Locale.ROOT);
                    nameObj = m.get("name");
                    String string = name = nameObj == null ? code : String.valueOf(nameObj).trim();
                    if (code.isEmpty()) continue;
                    this.languagesByCode.put(code, new Language(code, name));
                }
                List overrides = langsSec.getMapList("overrides");
                for (Map map : overrides) {
                    Object codeObj = map.get("code");
                    nameObj = map.get("name");
                    if (codeObj == null || nameObj == null) continue;
                    String code2 = String.valueOf(codeObj).trim().toLowerCase(Locale.ROOT);
                    String name = String.valueOf(nameObj).trim();
                    this.languagesOverrideNames.put(code2, name);
                }
                if (this.languagesAutoFromLibreTranslate) {
                    Map<String, Language> fromLt = this.fetchLanguagesFromLibreTranslateSafely();
                    if (!fromLt.isEmpty()) {
                        this.languagesByCode.putAll(fromLt);
                        this.log.info("Loaded " + fromLt.size() + " languages from LibreTranslate /languages");
                    } else {
                        this.log.warning("languages.auto-from-libretranslate=true but failed to fetch from LibreTranslate; falling back to static list");
                    }
                }
                for (Map.Entry entry : this.languagesOverrideNames.entrySet()) {
                    code = (String)entry.getKey();
                    name = (String)entry.getValue();
                    if (!this.languagesByCode.containsKey(code)) continue;
                    this.languagesByCode.put(code, new Language(code, name));
                }
                if (!this.languagesInclude.isEmpty()) {
                    this.languagesByCode.keySet().retainAll(this.languagesInclude);
                }
                if (!this.languagesExclude.isEmpty()) {
                    for (String string : this.languagesExclude) {
                        this.languagesByCode.remove(string);
                    }
                }
            }
        }
        if (this.languagesByCode.size() < 2) {
            this.languagesByCode.putIfAbsent("en", new Language("en", "English"));
            if (!this.languagesByCode.containsKey("es")) {
                this.languagesByCode.put("es", new Language("es", "Espa\u00f1ol"));
            }
        }
        String defCode = cfg.getString("default-language", "en").toLowerCase(Locale.ROOT);
        this.defaultLanguage = this.languagesByCode.getOrDefault(defCode, new Language(defCode, defCode));
        this.log.info("Languages configured: " + this.languagesByCode.size() + ", default=" + this.defaultLanguage.getCode());
        this.maxTranslationThreads = Math.max(1, cfg.getInt("max-translation-threads", 4));
        this.translationTimeoutMs = Math.max(500, cfg.getInt("translation-timeout-ms", 3000));
        ConfigurationSection cacheSec = cfg.getConfigurationSection("cache");
        if (cacheSec != null) {
            this.cacheEnabled = cacheSec.getBoolean("enabled", true);
            this.cacheSize = Math.max(0, cacheSec.getInt("size", 500));
            this.cacheTtlSeconds = Math.max(0, cacheSec.getInt("ttl-seconds", 0));
        } else {
            this.cacheEnabled = true;
            this.cacheSize = 500;
            this.cacheTtlSeconds = 0;
        }
        ConfigurationSection det = cfg.getConfigurationSection("detector");
        this.detectorType = det != null ? det.getString("type", "lingua") : "lingua";
        ConfigurationSection ad = cfg.getConfigurationSection("autodetect");
        if (ad != null) {
            this.autodetectEnabled = ad.getBoolean("enabled", true);
            this.minMessagesBeforeDetect = Math.max(1, ad.getInt("min-messages-before-detect", 3));
            this.autodetectConfidenceThreshold = Math.min(1.0, Math.max(0.0, ad.getDouble("confidence-threshold", 0.8)));
        } else {
            this.autodetectEnabled = true;
            this.minMessagesBeforeDetect = 3;
            this.autodetectConfidenceThreshold = 0.8;
        }
        ConfigurationSection configurationSection = cfg.getConfigurationSection("client-locale");
        if (configurationSection != null) {
            this.clientLocaleEnabled = configurationSection.getBoolean("enabled", true);
            this.clientLocaleAutoAccept = configurationSection.getBoolean("auto-accept", true);
            this.clientLocaleOnChange = configurationSection.getBoolean("on-change", true);
        } else {
            this.clientLocaleEnabled = true;
            this.clientLocaleAutoAccept = true;
            this.clientLocaleOnChange = true;
        }
        this.storageType = cfg.getString("storage.type", "sqlite");
        this.sqliteFile = cfg.getString("storage.sqlite-file", cfg.getString("sqlite-file", "plugins/AutoLang/languages.db"));
        this.logMessages = cfg.getBoolean("privacy.log-messages", false);
        ConfigurationSection pi = cfg.getConfigurationSection("packet-interception");
        if (pi != null) {
            this.packetInterceptionEnabled = pi.getBoolean("enabled", true);
            List rawList = pi.getMapList("custom-formats");
            this.customChatFormats = new ArrayList<Map<String, Object>>();
            for (Map map : rawList) {
                HashMap converted = new HashMap();
                for (Map.Entry entry : map.entrySet()) {
                    converted.put(String.valueOf(entry.getKey()), entry.getValue());
                }
                this.customChatFormats.add(converted);
            }
        } else {
            this.packetInterceptionEnabled = true;
            this.customChatFormats = new ArrayList<Map<String, Object>>();
        }
        if ((lm = cfg.getConfigurationSection("local-model")) != null) {
            this.localModelEnabled = lm.getBoolean("enabled", false);
            this.localModelCommand = lm.getString("command", "");
            this.allowRemote = lm.getBoolean("allow-remote", false);
        } else {
            this.localModelEnabled = false;
            this.localModelCommand = "";
            this.allowRemote = false;
        }
        ConfigurationSection lt = cfg.getConfigurationSection("libretranslate");
        if (lt != null) {
            this.libreTranslateEnabled = lt.getBoolean("enabled", false);
            this.libreTranslateBaseUrl = lt.getString("base-url", "http://127.0.0.1:5000");
            this.libreTranslateAllowRemote = lt.getBoolean("allow-remote", false);
            this.libreTranslateInsecureTls = lt.getBoolean("insecure-tls", false);
            this.libreTranslateApiKey = lt.getString("api-key", "");
            ConfigurationSection managed = lt.getConfigurationSection("managed");
            if (managed != null) {
                this.libreTranslateManagedEnabled = managed.getBoolean("enabled", false);
                this.libreTranslateManagedCommand = managed.getString("command", "");
                this.libreTranslateManagedPort = Math.max(1, managed.getInt("port", 5000));
                this.libreTranslateManagedLoadOnly = managed.getString("load-only", "en,es,fr");
                this.libreTranslateManagedDownloadModels = managed.getBoolean("download-models", true);
                this.libreTranslateManagedExtraArgs = managed.getString("extra-args", "");
                ConfigurationSection wd = managed.getConfigurationSection("watchdog");
                if (wd != null) {
                    this.libreTranslateManagedWatchdogEnabled = wd.getBoolean("enabled", true);
                    this.libreTranslateManagedWatchdogIntervalSeconds = Math.max(1, wd.getInt("interval-seconds", 15));
                    this.libreTranslateManagedWatchdogRestartThreshold = Math.max(1, wd.getInt("restart-threshold", 3));
                } else {
                    this.libreTranslateManagedWatchdogEnabled = true;
                    this.libreTranslateManagedWatchdogIntervalSeconds = 15;
                    this.libreTranslateManagedWatchdogRestartThreshold = 3;
                }
                ConfigurationSection bs = managed.getConfigurationSection("bootstrap");
                if (bs != null) {
                    this.libreTranslateManagedBootstrapEnabled = bs.getBoolean("enabled", true);
                    this.libreTranslateManagedBootstrapPython = bs.getString("python", "");
                } else {
                    this.libreTranslateManagedBootstrapEnabled = true;
                    this.libreTranslateManagedBootstrapPython = "";
                }
            } else {
                this.libreTranslateManagedEnabled = false;
                this.libreTranslateManagedCommand = "";
                this.libreTranslateManagedPort = 5000;
                this.libreTranslateManagedLoadOnly = "en,es,fr";
                this.libreTranslateManagedDownloadModels = true;
                this.libreTranslateManagedExtraArgs = "";
                this.libreTranslateManagedWatchdogEnabled = true;
                this.libreTranslateManagedWatchdogIntervalSeconds = 15;
                this.libreTranslateManagedWatchdogRestartThreshold = 3;
                this.libreTranslateManagedBootstrapEnabled = true;
                this.libreTranslateManagedBootstrapPython = "";
            }
        } else {
            this.libreTranslateEnabled = false;
            this.libreTranslateBaseUrl = "http://127.0.0.1:5000";
            this.libreTranslateAllowRemote = false;
            this.libreTranslateInsecureTls = false;
            this.libreTranslateApiKey = "";
            this.libreTranslateManagedEnabled = false;
            this.libreTranslateManagedCommand = "";
            this.libreTranslateManagedPort = 5000;
            this.libreTranslateManagedLoadOnly = "en,es,fr";
            this.libreTranslateManagedDownloadModels = true;
            this.libreTranslateManagedExtraArgs = "";
            this.libreTranslateManagedWatchdogEnabled = true;
            this.libreTranslateManagedWatchdogIntervalSeconds = 15;
            this.libreTranslateManagedWatchdogRestartThreshold = 3;
            this.libreTranslateManagedBootstrapEnabled = true;
            this.libreTranslateManagedBootstrapPython = "";
        }
        File df = this.plugin.getDataFolder();
        if (!df.exists()) {
            df.mkdirs();
        }
        this.log.fine("Config loaded: languages=" + this.languagesByCode.size());
    }

    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public Collection<Language> getLanguages() {
        return Collections.unmodifiableCollection(this.languagesByCode.values());
    }

    public boolean isLanguageSupported(String code) {
        return this.languagesByCode.containsKey(code.toLowerCase(Locale.ROOT));
    }

    public Language getLanguageByCode(String code) {
        return this.languagesByCode.get(code.toLowerCase(Locale.ROOT));
    }

    public int getMaxTranslationThreads() {
        return this.maxTranslationThreads;
    }

    public int getTranslationTimeoutMs() {
        return this.translationTimeoutMs;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getCacheTtlSeconds() {
        return this.cacheTtlSeconds;
    }

    public boolean isAutodetectEnabled() {
        return this.autodetectEnabled;
    }

    public int getMinMessagesBeforeDetect() {
        return this.minMessagesBeforeDetect;
    }

    public double getAutodetectConfidenceThreshold() {
        return this.autodetectConfidenceThreshold;
    }

    public boolean isClientLocaleEnabled() {
        return this.clientLocaleEnabled;
    }

    public boolean isClientLocaleAutoAccept() {
        return this.clientLocaleAutoAccept;
    }

    public boolean isClientLocaleOnChange() {
        return this.clientLocaleOnChange;
    }

    public String getDetectorType() {
        return this.detectorType;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public String getSqliteFile() {
        return this.sqliteFile;
    }

    public boolean isLogMessages() {
        return this.logMessages;
    }

    public boolean isPacketInterceptionEnabled() {
        return this.packetInterceptionEnabled;
    }

    public List<Map<String, Object>> getCustomChatFormats() {
        return this.customChatFormats;
    }

    public boolean isLocalModelEnabled() {
        return this.localModelEnabled;
    }

    public String getLocalModelCommand() {
        return this.localModelCommand;
    }

    public boolean isAllowRemote() {
        return this.allowRemote;
    }

    public boolean isLibreTranslateEnabled() {
        return this.libreTranslateEnabled;
    }

    public String getLibreTranslateBaseUrl() {
        return this.libreTranslateBaseUrlOverride != null ? this.libreTranslateBaseUrlOverride : this.libreTranslateBaseUrl;
    }

    public boolean isLibreTranslateAllowRemote() {
        return this.libreTranslateAllowRemote;
    }

    public boolean isLibreTranslateInsecureTls() {
        return this.libreTranslateInsecureTls;
    }

    public boolean isLibreTranslateManagedEnabled() {
        return this.libreTranslateManagedEnabled;
    }

    public String getLibreTranslateManagedCommand() {
        return this.libreTranslateManagedCommand;
    }

    public int getLibreTranslateManagedPort() {
        return this.libreTranslateManagedPort;
    }

    public String getLibreTranslateManagedLoadOnly() {
        return this.libreTranslateManagedLoadOnly;
    }

    public boolean isLibreTranslateManagedDownloadModels() {
        return this.libreTranslateManagedDownloadModels;
    }

    public String getLibreTranslateManagedExtraArgs() {
        return this.libreTranslateManagedExtraArgs;
    }

    public boolean isLibreTranslateManagedWatchdogEnabled() {
        return this.libreTranslateManagedWatchdogEnabled;
    }

    public int getLibreTranslateManagedWatchdogIntervalSeconds() {
        return this.libreTranslateManagedWatchdogIntervalSeconds;
    }

    public int getLibreTranslateManagedWatchdogRestartThreshold() {
        return this.libreTranslateManagedWatchdogRestartThreshold;
    }

    public boolean isLibreTranslateManagedBootstrapEnabled() {
        return this.libreTranslateManagedBootstrapEnabled;
    }

    public String getLibreTranslateManagedBootstrapPython() {
        return this.libreTranslateManagedBootstrapPython;
    }

    public void setLibreTranslateBaseUrlOverride(String baseUrl) {
        this.libreTranslateBaseUrlOverride = baseUrl;
    }

    private Map<String, Language> fetchLanguagesFromLibreTranslateSafely() {
        try {
            return this.fetchLanguagesFromLibreTranslate();
        }
        catch (Exception e) {
            this.log.warning("Failed to fetch LT languages: " + e.getClass().getSimpleName() + ": " + e.getMessage());
            return Collections.emptyMap();
        }
    }

    private Map<String, Language> fetchLanguagesFromLibreTranslate() throws Exception {
        JsonElement parsed;
        boolean isLocal;
        HashMap<String, Language> map = new HashMap<String, Language>();
        String base = this.getLibreTranslateBaseUrl();
        if (base == null || base.isBlank()) {
            return map;
        }
        String lower = base.toLowerCase(Locale.ROOT);
        boolean bl = isLocal = lower.contains("127.0.0.1") || lower.contains("localhost") || lower.contains("0.0.0.0");
        if (!isLocal && !this.isLibreTranslateAllowRemote()) {
            this.log.warning("Skipping LibreTranslate languages fetch: base-url is remote and allow-remote is false");
            return map;
        }
        URI uri = URI.create(this.buildLtUrl(base, "/languages"));
        this.log.info("Requesting LibreTranslate languages from: " + String.valueOf(uri));
        HttpClient.Builder builder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS);
        if (lower.startsWith("https") && this.isLibreTranslateInsecureTls()) {
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                TrustManager[] trustAll = new TrustManager[]{new X509TrustManager(this){

                    @Override
                    public void checkClientTrusted(X509Certificate[] xcs, String s) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] xcs, String s) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                sc.init(null, trustAll, new SecureRandom());
                builder.sslContext(sc);
                this.log.warning("Using insecure TLS for LibreTranslate fetch; trust-all certificates enabled.");
            }
            catch (Exception e) {
                this.log.warning("Failed to init insecure TLS context: " + e.getMessage());
            }
        }
        HttpClient client = builder.build();
        HttpRequest.Builder reqBuilder = HttpRequest.newBuilder(uri).GET().header("Accept", "application/json");
        if (this.libreTranslateApiKey != null && !this.libreTranslateApiKey.isBlank()) {
            reqBuilder.header("Authorization", "Bearer " + this.libreTranslateApiKey);
        }
        HttpResponse<String> resp = client.send(reqBuilder.build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        String body = resp.body();
        if (resp.statusCode() != 200) {
            this.log.warning("/languages returned status " + resp.statusCode() + "; trying /v2/languages ...");
            URI uri2 = URI.create(this.buildLtUrl(base, "/v2/languages"));
            HttpRequest.Builder req2 = HttpRequest.newBuilder(uri2).GET().header("Accept", "application/json");
            if (this.libreTranslateApiKey != null && !this.libreTranslateApiKey.isBlank()) {
                req2.header("Authorization", "Bearer " + this.libreTranslateApiKey);
            }
            resp = client.send(req2.build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            body = resp.body();
            if (resp.statusCode() != 200) {
                int len = body == null ? 0 : Math.min(256, body.length());
                throw new IllegalStateException("LibreTranslate languages fetch failed: status=" + resp.statusCode() + ", body-preview=" + (body == null ? "" : body.substring(0, len)) + ")");
            }
        }
        if (!(parsed = JsonParser.parseString(body)).isJsonArray()) {
            this.log.warning("LibreTranslate languages response is not a JSON array.");
            return map;
        }
        JsonArray arr = parsed.getAsJsonArray();
        for (JsonElement el : arr) {
            String override;
            String name;
            if (!el.isJsonObject()) continue;
            JsonObject obj = el.getAsJsonObject();
            String code = obj.has("code") ? obj.get("code").getAsString() : null;
            String string = name = obj.has("name") ? obj.get("name").getAsString() : null;
            if (code == null || code.isBlank()) continue;
            code = code.trim().toLowerCase(Locale.ROOT);
            if (name == null || name.isBlank()) {
                name = code;
            }
            if ((override = this.languagesOverrideNames.get(code)) != null && !override.isBlank()) {
                name = override;
            }
            map.put(code, new Language(code, name));
        }
        return map;
    }

    private String buildLtUrl(String base, String path) {
        String b = base.endsWith("/") ? base.substring(0, base.length() - 1) : base;
        Object p = path.startsWith("/") ? path : "/" + path;
        String url = b + (String)p;
        if (this.libreTranslateApiKey != null && !this.libreTranslateApiKey.isBlank()) {
            try {
                String sep = url.contains("?") ? "&" : "?";
                url = url + sep + "api_key=" + URLEncoder.encode(this.libreTranslateApiKey, StandardCharsets.UTF_8);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }
}

